<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["gruppencp"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if(!isset($_GET["show"]))
{
  $leadergruppen = array();
  $membergruppen = array();
  $wartengruppen = array();
  $nichtgruppen  = array();

  // alle geleiteten gruppen-ids in einen array stecken
  $leadergruppenresult = sql_select("id, titel", "gruppen", "WHERE leader=".$user["id"]." ORDER BY id ASC", NULL, NULL);
  while($leadergruppenid = sql_fetch_assoc($leadergruppenresult))
  {
    $leadergruppen[] = $leadergruppenid["id"];
  }
  // alle nur-mitglieds-gruppen-ids in einen array stecken
  $membergruppenresult = sql_select("gruppe_id", "gruppenmembers", "WHERE user_id=".$user["id"]." AND akzeptiert=1 ORDER BY gruppe_id ASC", NULL, NULL);
  while($membergruppenid = sql_fetch_assoc($membergruppenresult))
  {
    if(!in_array($membergruppenid["gruppe_id"],$leadergruppen)) $membergruppen[] = $membergruppenid["gruppe_id"];
  }
  // alle warten-gruppen-ids in einen array stecken
  $wartengruppenresult = sql_select("gruppe_id", "gruppenmembers", "WHERE user_id=".$user["id"]." AND akzeptiert=0 ORDER BY gruppe_id ASC", NULL, NULL);
  while($wartengruppenid = sql_fetch_assoc($wartengruppenresult))
  {
    if(!in_array($wartengruppenid["gruppe_id"],$leadergruppen)) $wartengruppen[] = $wartengruppenid["gruppe_id"];
  }
  // alle nicht-mitglieds-gruppen in einen array stecken
  $nichtgruppenresult = sql_select("id", "gruppen", "WHERE leader!=".$user["id"]." ORDER BY id ASC", NULL, NULL);
  while($nichtgruppenid = sql_fetch_assoc($nichtgruppenresult))
  {
    if(!in_array($nichtgruppenid["id"],$membergruppen) and !in_array($nichtgruppenid["id"],$wartengruppen)) $nichtgruppen[] = $nichtgruppenid["id"];
  }

  ?>
  <h3>bersicht</h3>
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="2"><b>Von Ihnen geleitete Gruppen:</b></td>
  </tr>
  <?php
  $zeile = 2;
  foreach($leadergruppen as $id)
  {
    $gruppe = sql_fetch_assoc(sql_select("id, titel", "gruppen", "WHERE id=".$id, NULL, NULL));
    ?>
    <tr class="row<?php echo $zeile ?>">
      <td><?php echo $gruppe["id"] ?></td>
      <td><a href="index.php?action=gruppencp&amp;show=info&amp;id=<?php echo $gruppe["id"] ?>"><?php echo $gruppe["titel"] ?></a></td>
    </tr>
    <?php
    $zeile++;
    if ($zeile>2) $zeile=1;
  }
  ?>
  <tr class="rowberschrift">
    <td colspan="2"><b>Gruppen, in denen Sie Mitglied sind</b></td>
  </tr>
  <?php
  $zeile = 2;
  foreach($membergruppen as $id)
  {
    $gruppe = sql_fetch_assoc(sql_select("id, titel", "gruppen", "WHERE id=".$id, NULL, NULL));
    ?>
    <tr class="row<?php echo $zeile ?>">
      <td><?php echo $gruppe["id"] ?></td>
      <td><a href="index.php?action=gruppencp&amp;show=info&amp;id=<?php echo $gruppe["id"] ?>"><?php echo $gruppe["titel"] ?></a></td>
    </tr>
    <?php
    $zeile++;
    if ($zeile>2) $zeile=1;
  }
  ?>
  <tr class="rowberschrift">
    <td colspan="2"><b>Gruppen mit beantragter Mitgliedschaft</b></td>
  </tr>
  <?php
  $zeile = 2;
  foreach($wartengruppen as $id)
  {
    $gruppe = sql_fetch_assoc(sql_select("id, titel", "gruppen", "WHERE id=".$id, NULL, NULL));
    ?>
    <tr class="row<?php echo $zeile ?>">
      <td><?php echo $gruppe["id"] ?></td>
      <td><a href="index.php?action=gruppencp&amp;show=info&amp;id=<?php echo $gruppe["id"] ?>"><?php echo $gruppe["titel"] ?></a></td>
    </tr>
    <?php
    $zeile++;
    if ($zeile>2) $zeile=1;
  }
  ?>
  <tr class="rowberschrift">
    <td colspan="2"><b>Gruppen ohne Mitgliedschaft</b></td>
  </tr>
  <?php
  $zeile = 2;
  foreach($nichtgruppen as $id)
  {
    $gruppe = sql_fetch_assoc(sql_select("id, titel", "gruppen", "WHERE id=".$id, NULL, NULL));
    ?>
    <tr class="row<?php echo $zeile ?>">
      <td><?php echo $gruppe["id"] ?></td>
      <td><a href="index.php?action=gruppencp&amp;show=info&amp;id=<?php echo $gruppe["id"] ?>"><?php echo $gruppe["titel"] ?></a></td>
    </tr>
    <?php
    $zeile++;
    if ($zeile>2) $zeile=1;
  }
  ?>
  </table>
<?php
}
//************************************* info ********************************************
if(isset($_GET["show"]) and $_GET["show"] == "info")
{
  // info ber gruppenrechte usw., gruppen-mitglieder, ggf. wartende mitglieder und akzeptier-knpfe, u.a. anzeigen
  $gruppe = sql_fetch_assoc(sql_select("*", "gruppen", "WHERE id=".$_GET["id"], NULL, NULL));
  $leader = sql_fetch_assoc(sql_select("id, username", "users", "WHERE id=".$gruppe["leader"], NULL, NULL));
  ?>
  <h3><?php echo $gruppe["titel"] ?></h3>
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="2"><b>Allgemeines:</b></td>
  </tr>
  <tr class="row2">
    <td>Beschreibung:</td><td><?php echo $gruppe["beschreibung"] ?></td>
  </tr>
  <tr class="row2">
    <td>Leiter:</td><td><?php if($rechte["memberlist"] == true) { ?><a href="index.php?action=userinfo&amp;id=<?php echo $leader["id"] ?>"><?php } echo $leader["username"]; if($rechte["memberlist"] == true) echo "</a>" ?></td>
  </tr>
  <?php
  if($user["id"] != $gruppe["leader"] and $gruppe["id"] != 1 and $user["id"] != 1)
  {
    ?>
    <tr class="row2">
      <td colspan="2" align="center">
    <?php
    $mitgliedsresult = sql_select("akzeptiert", "gruppenmembers", "WHERE user_id=".$user["id"]." AND gruppe_id=".$gruppe["id"], NULL, NULL);
    if(sql_num_rows($mitgliedsresult) == 0)
    {
      ?>Sie sind hier kein Mitglied. <a href="index.php?action=gruppencp&amp;show=beitreten&amp;gruppe=<?php echo $gruppe["id"] ?>">beitreten</a><?php
    }
    else
    {
      $mitglied = sql_fetch_assoc($mitgliedsresult);
      if($mitglied["akzeptiert"] == 0)
      {
        ?>Sie sind noch nicht akzeptiert worden. <?php
      }
      else
      {
        ?>Sie hier Mitglied. <?php
      }
      ?> <a href="index.php?action=gruppencp&amp;show=entfernen&amp;gruppe=<?php echo $gruppe["id"] ?>">abmelden</a><?php
    } 
    ?></td>
    </tr>
    <?php
  }
  ?>
  <tr class="rowberschrift">
    <td colspan="2"><b>Rechte:</b></td>
  </tr>
  <tr class="row2">
    <td>Boards bearbeiten:</td><td><i>Diese Funktion fehlt noch!</i></td>
  </tr>
  <tr class="row2">
    <td>Admin-Rechte:</td><td><?php if($gruppe["admin"]==1) echo " Ja"; else echo " Nein" ?></td>
  </tr>
  <tr class="row2">
    <td>Mailbox benutzen:</td><td><?php if($gruppe["mailbox"]==1) echo " Ja"; else echo " Nein" ?></td>
  </tr>
  <tr class="row2">
    <td>Kalender aufrufen:</td><td><?php if($gruppe["kalender"]==1) echo " Ja"; else echo " Nein" ?></td>
  </tr>
  <tr class="row2">
    <td>Mitglieder anzeigen:</td><td><?php if($gruppe["memberlist"]==1) echo " Ja"; else echo " Nein" ?></td>
  </tr>
  <tr class="row2">
    <td>Gruppen-CP anzeigen:</td><td><?php if($gruppe["gruppencp"]==1) echo " Ja"; else echo " Nein" ?></td>
  </tr>
  <tr class="row2">
    <td>E-Mails senden:</td><td><?php if($gruppe["sendmail"]==1) echo " Ja"; else echo " Nein" ?></td>
  </tr>
  <tr class="row2">
    <td>Suche benutzen:</td><td><?php if($gruppe["suche"]==1) echo " Ja"; else echo " Nein" ?></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2"><b>Mitglieder:</b></td>
  </tr>
  <?php
  $gruppenmembers = sql_select("user_id", "gruppenmembers", "WHERE gruppe_id=".$_GET["id"]." AND akzeptiert=1", NULL, NULL);
  $zeile = 2;
  while($gruppenmember = sql_fetch_assoc($gruppenmembers))
  {
    $member = sql_fetch_assoc(sql_select("id, username", "users", "WHERE id=".$gruppenmember["user_id"], NULL, NULL));
    if($member["id"] != $gruppe["leader"] and $member["id"] != 1)
    {
      ?>
      <tr class="row<?php echo $zeile ?>">
        <td><?php if($rechte["memberlist"] == true) { ?><a href="index.php?action=userinfo&amp;id=<?php echo $member["id"] ?>"><?php } echo $member["username"]; if($rechte["memberlist"] == true) echo "</a>" ?></td>
        <td><?php
        if($user["id"] == $gruppe["leader"])
        {
          ?>
          <a href="index.php?action=gruppencp&amp;show=entfernen&amp;gruppe=<?php echo $gruppe["id"] ?>&amp;user=<?php echo $member["id"] ?>">entfernen</a>
          <?php
        }
        ?></td>
      </tr>
      <?php
      $zeile++;
      if($zeile > 2) $zeile = 1;
    }
  }
  ?>
  <tr class="rowberschrift">
    <td colspan="2"><b>Wartende Benutzer:</b></td>
  </tr>
  <?php
  $gruppenmembers = sql_select("user_id", "gruppenmembers", "WHERE gruppe_id=".$_GET["id"]." AND akzeptiert=0", NULL, NULL);
  $zeile = 2;
  while($gruppenmember = sql_fetch_assoc($gruppenmembers))
  {
    $member = sql_fetch_assoc(sql_select("id, username", "users", "WHERE id=".$gruppenmember["user_id"], NULL, NULL));
    ?>
    <tr class="row<?php echo $zeile ?>">
      <td><?php if($rechte["memberlist"] == true) { ?><a href="index.php?action=userinfo&amp;id=<?php echo $member["id"] ?>"><?php } echo $member["username"]; if($rechte["memberlist"] == true) echo "</a>" ?></td>
      <td><?php
      if($user["id"] == $gruppe["leader"])
      {
        ?>
        <a href="index.php?action=gruppencp&amp;show=akzeptieren&amp;gruppe=<?php echo $gruppe["id"] ?>&amp;user=<?php echo $member["id"] ?>">akzeptieren</a>
        <a href="index.php?action=gruppencp&amp;show=entfernen&amp;gruppe=<?php echo $gruppe["id"] ?>&amp;user=<?php echo $member["id"] ?>">entfernen</a>
        <?php
      }
      ?></td>
    </tr>
    <?php
    $zeile++;
    if($zeile > 2) $zeile = 1;
  }
  ?> 
  </table>
  <?php
}
//*********************************** entfernen *****************************************
if(isset($_GET["show"]) and $_GET["show"] == "entfernen")
{
  ?><h3>Benutzer aus Gruppe entfernen</h3><?php
  $gruppe = sql_fetch_assoc(sql_select("id, titel, leader", "gruppen", "WHERE id=".$_GET["gruppe"], NULL, NULL));
  if(isset($_GET["user"]))
  {
    $member = sql_fetch_assoc(sql_select("id, username", "users", "WHERE id=".$_GET["user"], NULL, NULL));
  }
  else
  {
    $member["id"] = $user["id"];
    $member["username"] = $user["username"];
  }
  // rechte?
  if(isset($_GET["user"]) and $user["id"] != $gruppe["leader"]) fehler("Sie sind nicht Leiter der Gruppe!");
  // ist er berhaupt mitglied?
  if(sql_num_rows(sql_query("*", "gruppenmembers", "WHERE user_id=".$member["id"]." AND gruppe_id=".$gruppe["id"], NULL, NULL)) == 0) fehler("Der Benutzer ist berhaupt kein Mitglied der Gruppe!");

  if(!isset($_POST["entfernen"]))
  {
    // besttigung holen
    ?>
    <form method="POST" action="index.php?action=gruppencp&amp;show=entfernen&amp;gruppe=<?php echo $gruppe["id"]; if(isset($_GET["user"])) { ?>&amp;user=<?php echo $member["id"]; } ?>">
    Wollen Sie den Benutzer "<?php echo $member["username"] ?>" wirklich aus der Gruppe "<?php echo $gruppe["titel"] ?>" entfernen?<br />
    <input name="entfernen" type="submit" value="entfernen" />
    </form>
    <?php
  }
  else
  {
    // ist das seine letzte gruppe?
    $membergruppen = sql_select("*", "gruppenmembers", "WHERE user_id=".$member["id"]." and akzeptiert=1", NULL, NULL);
    if(sql_num_rows($membergruppen) == 1)
    {
      // ja -> ist er schon in der standard-gruppe?
      $membergruppe = sql_fetch_assoc($membergruppen);
      if($membergruppe["gruppe_id"] == $einstellungen["standardgruppe"])
      {
        // benutzer nicht entfernen, weil er sonst keine gruppe mehr htte
        redir("index.php?action=gruppencp&show=info&id=".$gruppe["id"], "Der Benutzer kann nicht aus der Standardgruppe entfernt werden, wenn diese seine einzige Gruppe ist!");
      }
      else
      {
        // benutzer entfernen und zur standard-gruppe hinzufgen
        $werte = array("user_id" => $member["id"], "gruppe_id" => $einstellungen["standardgruppe"], "akzeptiert" => 1);
        sql_insert("gruppenmembers", $werte);
        sql_delete("gruppenmembers", "WHERE user_id=".$member["id"]." and gruppe_id=".$gruppe["id"]);
        redir("index.php?action=gruppencp&show=info&id=".$gruppe["id"], "Der Benutzer wurde erfolgreich in die Standard-Gruppe verschoben!");
      }
    }
    else
    {
      // nein -> benutzer einfach entfernen
      sql_delete("gruppenmembers", "WHERE user_id=".$member["id"]." and gruppe_id=".$gruppe["id"]);
      redir("index.php?action=gruppencp&show=info&id=".$gruppe["id"], "Der Benutzer wurde erfolgreich entfernt!");
    }
  }
}
//*********************************** beitreten *****************************************
if(isset($_GET["show"]) and $_GET["show"] == "beitreten")
{
  // nicht dass er schon mitglied ist?
  $members = sql_select("akzeptiert", "gruppenmembers", "WHERE gruppe_id=".$_GET["gruppe"]." AND user_id=".$user["id"], NULL, NULL);
  if(sql_num_rows($members) != 0 or $user["id"] == 1) fehler("Sie sind schon Mitglied oder warten auf Mitgliedschaft!");
  // user zur gruppenmembers-tabelle hinzufgen  
  $werte = array("user_id" => $user["id"], $gruppe_id => $_GET["gruppe"], "akzeptiert" => 0);
  sql_insert("gruppenmembers", $werte);
  redir("index.php?action=gruppencp&show=info&id=".$_GET["gruppe"], "Sie mssen jetzt noch vom Gruppenleiter akzeptiert werden, um Mitglied zu werden.");
}
//********************************* akzeptieren *****************************************
if(isset($_GET["show"]) and $_GET["show"] == "akzeptieren")
{
  $gruppe = sql_fetch_assoc(sql_select("id, leader", "gruppen", "WHERE id=".$_GET["gruppe"], NULL, NULL));
  if($user["id"] != $gruppe["leader"]) fehler("Sie sind nicht der Leiter der Gruppe!");
  $werte = array("akzeptiert" => 1);  
  sql_update("gruppenmembers", $werte, "WHERE user_id=".$_GET["user"]." AND gruppe_id=".$gruppe["id"]);
  redir("index.php?action=gruppencp&show=info&id=".$gruppe["id"], "Der Benutzer ist jetzt Mitglied der Gruppe!");
}
?>
