<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");
?>
<?php
// Shows page header
$theme["page-title"] = _("Query");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
  <h1><?php echo _("Query");?></h1>
  
  <h2><?php echo _("Basic search");?></h2>
  <p><?php echo _("The basic search will look for occurrences of each word in either the <i>Author</i>, <i>Title</i>, <i>Editor</i>, <i>Abstract</i>, <i>Keywords</i> and <i>Comments</i> fields.  Use <tt>!</tt> before a word to indicate it must not appear in any of those fields.  The search is not case sensitive.");?></p>
  <form name="basic" method="post" action="<?php echo menu_url("basic-query");?>">
  <input type="text" size="40" name="basic-text"/>
  <input type="submit" value="<?php echo _("Search");?>"/>
  </form>
  
  <h2><?php echo _("Full text search");?></h2>
  <p><?php echo _("The full text search looks in the plain text field of records for the expression entered.  Only records that have plain text available will be searched for.");?></p>
  <form name="full-text" method="post" action="<?php echo menu_url("full-text-query");?>">
  <input type="text" size="40" name="full-text"/>
  <input type="submit" value="<?php echo _("Search");?>"/><br/>
  <input type="radio" name="field" value="comments"/>&nbsp;<?php echo _("Search in comments");?>
  <input type="radio" name="field" value="fulltext" checked="checked"/>&nbsp;<?php echo _("Search in full text");?>
  </form>
  
  <h2><?php echo _("Name list search");?></h2>
  <p><?php echo _("Enter a list of names separated by carriage returns.  The search will return any paper entries whose authors or editors match one of the names in the list.  (On each line, the search engine ignores anything that follows the first non-alphabetical character, so affiliations between parentheses or after a comma are not part of the search.)");?></p>
  <form name="who-list" method="post" action="<?php echo menu_url("name-list-query");?>">
  <textarea name="name-list" rows="5" cols="40" ></textarea><br/>
  <input type="checkbox" name="googleit"/> <?php echo _("Display Google's");?>
  <select name="google-max-hits">
    <option value="1">1</option>
    <option value="2">2</option>
    <option value="3">3</option>
    <option value="4" selected>4</option>
  </select> first hits<br/>
  <input type="submit" value="<?php echo _("Search");?>"/>
  </form>  

<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2008-03-08";
show_theme_part("page-lower-body");
?>
