<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Checks if a POST entry has been given
if (!$_POST["bibtex"])
  die("No BibTeX entry has been given.");

$bibtexEntry = $_POST["bibtex"];

// Replaces pairs of quotes by opening-closing braces
$rep = "{";
while($pos = strpos($bibtexEntry, "\""))
{
  $bibtexEntry = substr_replace($bibtexEntry, $rep, $pos, 1);
  if ($rep == "{")
    $rep = "}";
  else
    $rep = "{";
}

// Numbers accolades to ease regular expression matching
$p_count = 0;
for ($i = 0; $i < strlen($bibtexEntry); $i++)
{
  if ($bibtexEntry[$i] == "{")
  {
    $p_count++;
    if ($p_count <= 2 && $p_count > 0)
    {
      $bibtexEntry = substr($bibtexEntry, 0, $i + 1).$p_count.".".substr($bibtexEntry, $i + 1, strlen($bibtexEntry) - $i);
    }
  }
  elseif ($bibtexEntry[$i] == "}")
  {
    if ($p_count <= 2 && $p_count > 0)
    {
      $bibtexEntry = substr($bibtexEntry, 0, $i).".".$p_count.substr($bibtexEntry, $i, strlen($bibtexEntry) - $i + 1);
      $i += 2;
    }
    $p_count--;
  }
}

// Strips newline characters (since unable to enter re.DOTALL regex mode in PHP)
$bibtexEntry = preg_replace('/[ \\t\\n\\r\\f]+/', ' ', $bibtexEntry);

// Counts number of references, entry type and name
$errors = 0;
$errorstring = "";
$entries = array();
$papers = array();
$papercount = 0;
preg_match_all("/@(.*?){1.(.*?),(.*?)1}/s", $bibtexEntry, $entries, PREG_SET_ORDER);

foreach ($entries as $toparse)
{
  // For each entry, finds parameters
  $array_matches = array();
  preg_match_all("/\s*?(\w*)\s*?=\s*?{2.(.*?).2}/", $toparse[3], $array_matches, PREG_SET_ORDER);
  
  // Checks if the bibtex key already exists
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE identifierBibtex = '".db_encode($toparse[2])."'");
  if ($result && db_num_rows($result) > 0)
  {
    // Key already exists; paper already added
    $errors++;
    $errorstring .= "<li>"._("BibTeX paper key ")."<tt>".htmlentities($toparse[2])."</tt> "._("already exists. Paper was not added.")."</li>\n";
    continue;
  }
  
  // Generates the insertion MySQL query string
  $query_string = "INSERT INTO ".$config["ddDBPrefix"]."publication SET identifierBibtex = '".db_encode($toparse[2])."', typeBibtex = '".db_encode(strtolower($toparse[1]))."', insertionDate = '".date("Y-m-d")."', insertionTime = '".date("H:i:s")."'";
  $id_bibtex = db_encode($entries[$i][2][0]);
  $authorindex = -1;
  for ($j = 0; $j < count($array_matches); $j++)
  {
    if (strtolower($array_matches[$j][1]) != "chapter" && strtolower($array_matches[$j][1]) != "year")
    {
      $query_string = $query_string.", bibtex".ucfirst(strtolower($array_matches[$j][1]))." = '".db_encode(latex2utf($array_matches[$j][2]))."'";
      if (strtolower($array_matches[$j][1]) == "author")
        $authorindex = $j;
    }
    else
      // Two entries are of integer type, and hence do not need the ''
      $query_string = $query_string.", bibtex".ucfirst(strtolower($array_matches[$j][1]))." = ".db_encode(latex2utf($array_matches[$j][2]));
  }

  // Adds the entry to the database (i.e. executes the generated query)
  $result = db_query($db, $query_string);
  if (!$result)
  {
    $errorstring = $errorstring."<li>"._("No result on insertion of entry #").($i + 1)." (<tt>".$toparse[2]."</tt>); ". _("maybe an error, see below if MySQL says something").":<br/>".db_error($db)."</li>\n";
    $errors++;
  }
  else
  {
    $papers[$papercount] = db_encode(latex2utf($toparse[2]));
    $papercount++;
  }
  
  // Checks whether the "auto-add authors" has been checked
  if ($_POST["autoadd"] && $_POST["autoadd"] == "1")
  {
    
    $authoradd = 0;
    $authormerge = 0;
    // Adds authors, if the author field is present
    if ($authorindex >= 0)
    {
      $authors = explode(" and ", $array_matches[$authorindex][2]);
      for ($i = 0; $i < count($authors); $i++)
      {
        $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."author WHERE TRIM(CONCAT(IF(firstName <> '', CONCAT(firstName, ' '), ''), IF(vonPart <> '', CONCAT(vonPart, ' '), ''), IF(lastName <> '', CONCAT(lastName, ' '), ''), IF(jrPart <> '', CONCAT(jrPart, ' '), ''))) = '".db_encode(trim($authors[$i]))."';");
        if (!$result)
          echo db_error($db);
        $row2 = db_fetch_assoc_array($result);
        if ($row2)
        {
          // This author is in the database
          $authormerge++;
        }
        else
        {
          // This author is not in the database: add it
          $exploded_name = explode_author_name(latex2utf(trim($authors[$i])));
          $result = db_query($db, "INSERT INTO ".$config["ddDBPrefix"]."author SET firstName = '".db_encode($exploded_name[0])."', vonPart = '".db_encode($exploded_name[1])."', lastName = '".db_encode($exploded_name[2])."', jrPart = '".db_encode($exploded_name[3])."';");
          if (!$result)
            echo db_error($db);
          $authoradd++;
        }
      }
    }
  }
}

// Shows page header
$theme["page-title"] = _("Summary of addition");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>

<h1><?php echo _("Summary of addition");?></h1>

<p><?php echo $papercount._(" entrie(s) added out of ").count($entries);?>.</p>

<?php
if ($papercount > 0)
{
  echo "<ul class=\"paperbullet\">\n";
}
foreach ($papers as $key)
{
  // Gets BibTeX identifier of newly added paper
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE identifierBibtex LIKE '".db_encode(latex2utf($key))."';");
  if (!$result)
    echo db_error($db);
  $row = db_fetch_assoc_array($result);
  echo "<li class=\"paperbullethollow\">".format_paper_entry($db, $row, PRESENTATION_REGULAR)."</li>\n";
}
if ($papercount > 0)
{
  echo "</ul>\n";
}

if ($_POST["autoadd"] == "1" && (count($entries) - $errors > 0))
{
  echo "<p>"._("Auto-add authors selected:");
  if ($authorindex >= 0)
  {
    echo $authormerge._(" author(s) merged and ").$authoradd._(" new author(s) added.");
  }
  else
  {
    echo _("no <i>Author</i> field found in the entry.");
  }
  echo "</p>\n";
}
if ($errors > 0)
{
  echo "<p>"._("Error messages").":</p>\n";
  echo "<ul>\n".$errorstring."</ul>";
}


// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2008-02-01";
show_theme_part("page-lower-body");
// :folding=explicit:wrap=none:
?>
