<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Formats category string
// NOTE: pattern has to escape category separator since it is a "/"
// This might change if you change category separator!
$category_string = preg_replace("/\\".CAT_SEPARATOR."\\s+/", CAT_SEPARATOR, trim($_POST["categoryPath"]));

// Updates the database
$result = db_query($db, "UPDATE ".$config["ddDBPrefix"]."publication SET "
  ." identifierBibtex = ".((trim($_POST["identifierBibtex"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["identifierBibtex"])))."', ")
  ." bibtexAddress = ".((trim($_POST["bibtexAddress"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexAddress"])))."', ")
  ." bibtexAffiliation = ".((trim($_POST["bibtexAffiliation"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexAffiliation"])))."', ")
  ." bibtexAnnote = ".((trim($_POST["bibtexAnnote"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexAnnote"])))."', ")
  ." bibtexAuthor = ".((trim($_POST["bibtexAuthor"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexAuthor"])))."', ")
  ." bibtexBibsource = ".((trim($_POST["bibtexBibsource"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexBibsource"])))."', ")
  ." bibtexBooktitle = ".((trim($_POST["bibtexBooktitle"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexBooktitle"])))."', ")
  ." bibtexChapter = ".((trim($_POST["bibtexChapter"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexChapter"])))."', ")
  ." bibtexCrossref = ".((trim($_POST["bibtexCrossref"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexCrossref"])))."', ")
  ." bibtexCopyright = ".((trim($_POST["bibtexCopyright"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexCopyright"])))."', ")
  ." bibtexEdition = ".((trim($_POST["bibtexEdition"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexEdition"])))."', ")
  ." bibtexEditor = ".((trim($_POST["bibtexEditor"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexEditor"])))."', ")
  ." bibtexEe = ".((trim($_POST["bibtexEe"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexEe"])))."', ")
  ." bibtexHowpublished = ".((trim($_POST["bibtexHowpublished"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexHowpublished"])))."', ")
  ." bibtexInstitution = ".((trim($_POST["bibtexInstitution"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexInstitution"])))."', ")
  ." bibtexIsbn = ".((trim($_POST["bibtexIsbn"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexIsbn"])))."', ")
  ." bibtexIssn = ".((trim($_POST["bibtexIssn"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexIssn"])))."', ")
  ." bibtexJournal = ".((trim($_POST["bibtexJournal"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexJournal"])))."', ")
  ." bibtexKey = ".((trim($_POST["bibtexKey"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexKey"])))."', ")
  ." bibtexKeywords = ".((trim($_POST["bibtexKeywords"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexKeywords"])))."', ")
  ." bibtexLanguage = ".((trim($_POST["bibtexLanguage"]) == "") ? "'english', " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexLanguage"])))."', ")
  ." bibtexLccn = ".((trim($_POST["bibtexLccn"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexLccn"])))."', ")
  ." bibtexLocation = ".((trim($_POST["bibtexLocation"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexLocation"])))."', ")
  ." bibtexMonth = ".((trim($_POST["bibtexMonth"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexMonth"])))."', ")
  ." bibtexNumber = ".((trim($_POST["bibtexNumber"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexNumber"])))."', ")
  ." bibtexOrganization = ".((trim($_POST["bibtexOrganization"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexOrganization"])))."', ")
  ." bibtexPages = ".((trim($_POST["bibtexPages"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexPages"])))."', ")
  ." bibtexPrice = ".((trim($_POST["bibtexPrice"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexPrice"])))."', ")
  ." bibtexPublisher = ".((trim($_POST["bibtexPublisher"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexPublisher"])))."', ")
  ." bibtexSchool = ".((trim($_POST["bibtexSchool"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexSchool"])))."', ")
  ." bibtexSeries = ".((trim($_POST["bibtexSeries"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexSeries"])))."', ")
  ." bibtexSize = ".((trim($_POST["bibtexSize"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexSize"])))."', ")
  ." bibtexTitle = ".((trim($_POST["bibtexTitle"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexTitle"])))."', ")
  ." bibtexType = ".((trim($_POST["bibtexType"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexType"])))."', ")
  ." bibtexYear = ".((trim($_POST["bibtexYear"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexYear"])))."', ")
  ." bibtexUrl = ".((trim($_POST["bibtexUrl"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexUrl"])))."', ")
  ." bibtexVolume = ".((trim($_POST["bibtexVolume"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexVolume"])))."', ")
  ." bibtexAbstract = ".((trim($_POST["bibtexAbstract"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexAbstract"])))."', ")
  ." bibtexContents = ".((trim($_POST["bibtexContents"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexContents"])))."', ")
  ." bibtexNote = ".((trim($_POST["bibtexNote"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["bibtexNote"])))."', ")
  ." categoryPath = ".(($category_string == "") ? "'".CAT_PATH."', " : "'".db_encode(latex2utf($category_string))."', ")
  ." fullpapertext = ".((trim($_POST["fullpapertext"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["fullpapertext"])))."', ")
  // Encodes local URLs twice, since escaped characters must remain escaped in the decoded URL
  ." localUrlpdf = ".((trim($_POST["localUrlpdf"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["localUrlpdf"])))."', ")
  ." localUrlps = ".((trim($_POST["localUrlps"]) == "") ? "NULL, " : "'".db_encode(latex2utf(cond_strip($_POST["localUrlps"])))."', ")
  ." typeBibtex = '".$_POST["typeBibtex"]."', "
  ." lastEditiondate = '".date("Y-m-d")."', "
  ." lastEditiontime = '".date("H:i:s")."' "
  ." WHERE `key` = ".$_GET["key"].";");
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}
// Closes connection
db_close($db);

// Returns to paper details
header("Location: ".paper_url($_GET["key"]));
?>
