<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Fetches records from the database
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE `key` = ".$_GET["key"]." LIMIT 1;");
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}

// Gets the row
$row = db_fetch_assoc_array($result);
$source_key = $row["identifierBibtex"];

// Shows page header
$theme["page-title"] = _("Paper details");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Citations (experimental)");?></h1>

<p>A list of references is tentatively extracted from the
<?php echo "<a href=\"paper-full-text?key=".$_GET["key"]."\">";?>plain text</a> of the paper.
This list is then compared to existing references in the database and likely matches
are suggested for each.</p>

<p>You can then choose to formally add a link between this paper the selected
entries if the match is correct.  These links will show in the citations
section of the <i>Paper details</i> page.</p>

<?php
if (!isset($_GET["loose-match"]))
{
  echo "<p>"._("More suggestions can be obtained by using a");
  echo " <a href=\"paper-citations?key=".$_GET["key"]."&amp;loose-match\">"._("looser match")."</a>.</p>\n";
}
?>

<form name="guess-references" method="post" action="<?php echo menu_url("paper-citations-add");?>">

<?php
// Gets all citation references
$query_string2 = "SELECT * from ".$config["ddDBPrefix"]."citation WHERE source = '$source_key';";
$result2 = db_query($db, $query_string2);
$cross_links = array();
// Puts all these citations into an array (to minimize the number of database queries)
while ($row2 = db_fetch_assoc_array($result2))
{
  $cross_links[$row2["destination"]] = true;
}

// Tries to extract part of the full text containing the references
$ref_text = db_decode($row["fullpapertext"]);
$matches = array();
$num_matches = preg_match_all("/References/i", $ref_text, $matches, PREG_OFFSET_CAPTURE);
if ($num_matches < 1) // No reference found {{{
{
  echo "<p>"._("No reference section has been found.")."</p>\n";
} // }}}
else // Begin reference guessing section {{{
{
  // Takes the last occurrence of the word
  $ref_pos = $matches[0][$num_matches-1][1];
  $ref_text = substr($ref_text, $ref_pos, strlen($ref_text) - $ref_pos);
  //echo $ref_text;
  echo "<ul class=\"guessed-references\">";
  
  // Tentatively splits this text into reference entries
  $matches = array();
  preg_match_all("/^[\\[\\]\\d]+\\.{0,1}\\s*[^\\n]/m", $ref_text, $matches, PREG_OFFSET_CAPTURE);

  // Processes each entry
  $i = 0;
  $index = 0;
  for ($index = 0; $index < count($matches[0]); $index++)
  {
    // Creates the entry
    if ($index < count($matches[0]) - 1)
    {
      $entry = substr($ref_text, $matches[0][$index][1], $matches[0][$index+1][1] - $matches[0][$index][1]);
    }
    else
    {
      $entry = substr($ref_text, $matches[0][$index][1], strlen($ref_text) - $matches[0][$index][1]);
    }
    $query_criterion1 = "MATCH bibtexTitle AGAINST ('".db_encode(trim($entry))."')";
    $query_criterion2 = "MATCH bibtexAuthor AGAINST ('".db_encode(trim($entry))."')";
    // If loose-match in the URL, be a little more permissive on the match function
    if (isset($_GET["loose-match"]))
    {
      $operator = "OR";
      $limit = 2;
    }
    else
    {
      $operator = "AND";
      $limit = 1;
    }
    $query_string = "SELECT *, ($query_criterion1) AS scoretitle, ($query_criterion2) AS scoreauthor FROM ".$config["ddDBPrefix"]."publication HAVING scoretitle > 0 $operator scoreauthor > 0 ORDER BY (scoreauthor + scoretitle) DESC LIMIT $limit;";
    $result = db_query($db, $query_string);
    if (!$result)
    {
      echo db_error($db);
    }
    // Gets the row
    if (db_num_rows($result) > 0)
      $guess = true;
    else
      $guess = false;
    // Formats the entry depending on these informations
    if (!$guess) // Grey out snippet if no suggestion
      echo "<li class=\"greyed-out\">";
    elseif($cross_links[$row["identifierBibtex"]])
      echo "<li class=\"already-done\">";
    else
      echo "<li class=\"has-suggestion\">";
    echo $entry."\n";
    if ($guess)
    {
      echo "<ul>\n";
      while ($row = db_fetch_assoc_array($result))
      {
        echo "<li>\n";
        // Checks whether the guess is already entered in the citations
        if ($cross_links[$row["identifierBibtex"]])
        {
          // The paper is in the list:  show a checked checkbox
          $selected_value = "checked=\"checked\" disabled=\"disabled\"";
        }
        else
        {
          // The paper is not in the list: show an unchecked checkbox
          $selected_value = "";
        }
        echo "<input type=\"checkbox\" name=\"guess-$i\" $selected_value/> ";
        echo "<input type=\"hidden\" name=\"reference-$i\" value=\"".$row["identifierBibtex"]."\"/> ";
        echo "<span class=\"suggestion\">\n";
        echo format_paper_entry($db, $row);
        echo "</span>\n";
        echo "</li>\n";
        $i++;
      }
      echo "</ul>\n";
      echo "</li>\n";
    }
  }
  echo "</ul>\n";
  
  echo "<input type=\"hidden\" name=\"source-index\" value=\"".$_GET["key"]."\"/>\n";
  echo "<input type=\"hidden\" name=\"source\" value=\"".$source_key."\"/>\n";
  echo "<input type=\"hidden\" name=\"num-entries\" value=\"$i\"/>\n";
  ?>
  
  <input type="submit" value="<?php echo _("Submit");?>"/> <input type="reset" value="<?php echo _("Reset");?>"/>
  </form>
<?php
} // End of reference guessing section }}}

// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-16";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);

// :folding=explicit:
?>
