<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Checks if user has proper credentials for this operation; if not
// redirects to a "permission denied" page
if ($config["mustLogin"])
{
  if (!isset($_SESSION["canAddPaper"]) || $_SESSION["canAddPaper"] === "no")
  {
    header("Location: permission-denied");
    exit();
  }
}

// Shows page header
$theme["page-title"] = _("Add paper");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Add paper");?></h1>
  <form name="getbibtex" method="post" action="paper-add.php">
  <table border="0" cellspacing="5">
  <tr>
    <td><b>Field name</b></td>
    <td><b>Value</b></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("BibTeX type");?></td>
    <td><select name="typeBibtex">
      <option value="article">article</option>
      <option value="book">book</option>
      <option value="booklet">booklet</option>
      <option value="conference">conference</option>
      <option value="inbook">inbook</option>
      <option value="incollection">incollection</option>
      <option value="inproceedings" selected>inproceedings</option>
      <option value="manual">manual</option>
      <option value="mastersthesis">mastersthesis</option>
      <option value="misc">misc</option>
      <option value="phdthesis">phdthesis</option>
      <option value="proceedings">proceedings</option>
      <option value="phdthesis">phdthesis</option>
      <option value="techreport">techreport</option>
      <option value="unpublished">unpublished</option>
      <option value="collection">collection</option>
      <option value="patent">patent</option>
      </select>
    </td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("BibTeX identifier");?></td>
    <td><input type="text" name="identifierBibtex" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Abstract");?></td>
    <td><textarea name="bibtexAbstract" rows="5" cols="80"></textarea></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Address");?></td>
    <td><input type="text" name="bibtexAddress" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Affiliation");?></td>
    <td><input type="text" name="bibtexAffiliation" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Annote");?></td>
    <td><input type="text" name="bibtexAnnote" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Author(s)");?></td>
    <td><input type="text" name="bibtexAuthor" value="" size="80" /><br/>
    <input type="checkbox" name="autoadd" value="1"/> <?php echo _("Auto-add/merge authors");?>
    </td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Bibsource");?></td>
    <td><input type="text" name="bibtexBibsource" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Book title");?></td>
    <td><input type="text" name="bibtexBooktitle" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Category");?>*</td>
    <td><input type="text" name="categoryPath" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Chapter");?></td>
    <td><input type="text" name="bibtexChapter" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Contents");?></td>
    <td><input type="text" name="bibtexContents" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Copyright");?></td>
    <td><input type="text" name="bibtexCopyright" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Cross-reference");?></td>
    <td><input type="text" name="bibtexCrossref" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Edition");?></td>
    <td><input type="text" name="bibtexEdition" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Editor(s)");?></td>
    <td><input type="text" name="bibtexEditor" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("EE");?></td>
    <td><input type="text" name="bibtexEe" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("How published");?></td>
    <td><input type="text" name="bibtexHowpublished" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Institution");?></td>
    <td><input type="text" name="bibtexInstitution" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("ISBN");?></td>
    <td><input type="text" name="bibtexIsbn" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("ISSN");?></td>
    <td><input type="text" name="bibtexIssn" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Journal");?></td>
    <td><input type="text" name="bibtexJournal" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Key");?></td>
    <td><input type="text" name="bibtexKey" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Keywords");?></td>
    <td><input type="text" name="bibtexKeywords" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Language");?></td>
    <td><input type="text" name="bibtexLanguage" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("LCCN");?></td>
    <td><input type="text" name="bibtexLccn" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Local PDF file");?>*</td>
    <td><input type="text" name="localUrlpdf" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Local PS file");?>*</td>
    <td><input type="text" name="localUrlps" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Location");?></td>
    <td><input type="text" name="bibtexLocation" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Month");?></td>
    <td><input type="text" name="bibtexMonth" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Note");?></td>
    <td><input type="text" name="bibtexNote" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Number");?></td>
    <td><input type="text" name="bibtexNumber" value="" size="80"/></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Organization");?></td>
    <td><input type="text" name="bibtexOrganization" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Pages");?></td>
    <td><input type="text" name="bibtexPages" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Plain text");?>*</td>
    <td><textarea name="fullpapertext" rows="10" cols="80"></textarea></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Price");?></td>
    <td><input type="text" name="bibtexPrice" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Publisher");?></td>
    <td><input type="text" name="bibtexPublisher" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("School");?></td>
    <td><input type="text" name="bibtexSchool" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Series");?></td>
    <td><input type="text" name="bibtexSeries" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Size");?></td>
    <td><input type="text" name="bibtexSize" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Title");?></td>
    <td><input type="text" name="bibtexTitle" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Type");?></td>
    <td><input type="text" name="bibtexType" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("URL");?></td>
    <td><input type="text" name="bibtexUrl" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Volume");?></td>
    <td><input type="text" name="bibtexVolume" value="" size="80" /></td>
  </tr>
  <tr>
    <td valign="top" align="right"><?php echo _("Year");?></td>
    <td><input type="text" name="bibtexYear" value="" size="80" /></td>
  </tr>
  </table>
  
  <p><input type="submit" value="Submit"/> <input type="reset" value="Reset"/></p>
  </form>
  <p>* <?php echo _("Indicates unofficial BibTeX fields");?></p>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
