<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Checks if a query string has been entered
$basic_text = "";
if (isset($_POST["name-list"]) && $_POST["name-list"])
{
  $basic_text = $_POST["name-list"];
}
if (isset($_GET["name-list"]) && $_GET["name-list"])
{
  $basic_text = urldecode($_GET["name-list"]);
}
if ($basic_text == "")
  die(_("No query passed."));


function get_google_hits($new_name)
{
  // Generates POST request
  $crlf = "\r\n";
  $host = "www.google.com";
  $port = 80;
  $request  = "GET /search?q=".urlencode($new_name)." HTTP/1.1".$crlf;
  $request .= "Host: $host".$crlf;
  $request .= "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.8.0.1) Gecko/20060111 Firefox/1.5.0.1".$crlf;
  $request .= "Accept: text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5".$crlf;
  $request .= "Accept-Language: en-ca,en;q=0.8,fr-ca;q=0.5,fr;q=0.3".$crlf;
  $request .= "Accept-Encoding: ".$crlf;
  $request .= "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7".$crlf;
  $request .= "Keep-Alive: 300".$crlf;
  $request .= "Connection: keep-alive".$crlf;
  $request .= $query.$crlf.$crlf;
  // Gets Google's results
  $google_result = downloadToString($request, $host, $port);
  // Scrapes the result from Google's page
  $google_matches = array();
  preg_match_all("/<!--m-->(.*?)<!--n-->/", $google_result, $google_matches);
  $out .= "<ul class=\"google-result\">\n";
  for ($google_i = 0; $google_i < min($_POST["google-max-hits"], count($google_matches[0])); $google_i++)
  {
    $google_entry = $google_matches[0][$google_i];
    preg_match_all("/<h2[^>]*?>(.*?)<\\/h2[^>]*?>/", $google_entry, $google_entry_matches);
    //print_r($google_entry_matches);
    $out .= "<li>".$google_entry_matches[1][0]."</li>";
  }
  $out .= "</ul>\n";
  return $out;
}

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Results (name list search)");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Results (name list search)");?></h1>

<p><?php echo _("Below is the list of papers that contain at least one author from the list given.");?></p>

<?php

echo "<ul class=\"authorbullet\">\n";

// Treats the list
$names_array = explode("\n", $basic_text);
foreach ($names_array as $line)
{
  // Trims line of everything before the first alphabetical character of the
  // line
  if (trim($line) === "")
    continue;
  $matches = array();
  preg_match("/\\W*(.*)/", $line, $matches);
  $candidate_name = trim($matches[1]);
  // Trims line of everything after the first non-alphabetical character
  // The TAB character (\t) counts as non-alphabetical in this setting
  $matches = array();
  if (trim($candidate_name) === "")
    continue;
  preg_match("/([ \\w\\n\\r\\f\\v\\.\-]+)[^ \\w\\n\\r\\f\\v\\.\-]*?.*?\$/", $candidate_name, $matches);
  $candidate_name = trim($matches[1]);
  
  // Splits the name into first, von, last and jr parts
  $name_parts = explode_author_name($candidate_name);
  // If first name contains periods, chances are it is abbreviated:
  // keeps only the first letter and puts a "%" wildcard after it
  if (strpos($name_parts[0], ".") !== FALSE)
  {
    $name_parts[0] = substr($name_parts[0], 0, 1)."[^,]*";
  }
  // Reconstitutes the new name (with possible wildcards) for the search
  $new_name = $name_parts[0];
  if (trim($name_parts[1]) != "")
    $new_name = $new_name." ".$name_parts[1];
  if (trim($name_parts[2]) != "")
    $new_name = $new_name." ".$name_parts[2];
  if (trim($name_parts[3]) != "")
    $new_name = $new_name." ".$name_parts[3];
  // Now checks papers for that author.  Transforms all occurrences of "and"
  // by a comma, so that we can check the wildcard of the first name does
  // not traverse a comma when matching a name (this ensures that first and
  // last name belong to the same author)
  if (trim($new_name) != "")
  {
    if (isset($_POST["googleit"]) && $_POST["googleit"])
    {
      // Searches for that name on google
      $list_of_hits = get_google_hits($new_name);
    }
    //$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE UCASE(REPLACE(bibtexAuthor, ' and ', ',')) REGEXP '".db_encode(strtoupper($new_name))."' ORDER BY bibtexYear DESC;");
    $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE REPLACE(bibtexAuthor, ' and ', ',') LIKE '%".db_encode($new_name)."%' ORDER BY bibtexYear DESC;");
    if (!$result)
    {
      echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
      echo db_error($db);
      exit();
    }
    if (db_num_rows($result) > 0 || $list_of_hits != "")
    {
      echo "<li>".$candidate_name."\n";
      echo "<!--a-->\n";
      echo "<ul class=\"paperbullet\">\n";
      while ($row = db_fetch_assoc_array($result))
      {
        if ($row["localUrlpdf"] || $row["localUrlps"])
          echo "<li class=\"paperbullet\">\n";
        else
          echo "<li class=\"paperbullethollow\">\n";
        echo format_paper_entry($db, $row, PRESENTATION_REGULAR)."\n</li>\n";
      }
      echo "</ul>\n";
      echo "<!--z-->\n";
      if ($list_of_hits != "")
      {
        echo $list_of_hits;
      }
      echo "</li>\n";
    }
  }
}
echo "</ul>\n";
?>

<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2008-02-05";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
