<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Shows page header
$theme["page-title"] = _("Login");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
  <table border="0" cellpadding="0">
  <tr>
    <td valign="top">
      <img src="images/dadrill.png" alt="daDrill"/>
      <h1><?php echo _("Login");?></h1>
      <form name="login-form" method="post" action="login-process">
      <p><?php echo _("Please identify yourself to access the system.");?></p>
      <table border="0">
      <tr>
        <td align="right"><?php echo _("Login");?></td>
        <td><input type="text" name="username"/></td>
      </tr>
      <tr>
        <td align="right"><?php echo _("Password");?></td>
        <td><input type="password" name="password"/></td>
      </tr>
      </table>
      <p><input type="submit" value="Submit"/> <input type="reset" value="Reset"/></p>
      </form>
    </td>
    <td valign="top">
    <h1><?php echo _("daDrill");?></h1>
    <p>
    <?php echo _("Version");?> 0.7<br/>
    <?php echo _("Last modified");?> 2007-04-17
    </p>
    
    <p><?php echo _("daDrill is an interactive PHP/MySQL application that allows you to store, query and navigate through a collection of references indexed according to the BibTeX standard.  You may view it as your \"personal DBLP\" or your \"free and better EndNote\".");?></p>
    <p><?php echo _("Programmed by");?> 
    <a href="http://www.leduotang.com/sylvain/">Sylvain Hall&eacute;</a>.
    </p>
    <p>
    <?php echo _("Markdown rendering functionality programmed by");?>
    <a href="http://www.michelf.com/">Michel Fortin</a>.
    </p>
    
    <p><?php echo _("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.");?></p>

    <p><?php echo _("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.");?></p>

    <p><?php echo _("You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA");?></p>
    
    </td>
  </tr>
  </table>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
