<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

/**
 * Defines a number of useful variables that the theme incarnations can use
 * to fetch files in specific locations.
 */
// The path (relative to the root of the system) where the theme templates are located
$theme["dir"] = $config["ddThemeDir"].$config["ddCurrentTheme"]."/";
// Idem, but with absolute path
$theme["absolute_dir"] = $config["ddBaseDir"].$config["ddThemeDir"].$config["ddCurrentTheme"]."/";
// The path where the theme's images are located
$theme["image_dir"] = $theme["absolute_dir"]."images/";
// Name of the template to show when closing a page
$theme["page_end"] = "page-lower-body";

/**
 * Simply includes and executes a PHP file at the point of call of the
 * function.  Does nothing if the file does not exists.
 * @param $part_name The name of the "part" of the page to display.  The
 *  function automatically assumes that the filename corresponding to that
 *  part is located in the theme directory and ends with ".inc.php".
 */
function show_theme_part($part_name)
{
  global $config;
  global $theme;
  $filename = $theme["dir"].$part_name.".inc.php";
  if (file_exists($filename))
    include($filename);
}

/**
 * Performs a clean close of the current page and exits
 */
function close_page()
{
  global $config;
  global $theme;
  show_theme_part($theme["page_end"]);
  exit();
}
?>
