<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

/**
 * Creates a URL to an author, depending on server configuration:
 * <ol>
 * <li>If the server has no content negotiation (.htaccess file) and no
 *   rewriting rules, displays a regular URL</li>
 * <li>If the server has content negotiation but no rewriting engine, displays
 *   an URL without the extension .php</li>
 * <li>If the server has both content negotiation and rewriting rules, displays
 *   a "clean" URL</li>
 * </ol>
 */
function author_url($key) // {{{
{
  global $config;
  $parameter = is_numeric($key) ? "key" : "name";
  if ($config["has_htaccess"] === true)
    if ($config["has_mod_rewrite"] === true)
      return $config["ddBaseDir"]."authors/author/".urlencode($key);
    else
      return "author?$parameter=".urlencode($key);
  else
    return "author.php?$parameter=".urlencode($key);
} // }}}

/**
 * Creates a URL to a paper, depending on server configuration:
 * <ol>
 * <li>If the server has no content negotiation (.htaccess file) and no
 *   rewriting rules, displays a regular URL</li>
 * <li>If the server has content negotiation but no rewriting engine, displays
 *   an URL without the extension .php</li>
 * <li>If the server has both content negotiation and rewriting rules, displays
 *   a "clean" URL</li>
 * </ol>
 */
function paper_url($key) // {{{
{
  global $config;
  $parameter = is_numeric($key) ? "key" : "name";
  if ($config["has_htaccess"] === true)
    if ($config["has_mod_rewrite"] === true)
      return $config["ddBaseDir"]."papers/paper/".urlencode($key);
    else
      return "paper?$parameter=".urlencode($key);
  else
    return "paper.php?$parameter=".urlencode($key);
} // }}}

/**
 * Creates a URL to a paper, depending on server configuration:
 * <ol>
 * <li>If the server has no content negotiation (.htaccess file) and no
 *   rewriting rules, displays a regular URL</li>
 * <li>If the server has content negotiation but no rewriting engine, displays
 *   an URL without the extension .php</li>
 * <li>If the server has both content negotiation and rewriting rules, displays
 *   a "clean" URL</li>
 * </ol>
 */
function categories_url($key) // {{{
{
  global $config;
  if ($config["has_htaccess"] === true)
    if ($config["has_mod_rewrite"] === true)
    {
      // Trims first slash
      $key = substr($key, 1, strlen($key) - 1);
      // Encodes path, except for slashes which remain as they are
      $key = urlencode($key);
      $key = str_replace("%2F", "/", $key);
      return $config["ddBaseDir"]."papers/".$key;
    }
    else
      return "browse-categories?category=".urlencode($key);
  else
    return "browse-categories.php?category=".urlencode($key);
} // }}}

/**
 * Creates a URL, depending on server configuration:
 * <ol>
 * <li>If the server has no content negotiation (.htaccess file) and no
 *   rewriting rules, displays a regular URL</li>
 * <li>If the server has content negotiation but no rewriting engine, displays
 *   an URL without the extension .php</li>
 * <li>If the server has both content negotiation and rewriting rules, displays
 *   a "clean" URL according to a symbolic namespace.</li>
 * </ol>
 */
function menu_url($item=null, $key=null, $other=null) // {{{
{
  global $config;
  switch ($item)
  {
    case "home":
      return select_url_scheme($config["ddBaseDir"], "./");
      break;
    case "browse":
      return select_url_scheme($config["ddBaseDir"]."papers/", "browse.php");
      break;
    case "query":
      return select_url_scheme($config["ddBaseDir"]."papers/query", "query.php");
      break;
    case "add":
      return select_url_scheme($config["ddBaseDir"]."papers/add", "add.php");
      break;
    case "about":
      return select_url_scheme($config["ddBaseDir"]."about", "about.php");
      break;
    case "author-add":
      return select_url_scheme($config["ddBaseDir"]."authors/add", "author-add.php");
      break;
    case "author-process":
      return "author-process.php";
      break;
    case "basic-query":
      return select_url_scheme($config["ddBaseDir"]."papers/query/basic", "basic-query.php");
      break;
    case "browse-authors":
      return select_url_scheme($config["ddBaseDir"]."authors", "browse-authors.php");
    case "browse-categories":
      return select_url_scheme($config["ddBaseDir"]."papers", "browse-categories.php");
    case "browse-papers":
      return select_url_scheme($config["ddBaseDir"]."papers", "browse-papers.php");
    case "comment-added":
      return "comment-added.php";
      break;
    case "comment-edited":
      return "comment-edited.php";
      break;
    case "experimental":
      return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/experimental", "experimental.php?key=$key");
      break;
    case "export-bibtex":
      return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/bibtex", "export-bibtex.php?key=$key");
      break;
    case "full-text-query":
      return select_url_scheme($config["ddBaseDir"]."papers/query/full-text", "full-text-query.php");
      break;
    case "local-url-pdf":
      return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/pdf", "paper-show-file.php?key=$key&amp;type=pdf");
      break;
    case "local-url-ps":
      return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/ps", "paper-show-file.php?key=$key&amp;type=ps");
      break;
    case "name-list-query":
      return select_url_scheme($config["ddBaseDir"]."authors/query/name-list", "name-list-query.php");
      break;
    case "paper-add-bibtex":
      return select_url_scheme($config["ddBaseDir"]."papers/add/bibtex", "paper-add-bibtex.php");
      break;
    case "paper-add-form":
      return select_url_scheme($config["ddBaseDir"]."papers/add/form", "paper-add-form.php");
      break;
    case "paper-citations":
      return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/citations", "paper-citations.php?key=$key");
      break;
    case "paper-citations-add":
      return "paper-citations-add.php";
      break;
    case "paper-edit":
      return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/edit", "paper-edit.php?key=$key");
      break;
    case "paper-full-text":
    {
      if (!$other || $other == "")
        return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/full-text", "paper-full-text.php?key=$key");
      else
        return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/full-text/".urlencode($other), "paper-full-text.php?key=$key&amp;full-text-query=".urlencode($other));
      break;
    }
    case "paper-modify":
      return select_url_scheme($config["ddBaseDir"]."papers/paper/".$key."/modified", "paper-modify.php?key=$key");
      break;
    case "process-bibtex-reference":
      return select_url_scheme($config["ddBaseDir"]."papers/added", "process-bibtex-reference.php");
      break;
  }
} // }}}

/**
 * Returns the URL depending on configuration parameters
 * @param $url1 The URL to return if the server has both .htaccess files AND
 *   rewriting engine
 * @param $url2 The plain URL.  Note that if .htaccess files are enabled
 *   (for content negotiation), the .php extension will be trimmed.
 */
function select_url_scheme($url1, $url2) // {{{
{
  global $config;
  if ($config["has_htaccess"])
    if ($config["has_mod_rewrite"])
      return $url1;
    else
    {
      $url2 = str_replace(".php", "", $url2);
      return $url2;
    }
  else
    return $url2;
} // }}}

// :folding=explicit:wrap=none:
?>
