<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

/**
 * Downloads a page to a string based on an HTTP GET/POST request.
 * (This script was freely modified from a post on php.net.)
 * @param $req The string of the request (either GET or POST)
 * @param $host The name of the host
 * @param $port Port number (generally 80)
 * @return The content of the page resulting from that request
 */
function downloadToString($req, $host, $port)
{
  // Fetch
  $crlf = "\r\n";
  $response = "";
  $t_fp = fsockopen($host, $port);
  fwrite($t_fp, $req);
  while(is_resource($t_fp) && $t_fp && !feof($t_fp))
  {
    $response .= fread($t_fp, 1024);
  }
  fclose($t_fp);
  
  // Split header and body
  $pos = strpos($response, $crlf . $crlf);
  if($pos === false)
    return($response);
  $header = substr($response, 0, $pos);
  $body = substr($response, $pos + 2 * strlen($crlf));
  return($body);
}
?>
