<?php
require_once ("lib/init.lib.php");
require_once ("lib/GraphViz.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}
$bibtex_key = $_GET["key"];

// Maximum depth for citation graph (leave it to small values)
define("CITATION_DEPTH", 3);

/**
 * Whether or not to exclude papers with type "misc" or "techreport" from the
 * graph.
 */
define("EXCLUDE_MISC", true);
define("EXCLUDE_TECHREPORT", false);

$graph2 = new Image_GraphViz();

$nodes = array();

// Adds the paper
$graph2->addNode(
  $bibtex_key, // Node name
  array(
    //"URL"   => "paper?key=".$bibtex_key, // URL
    "label" => "",
    //"shape" => "box",
    "shape" => "circle",
    "fixedsize" => "true",
    "size" => ".5,.5",
    "style" => "filled",
    "fillcolor" => "#00ff00"
  ));
$nodes[$bibtex_key] = true;

// Adds links of papers that directly cite the entry
$query_string = "SELECT d1.source as sourcehop, p1.`key` as key1, p1.bibtexAuthor as bibtexAuthor, p1.bibtexTitle as bibtexTitle, p1.bibtexYear as bibtexYear FROM ".$config["ddDBPrefix"]."citation as d1, ".$config["ddDBPrefix"]."publication as p1 WHERE d1.destination = '$bibtex_key' AND p1.identifierBibtex = d1.source;";
$result = db_query($db, $query_string);
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}
while($row = db_fetch_assoc_array($result))
{
  if (!isset($nodes[$row["sourcehop"]])) // If not not already there
  {
    $graph2->addNode(
      $row["sourcehop"], // Node name
      array(
        "URL"   => "paper?key=".$row["key1"], // URL
        //"label" => $row["destinationhop"],
        "label" => "",
        //"shape" => "box",
        "shape" => "circle",
        "fixedsize" => "true",
        "height" => ".3",
        "width" => ".3",
        "style" => "filled",
        "fillcolor" => "#ffffff"
      ));
    $nodes[$row["sourcehop"]] = format_paper_entry($db, $row, PRESENTATION_CLEARTEXT);
  }
  // Adds the link
  $graph2->addEdge(
    array($row["sourcehop"] => $bibtex_key),
    array("color" => $linkcolor)
    );
}

// Multiple passes in the DB
for ($depth = 1; $depth <= CITATION_DEPTH; $depth++)
{
  $author_name = "CONCAT_WS(' ', IF(a1.firstName <> '', a1.firstName, NULL), IF(a1.vonPart <> '', a1.vonPart, NULL), IF(a1.lastName <> '', a1.lastName, NULL), IF(a1.jrPart <> '', a1.jrPart, NULL))";
  $query_string = "SELECT $author_name as authorname, d1.source as sourcehop, p1.typeBibtex as entrytype, d1.destination as destinationhop, p1.`key` as key1, p1.bibtexAuthor as bibtexAuthor, p1.bibtexTitle as bibtexTitle, p1.bibtexYear as bibtexYear, p2.bibtexAuthor as sourceauthors FROM ".$config["ddDBPrefix"]."citation as d1, ".$config["ddDBPrefix"]."publication as p1, ".$config["ddDBPrefix"]."publication as p2, ".$config["ddDBPrefix"]."author as a1 WHERE (";
  foreach($nodes as $key => $value)
    $query_string .= "source = '$key' OR ";
  $query_string .= "FALSE) AND (p1.identifierBibtex = d1.destination) AND (p2.identifierBibtex = d1.source) AND (p1.bibtexAuthor LIKE CONCAT('%', $author_name, '%'))";
  if (EXCLUDE_MISC)
    $query_string .= "AND p1.typeBibtex != 'misc' ";
  if (EXCLUDE_TECHREPORT)
    $query_string .= "AND p1.typeBibtex <> 'techreport' ";
  $query_string .= " ORDER BY sourcehop, destinationhop, authorname;";
  //echo $query_string;
  //exit();
  $result = db_query($db, $query_string);
  if (!$result)
  {
    echo _("No result; maybe key does not exist?  See below if MySQL says something.");
    echo db_error($db);
    exit();
  }
  switch ($depth)
  {
    case 1:
      $fillcolor = "#ffffff";
      break;
    case 2:
      $fillcolor = "#cccccc";
      break;
    default:
      $fillcolor = "#aaaaaa";
      break;
  }
  $dest_hop = "";
  $self_citation = false;
  $key = "";
  $entrytype = "";
  $previous_row = array();
  while($row = db_fetch_assoc_array($result))
  {
    //echo "DEPTH $depth\n";
    //print_r($row);
    if ($row["destinationhop"] != $dest_hop && $dest_hop != "")
    {
      // This is a new paper:  print the entry of the previous paper
      if ($self_citation)
      {
        $linkcolor = "#ff0000";
      }
      else
      {
        $linkcolor = "#000000";
      }
      switch ($entry_type)
      {
        case "book":
        case "proceedings":
          $shape = "square";
          break;
        case "misc":
        case "techreport":
          $shape = "losange";
          break;
        default:
          $shape = "circle";
      }
      if (!$nodes[$dest_hop]) // If not not already there
      {
        $graph2->addNode(
          $dest_hop, // Node name
          array(
            "URL"   => "paper?key=".$key, // URL
            //"label" => $previous_row["bibtexYear"],
            "label" => "",
            //"shape" => "box",
            "shape" => $shape,
            "fixedsize" => "true",
            "height" => ".3",
            "width" => ".3",
            "style" => "filled",
            "fillcolor" => $fillcolor
          ));
        $nodes[$dest_hop] = format_paper_entry($db, $previous_row, PRESENTATION_CLEARTEXT);
      }
      // Adds the link
      $graph2->addEdge(
        array($source_hop => $dest_hop),
        array("color" => $linkcolor)
        );
      //echo "Verdict: link $source_hop to $dest_hop, self-citation $self_citation, color $linkcolor\n";
      // Reset the self-citation flag
      $self_citation = false;
    }
    $source_hop = $row["sourcehop"];
    $dest_hop = $row["destinationhop"];
    $key = $row["key1"];
    $entry_type = $row["entrytype"];
    $previous_row = $row;
    // Now check if it is an auto-cite
    if (strpos($row["sourceauthors"], $row["authorname"]) !== FALSE)
    {
      // One of the authors of the destination paper has been found in the source paper
      // This is a self-citation
      $self_citation = true;
    }
  }
}
if (isset($_GET["format"]) && $_GET["format"] != "svg") // Can be png, svg, gif, jpg
{
  $graph2->image($_GET["format"]);
}
else // SVG default
{
  // In the case of an SVG file, trap the output file with our special function...
  $output = $graph2->image_out();
  // ...then parse the file to add titles to nodes.  The title
  // is the small bubble that pops when the mouse goes over a node, and in
  // our case we make it show a clear-text formatted version of the
  // article title.
  foreach($nodes as $key => $value)
  {
    // Escape slashes for regex
    $key = str_replace("/", "\\/", $key);
    $output = preg_replace("/<title>($key)<\\/title>([^<]*?)<a(.*?)>/m", "<title>\$1</title>\$2<a\$3 title=\"".unaccent($value)."\">", $output);
  }
  // ...and finally output the resulting file
  header('Content-Type: image/svg+xml');
  header('Content-Length: ' . strlen($output));
  echo $output;
}
?>
