<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Fetches records from the database
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE `key` = ".$_GET["key"].";");
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}

// Shows page header
$theme["page-title"] = _("BibTeX entry for paper");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("BibTeX entry for paper");?></h1>

<p><?php echo _("If the paper's cross-reference field links to an existing entry in the database, the cross-reference's BibTeX entry is also shown.");?></p>

<pre>
<?php
$row = db_fetch_assoc_array($result);
echo format_paper_entry($db, $row, PRESENTATION_BIBTEX)."\n";

// Checks if paper has an existing cross-reference
$cr = $row["bibtexCrossref"];
if (trim($cr) != "")
{
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE `identifierBibtex` = '".$cr."';");
  if ($result)
  {
    $row = db_fetch_assoc_array($result);
    if ($row)
    {
      echo "\n";
      echo format_paper_entry($db, $row, PRESENTATION_BIBTEX)."\n";
    }
  }
}
?>
</pre>

<p><a href="paper?key=<?php echo $_GET["key"]; ?>"><?php echo _("Back to paper details");?></a></p>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
