<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

$bibtex_key = $_GET["key"];
$query_string = "SELECT d1.destination AS hop1, d2.destination AS hop2 FROM ".$config["ddDBPrefix"]."citation AS d1, ".$config["ddDBPrefix"]."citation AS d2 WHERE d1.source = '$bibtex_key' AND d1.destination = d2.source ORDER BY hop1, hop2;";
// Fetches records from the database
$result = db_query($db, $query_string);
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}

// Shows page header
$theme["page-title"] = _("Paper details");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>

<h1>Experimental stuff</h1>

<p>This page contains sample demos for experimental functions that are yet to
be nicely integrated with the rest of the system.  They may or may not work and
should not be considered part of the official product.</p>

<p><a target="_blank" href="show-graph?key=<?php echo $_GET["key"];?>">Show graph</a></p>

<ul>

<?php
// Computes the citation graph (up to 2 levels deep)
$hop1 = "";
$hop2 = "";
while($row = db_fetch_assoc_array($result))
{
  if ($row["hop1"] != $hop1)
  {
    if ($hop1 != "")
    {
      echo "</li>\n";
      echo "</ul>\n";
      echo "</li>\n";
    }
    echo "<li>\n";
    echo $row["hop1"];
    $hop2 = $row["hop2"];
    echo "<ul>\n";
    $hop1 = $row["hop1"];
  }
  echo "<li>\n";
  echo $row["hop2"];
  echo "</li>\n";
}
?>
</ul>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-16";
show_theme_part("page-lower-body");
// :folding=explicit:
?>
