<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Basic info about page (for theme)
$theme["modif-date"] = "2008-03-09";

// Verifies if a GET request has been sent
if (!$_GET["commentKey"])
{
  echo _("No comment key passed to the page.");
  close_page();
}
else
{
  // Normalized identifer
  $comment_key = $_GET["commentKey"];
}
if (!$_GET["paperKey"])
{
  echo _("No paper key passed to the page.");
  close_page();
}
else
{
  // Normalized identifer
  $numeric_key = $_GET["paperKey"];
}

// Shows page header
$theme["page-title"] = _("Add comment");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>

<h1><?php echo _("Edit a comment");?></h1>

<?php
// Gets info about the comment to edit
if (!$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."comment WHERE commentKey = ".$_GET["commentKey"]." LIMIT 1;"))
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  close_page();
}
$row = db_fetch_assoc_array($result);
if (!$row)
{
  echo _("No row could be passed to page");
  close_page();
}

// Checks if current user is author of comment; if null, OK
/*if ($_SESSION["username"] !== $row["commentAuthor"])
{
  echo "<p>"._("Only the author of the comment can edit it.  Please ");
  echo "<a href=\"javascript:back();\">"._("go back to the previous page")."</a>.</p>";
  close_page();
}*/
echo "<input type=\"hidden\" name=\"commentAuthor\" value=\"'".$_SESSION["username"]."'\"/>\n";
?>

<form name="comment-edit" method="post" action="<?php echo menu_url("comment-edited");?>">

<input type="hidden" name="paperKey" value="<?php echo $numeric_key;?>"/>
<input type="hidden" name="commentKey" value="<?php echo $comment_key;?>"/>

<table>

<tr>
<td><?php echo _("Comment author");?>:</td>
<td>
<?php echo $row["commentAuthor"];?>
</td>
</tr>

<tr>
<td><?php echo _("Comment type");?>:</td>
<td>
<select name="commentType">
  <option value="other" <?php echo $row["commentType"] == "other" ? "selected=\"selected\"" : "";?>><?php echo _("General comment");?></option>
  <option value="summary" <?php echo $row["commentType"] == "summary" ? "selected=\"selected\"" : "";?>><?php echo _("Paper summary");?></option>
</select>
</td>
</tr>

<tr>
<td><?php echo _("Date and time");?>:</td>
<td>
<input type="text" name="date-time" value="<?php echo $row["commentDate"];?>"/>
</td>
</tr>

<tr>
<td colspan="2">
<textarea name="commentText" rows="20" cols="80"><?php echo htmlentities(db_decode($row["commentText"]));?>
</textarea>
</td>
</tr>

<tr>
<td colspan="2">
<input type="submit" value="<?php echo _("Submit");?>"/>
</td>
</tr>

</table>

</form>

<?php
// Closes page
close_page();
// :folding=explicit:
?>
