<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Theme info
$theme["page-title"] = _("Comment deleted");
$theme["modif-date"] = "2008-03-18";

// Deletes comment from the database
$query_string = "DELETE FROM ".$config["ddDBPrefix"]."comment WHERE commentKey = ".$_GET["commentKey"]." LIMIT 1;";
$result = db_query($db, $query_string);
if (!$result)
{
  show_theme_part("page-header");
  show_theme_part("page-upper-body");
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  close_page();
}

// Checks if paper still has a summary and updates DB
$query_string = "SELECT commentKey FROM ".$config["ddDBPrefix"]."comment WHERE paperKey = ".$_GET["paperKey"]." AND commentType = 'summary' ORDER BY commentDate DESC LIMIT 1;";
$result = db_query($db, $query_string);
if (!$result)
{
  show_theme_part("page-header");
  show_theme_part("page-upper-body");
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  close_page();
}
if ($row = db_fetch_assoc_array($result))
{
  $query_string = "UPDATE ".$config["ddDBPrefix"]."publication SET hasSummary = ".$row["commentKey"]." WHERE `key` = ".$_GET["paperKey"]." LIMIT 1;";
}
else
{
  $query_string = "UPDATE ".$config["ddDBPrefix"]."publication SET hasSummary = NULL WHERE `key` = ".$_GET["paperKey"]." LIMIT 1;";
}
$result = db_query($db, $query_string);
if (!$result)
{
  show_theme_part("page-header");
  show_theme_part("page-upper-body");
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  close_page();
}

// Redirects immediately to paper page
header("Location: ".paper_url($_GET["paperKey"]));

// :folding=explicit:
?>
