<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Fetches records from the database
if (!isset($_GET["view"]))
{
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication,".$config["ddDBPrefix"]."author WHERE CONCAT(".$config["ddDBPrefix"]."publication.bibtexAuthor, '%') LIKE CONCAT(TRIM(CONCAT(IF(firstName <> '', CONCAT(firstName, ' '), ''), IF(vonPart <> '', CONCAT(vonPart, ' '), ''), IF(lastName <> '', CONCAT(lastName, ' '), ''), IF(jrPart <> '', CONCAT(jrPart, ' '), ''))), '%') ORDER BY ".$config["ddDBPrefix"]."author.lastName, ".$config["ddDBPrefix"]."publication.bibtexYear DESC;");
}
else
{
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication ORDER BY publication.bibtexYear DESC;");
}
if (!$result)
{
  echo _("No result; maybe an error, see below if MySQL says something.");
  echo db_error($db);
  
}

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Browse papers");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Browse papers");?></h1>
<p><?php echo db_num_rows($result); ?> <?php echo _("matching paper(s).");?>
<?php if (!isset($_GET["view"])) { ?>
<?php echo _("NOTE:  This sorted view only displays papers whose <i>Author</i> field in nonempty and where the first author appears in the bank of authors.");?>
<?php echo _("To view all papers undiscriminately, use the ");?><a href="browse-papers?view=unsorted"><?php echo _("unsorted view");?></a>.
<?php } else { ?>
<?php echo _("Go to");?> <a href="browse-papers"><?php echo _("sorted view");?></a>.
<?php } ?>
</p>
<ul class="paperbullet">
<?php
while ($row = db_fetch_assoc_array($result))
{
  if ($row["localUrlpdf"] || $row["localUrlps"])
    echo "<li class=\"paperbullet\">\n";
  else
    echo "<li class=\"paperbullethollow\">\n";
  echo format_paper_entry($db, $row, PRESENTATION_REGULAR)."\n</li>\n";
}
?>
</ul>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
