<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Gets view parameters; note: GET parameters overwrite POST parameters
if (isset($_POST["category"]) && $_POST["category"])
  $category = $_POST["category"];
else
  $category = "";
if (isset($_GET["category"]) && $_GET["category"])
  $category = $_GET["category"];
if (isset($_POST["year"]) && $_POST["year"])
  $year = $_POST["year"];
else
  $year = "";
if (isset($_GET["year"]) && $_GET["year"])
  $year = $_GET["year"];
if (isset($_POST["yearAdded"]) && $_POST["yearAdded"])
  $yearAdded = $_POST["yearAdded"];
else
  $yearAdded = "";
if (isset($_GET["yearAdded"]) && $_GET["yearAdded"])
  $yearAdded = $_GET["yearAdded"];

$query_string = "SELECT categoryPath FROM ".$config["ddDBPrefix"]."publication WHERE categoryPath LIKE '%".$category."%' ";
if (is_numeric($year))
  $query_string .= "AND bibtexYear = $year ";
if (is_numeric($yearAdded))
  $query_string .= "AND YEAR(insertionDate) = '$yearAdded' ";
if ($config["excludeProceedings"])
  $query_string .= "AND typeBibtex != 'proceedings' ";
$query_string .= "ORDER BY categoryPath;";
$result = db_query($db, $query_string);
if (!$result)
{
  echo (_("No result; maybe an error, see below if MySQL says something."));
  echo db_error($db);
}

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Browse categories");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Browse categories");?></h1>

<p><?php echo _("Category");?>: <a href="browse-categories"><?php echo _("Home");?></a>
<?php
if ($category === "")
  $category = CAT_PATH;
if ($category[0] !== CAT_PATH)
  $category = CAT_PATH.$category;
if (substr($category, strlen($category)-1, 1) !== CAT_PATH)
  $category .= CAT_PATH;
if ($category != CAT_PATH)
{
  $catstring = CAT_PATH;
  $t = explode(CAT_PATH, substr($category, strlen(CAT_PATH), strlen($category) - 2 * strlen(CAT_PATH)));
  for ($i = 0; $i < count($t); $i++)
  {
    $catstring = cat_merge_paths($catstring, $t[$i].CAT_PATH);
    echo " / <a href=\"".categories_url($catstring)."\">".$t[$i]."</a>";
  }
}
?>
</p>

<p><a href="#papers"><?php echo _("Found papers");?></a> <a href="#conferences"><?php echo _("Related conferences");?></a></p>

<p><?php echo db_num_rows($result); ?> <?php echo _("classified paper(s).");?>
<?php echo _("Between parentheses is the number of papers that each category has in the database.");?></p>

<?php
$flag = 0;
$catname = "";
$numpapers = array();
$cropcat = "";
while ($row = db_fetch_assoc_array($result))
{
  $subcats = cat_subcats($row["categoryPath"], $category);
  $subcats_a = explode(CAT_SEPARATOR, $subcats);
  $contains_empty = FALSE;
  foreach ($subcats_a as $sub)
  {
    $numpapers[$sub]++;
  }
}

echo "<h2>"._("Available subcategories")."</h2>\n";
echo "<ul>\n";
foreach($numpapers as $catname => $number)
{
  if ($catname !== "")
    echo "<li><a href=\"".categories_url(cat_merge_paths($category, $catname).CAT_PATH)."\">".$catname."</a> (".$number.")</li>\n";
}
echo "</ul>\n";
?>

<a name="papers"></a>
<h2><?php echo _("Found papers");?></h2>
<p><?php echo _("NOTE:  This sorted view only displays papers whose <i>Author</i> field in nonempty and where the first author appears in the bank of authors.");?></p>
<?php
$query_string = "SELECT * FROM ".$config["ddDBPrefix"]."publication,".$config["ddDBPrefix"]."author WHERE CONCAT(".$config["ddDBPrefix"]."publication.bibtexAuthor, '%') LIKE CONCAT(TRIM(CONCAT(IF(firstName <> '', CONCAT(firstName, ' '), ''), IF(vonPart <> '', CONCAT(vonPart, ' '), ''), IF(lastName <> '', CONCAT(lastName, ' '), ''), IF(jrPart <> '', CONCAT(jrPart, ' '), ''))), '%') AND (".$config["ddDBPrefix"]."publication.categoryPath LIKE '".$category."' OR ".$config["ddDBPrefix"]."publication.categoryPath LIKE '".$category.CAT_SEPARATOR."%' OR ".$config["ddDBPrefix"]."publication.categoryPath LIKE '%".CAT_SEPARATOR.$category."' OR ".$config["ddDBPrefix"]."publication.categoryPath LIKE '%".CAT_SEPARATOR.$category.CAT_SEPARATOR."%') ";
if (is_numeric($year))
  $query_string .= "AND bibtexYear = $year ";
if (is_numeric($yearAdded))
  $query_string .= "AND YEAR(insertionDate) = '$yearAdded' ";
if ($config["excludeProceedings"])
  $query_string .= "AND typeBibtex != 'proceedings' ";
$query_string .= "ORDER BY ".$config["ddDBPrefix"]."author.lastName, ".$config["ddDBPrefix"]."publication.bibtexYear DESC;";
$result = db_query($db, $query_string);
if (!$result)
{
  echo _("No result; maybe an error, see below if MySQL says something.");
  echo db_error($db);
  
}
?>
<ul class="paperbullet">
<?php
while ($row = db_fetch_assoc_array($result))
{
  if ($row["localUrlpdf"] || $row["localUrlps"])
    echo "<li class=\"paperbullet\">\n";
  else
    echo "<li class=\"paperbullethollow\">\n";
  echo format_paper_entry($db, $row, PRESENTATION_REGULAR)."\n</li>\n";
}
?>
</ul>

<a name="conferences"></a>
<h2>Related conferences</h2>
<?php
$query_string = "SELECT bibtexBooktitle,COUNT(*) FROM ".$config["ddDBPrefix"]."publication WHERE (".$config["ddDBPrefix"]."publication.categoryPath LIKE '".$category."' OR ".$config["ddDBPrefix"]."publication.categoryPath LIKE '".$category.CAT_SEPARATOR."%' OR ".$config["ddDBPrefix"]."publication.categoryPath LIKE '%".CAT_SEPARATOR.$category."' OR ".$config["ddDBPrefix"]."publication.categoryPath LIKE '%".CAT_SEPARATOR.$category.CAT_SEPARATOR."%') ";
if (is_numeric($year))
  $query_string .= "AND bibtexYear = $year ";
if (is_numeric($yearAdded))
  $query_string .= "AND YEAR(insertionDate) = '$yearAdded' ";
if ($config["excludeProceedings"])
  $query_string .= "AND typeBibtex != 'proceedings' ";
$query_string .= "GROUP BY TRIM(".$config["ddDBPrefix"]."publication.bibtexBooktitle);";
$result = db_query($db, $query_string);
if (!$result)
{
  echo (_("No result; maybe an error, see below if MySQL says something."));
  echo db_error($db);
  
}
?>
<p><?php echo _("There are");?> <?php echo db_num_rows($result); ?>
<?php echo _("conference(s) in which the previous papers appear.");?></p>

<ul>
<?php
while ($row = db_fetch_assoc_array($result))
{
  if ($row["bibtexBooktitle"] == "")
    echo "<li><a href=\"conference-details?key=\">(No reference)</a> (".$row["COUNT(*)"].")</li>\n";
  else
    echo "<li><a href=\"conference-details?key=".urlencode(db_decode($row["bibtexBooktitle"]))."\">".htmlentities(db_decode($row["bibtexBooktitle"]))."</a> (".$row["COUNT(*)"].")</li>\n";
}
?>
</ul>

<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2008-03-18";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);

// :wrap=none:
?>
