<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Checks if a query string has been entered
$basic_text = "";
if (isset($_POST["basic-text"]) && $_POST["basic-text"])
{
  $basic_text = $_POST["basic-text"];
}
if (isset($_GET["basic-text"]) && $_GET["basic-text"])
{
  $basic_text = urldecode($_GET["basic-text"]);
}
if ($basic_text == "")
  die(_("No query passed."));

// If basic text is one of these keywords, redirects to a page instead of
// doing a search
//$keyword_found = false;
switch ($basic_text)
{
  case "add":
  {
    header("Location: ".menu_url("add"));
    exit();
    break;
  }
  case "ab":
  {
    header("Location: ".menu_url("paper-add-bibtex"));
    exit();
    break;
  }
  case "q":
  {
    header("Location: ".menu_url("query"));
    exit();
    break;
  }
}

// Explodes query words and builds query string
$words = explode(" ", $basic_text);
$query_mandatory_words = "";
$query_forbidden_words = "";
$query_optional_words = "";
foreach($words as $word)
{
	if (substr($word, 0, 1) == "!")
  {
		$query_forbidden_words = $query_forbidden_words.
      " AND ((bibtexTitle IS NULL OR bibtexTitle NOT LIKE '%".
      substr($word, 1, strlen($word) - 1).
      "%') AND (bibtexAuthor IS NULL OR bibtexAuthor NOT LIKE '%".
      substr($word, 1, strlen($word) - 1).
      "%') AND (bibtexEditor IS NULL OR bibtexEditor NOT LIKE '%".
      substr($word, 1, strlen($word) - 1).
      "%')AND (bibtexAbstract IS NULL OR bibtexAbstract NOT LIKE '%".
      substr($word, 1, strlen($word) - 1).
      "%')AND (bibtexBooktitle IS NULL OR bibtexBooktitle NOT LIKE '%".
      substr($word, 1, strlen($word) - 1).
      "%')AND (bibtexJournal IS NULL OR bibtexJournal NOT LIKE '%".
      substr($word, 1, strlen($word) - 1).
      "%') AND (bibtexKeywords IS NULL OR bibtexKeywords NOT LIKE '%".
      substr($word, 1, strlen($word) - 1)."%'))";
  }
	else
  {
		$query_mandatory_words = $query_mandatory_words.
      " AND ((bibtexTitle IS NOT NULL AND bibtexTitle LIKE '%".$word.
      "%') OR (bibtexAuthor IS NOT NULL AND bibtexAuthor LIKE '%".$word.
        "%') OR (bibtexBooktitle IS NOT NULL AND bibtexBooktitle LIKE '%".$word.
      "%') OR (bibtexEditor IS NOT NULL AND bibtexEditor LIKE '%".$word.
      "%') OR (bibtexJournal IS NOT NULL AND bibtexJournal LIKE '%".$word.
      "%') OR (bibtexAbstract IS NOT NULL AND bibtexAbstract LIKE '%".$word.
      "%') OR (bibtexKeywords IS NOT NULL AND bibtexKeywords LIKE '%".$word.
      "%'))";
  }
}
$query_forbidden_words = substr($query_forbidden_words, 4, strlen($query_forbidden_words) - 4);
$query_mandatory_words = substr($query_mandatory_words, 4, strlen($query_mandatory_words) - 4);
$query_optional_words = substr($query_optional_words, 3, strlen($query_optional_words) - 3);

if (trim($query_mandatory_words) != "" && (trim($query_optional_words) != "" || trim($query_forbidden_words) != ""))
	$query_mandatory_words = $query_mandatory_words." AND ";
if (trim($query_forbidden_words) != "" && trim($query_optional_words) != "")
	$query_forbidden_words = $query_forbidden_words." AND ";
if (trim($query_optional_words) != "")
	$query_optional_words = "(".$query_optional_words.")";


// Fetches records from the database
$result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE ".$query_mandatory_words.$query_forbidden_words.$query_optional_words.";");
if (!$result)
{
  echo (_("No result; maybe an error, see below if MySQL says something."));
  echo db_error($db);
}

// Parses and displays the result in a user-friendly form
?>
<?php
// Shows page header
$theme["page-title"] = _("Results");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>

<h1><?php echo _("Results");?></h1>
<p><?php echo db_num_rows($result); ?> <?php echo _("paper(s) matching the query");?>
<tt><?php echo $basic_text; ?></tt>.</p>
<!--a-->
<ul class="paperbullet">
<?php
while ($row = db_fetch_assoc_array($result))
{
  if ($row["localUrlpdf"] || $row["localUrlps"])
    echo "<li class=\"paperbullet\">\n";
  else
    echo "<li class=\"paperbullethollow\">\n";
  echo format_paper_entry($db, $row, PRESENTATION_REGULAR)."\n</li>\n";
}
?>
</ul>
<!--z-->
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
<?php
// Closes connection
db_close($db);
?>
