<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Verifies if a GET request has been sent
if (!$_GET["key"] && !$_GET["name"])
{
  echo _("No author key or name passed to the page.");
  close_page();
}

$author_key = false;
$author_name_key = false;

if (isset($_GET["key"]))
{
  $author_key = $_GET["key"];
  $author_url_field = $author_key;
}
else
{
  $author_name_key = urldecode($_GET["name"]);
  $author_url_field = $author_name_key;
}

// Fetches records from the database
if ($author_key != false)
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."author WHERE `authorKey` = ".$author_key." LIMIT 1;");
else
{
  $author_name = "CONCAT_WS(' ', IF(firstName <> '', firstName, NULL), IF(vonPart <> '', vonPart, NULL), IF(lastName <> '', lastName, NULL), IF(jrPart <> '', jrPart, NULL))";
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."author WHERE $author_name LIKE '".db_encode($author_name_key)."' LIMIT 1;");
}
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}

// Gets author
$row = db_fetch_assoc_array($result);
$authorname = db_decode($row["firstName"]);
if (trim($row["vonPart"]) != "")
  $authorname .= " ".db_decode(trim($row["vonPart"]));
if (trim($row["lastName"]) != "")
  $authorname .= " ".db_decode(trim($row["lastName"]));
if (trim($row["jrPart"]) != "")
  $authorname .= " ".db_decode(trim($row["jrPart"]));

// Shows page header
$theme["page-title"] = $authorname." - "._("Author details");
$theme["modif-date"] = "2008-03-16";
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>

<h1><?php echo _("Author details");?></h1>

<?php
// Checks whether there is a "joint" author to process
$coauthor = null;
if (isset($_GET["with"]))
{
  $coauthor = $_GET["with"];
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."author WHERE `authorKey` = ".$_GET["with"].";");
  if (!$result)
  {
    echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
    echo db_error($db);
    exit();
  }
  $row = db_fetch_assoc_array($result);
  $coauthorname = db_decode($row["firstName"]);
  if (trim($row["vonPart"]) != "")
    $coauthorname .= " ".db_decode(trim($row["vonPart"]));
  if (trim($row["lastName"]) != "")
    $coauthorname .= " ".db_decode(trim($row["lastName"]));
  if (trim($row["jrPart"]) != "")
    $coauthorname .= " ".db_decode(trim($row["jrPart"]));
}

echo "<p><a href=\"ask-dblp?author=".urlencode($authorname)."\">"._("DBLP entry")."</a></p>\n";
?>

<table class="details" cellpadding="5" cellspacing="0">
<?php
$count = 0;
$modulo = 2;
$out = "";


// Displays at least name
$out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The author's name, typed as explained in the LaTeX book.\">Name</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"".author_url($author_url_field)."\">".$authorname."</a></td></tr>\n";
$count++;
$count = fmod($count, $modulo);
echo $out;
?>
</table>

<h2><?php echo _("Papers");?></h2>
<?php

if ($coauthor)
{
  echo "<p>"._("This page shows only the list of papers co-written by ");
  echo htmlentities($authorname);
  echo _(" with ")."\n";
  echo "<a href=\"".author_url($coauthor)."\">".htmlentities($coauthorname)."</a>.</p>\n";
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE bibtexAuthor LIKE '%".db_encode($authorname)."%' AND bibtexAuthor LIKE '%".db_encode($coauthorname)."%' ORDER BY bibtexYear DESC, bibtexTitle ASC;");
}
else
{
  $result = db_query($db, "SELECT * FROM ".$config["ddDBPrefix"]."publication WHERE bibtexAuthor LIKE '%".db_encode($authorname)."%' ORDER BY bibtexYear DESC, bibtexTitle ASC;");
}
// Displays list of papers
if (!$result)
{
  echo (_("No result; maybe key does not exist?  See below if MySQL says something."));
  echo db_error($db);
  exit();
}
echo "<ul class=\"paperbullet\">\n";
while ($row = db_fetch_assoc_array($result))
{
  if ($row["localUrlpdf"] || $row["localUrlps"])
    echo "<li class=\"paperbullet\">\n";
  else
    echo "<li class=\"paperbullethollow\">\n";
  echo format_paper_entry($db, $row, PRESENTATION_REGULAR)."\n</li>\n";
}
echo "</ul>\n";
?>

<h2><?php echo _("Co-authors"); ?></h2>

<p><a href="graph-collaborations?key=<?php echo $author_key;?>"><?php
echo _("Show collaboration graph");?></a></p>

<ul class="authorbullet">
<?php
// Computes co-authors
$author_name = "CONCAT_WS(' ', IF(a1.firstName <> '', a1.firstName, NULL), IF(a1.vonPart <> '', a1.vonPart, NULL), IF(a1.lastName <> '', a1.lastName, NULL), IF(a1.jrPart <> '', a1.jrPart, NULL))";
$query_string = "SELECT a1.authorKey, $author_name as authorname FROM ".$config["ddDBPrefix"]."author AS a1, ".$config["ddDBPrefix"]."publication as p1 WHERE p1.bibtexAuthor LIKE '%$authorname%' AND p1.bibtexAuthor LIKE CONCAT('%', $author_name, '%') AND $author_name NOT LIKE '$authorname'";
$result = db_query($db, $query_string);
if (!$result)
{
  echo _("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}
$collaborations = array();
$keys = array();
while($row = db_fetch_assoc_array($result))
{
  if (!$collaborations[$row["authorname"]])
  {
    $collaborations[$row["authorname"]] = 1;
    $keys[$row["authorname"]] = $row["authorKey"];
  }
  else
  {
    $collaborations[$row["authorname"]]++;
  }
}
foreach($collaborations as $name => $number)
{
  echo "<li class=\"authorbullet\"><a href=\"".author_url($keys[$name])."\">";
  if ($keys[$name] === $coauthor)
    echo "<strong>";
  echo htmlentities(db_decode($name));
  if ($keys[$name] === $coauthor)
    echo "</strong>";
  echo "</a> ($number)</li>";
}
?>
</ul>

<h2><?php echo _("People cited"); ?></h2>

<?php
list($citees, $num_citations, $num_self_citations) = getCitees($authorname);
?>

<p>Here is a list of all the

<strong><?php echo count($citees);?></strong>

people cited in one of this author's papers.
Between parentheses is the total number of citations of each person's
papers, followed by the number of these citations that are self-citations
(i.e. the paper that cites and the paper cited have at least one common
author).</p>

<form name="authors" method="post" action="graph-collaborations?key=<?php echo $author_key;?>">

<table cellpadding="10">

<tr>

<td valign="top">

<ul class="authorbullet">
<?php
arsort($num_citations);
$num_citees = count($citees);
$num_cols = 3;
$threshold = $num_citees / $num_cols;
$i = 0;
$entry = 1;
$highest_author = -1;
foreach($num_citations as $name => $citations)
{
  $highest_author = max($highest_author, $citees[$name]);
  echo "<li class=\"authorbullet\">\n";
  echo "<input type=\"checkbox\" name=\"seed-author-".$citees[$name]."\"/>\n";
  echo "<a href=\"".author_url($citees[$name])."\">".htmlentities($name)."</a>\n";
  echo "(".(isset($num_citations[$name]) ? $num_citations[$name] : "0")."&nbsp;/&nbsp;".(isset($num_self_citations[$name]) ? "<span style=\"color:red\">".$num_self_citations[$name]."</span>" : "0").")";
  echo "</li>\n";
  $i++;
  if ($i > $threshold)
  {
    $i = 0;
    echo "</ul>\n";
    echo "</td>\n";
    echo "<td valign=\"top\">\n";
    echo "<ul class=\"authorbullet\">\n";
  }
}
?>

</ul>

</td></tr>
</table>

<p>The collaboration graph for the authors you select (including the
current author) can be shown.</p>

<input type="submit" value="<?php echo _("Show the graph");?>"/>
<input type="reset" value="<?php echo _("Reset");?>"/>
<input type="hidden" name="num-authors" value="<?php echo $highest_author;?>"/>
</form>

<?php
// Shows page lower body (after dynamic content)
close_page();
// :folding=explicit:wrap=none:
?>
