<?php
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Basic initializations done at every page load
require_once ("lib/init.lib.php");

// Checks if user has proper credentials for this operation; if not
// redirects to a "permission denied" page
if ($config["mustLogin"])
{
  if (!isset($_SESSION["canAddPaper"]) || $_SESSION["canAddPaper"] === "no")
  {
    header("Location: permission-denied");
    exit();
  }
}
?>
<?php
// Shows page header
$theme["page-title"] = _("Add");
show_theme_part("page-header");

// Shows page upper body (before dynamic content
show_theme_part("page-upper-body");
?>
<h1><?php echo _("Add");?></h1>
  <p>Select the operation you wish to do:</p>
  
  <ul>
  <li><a href="<?php echo menu_url("paper-add-bibtex");?>"><?php echo _("Add papers from a BibTeX string");?></a></li>
  <li><a href="<?php echo menu_url("paper-add-form");?>"><?php echo _("Add a paper from a form");?></a></li>
  <li><a href="<?php echo menu_url("author-add");?>"><?php echo _("Add an author");?></a></li>
  </ul>
<?php
// Shows page lower body (after dynamic content)
$theme["modif-date"] = "2007-12-07";
show_theme_part("page-lower-body");
?>
