<?
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("db-connection.lib.php");  // Connection info to the database
require_once("encode-decode.lib.php");  // Encoding/decoding of strings
require_once("entry-format.lib.php");   // Formatting of entries

// Checks if a POST entry has been given
if (!$_POST["bibtex"])
  die("No BibTeX entry has been given.");

// Connects to the database 
$db = db_connect();
if (!$db)
{
  die("Error connecting to the MySQL database");
}

$bibtexEntry = $_POST["bibtex"];

// Numbers accolades to ease regular expression matching
$p_count = 0;
for ($i = 0; $i < strlen($bibtexEntry); $i++)
{
  if ($bibtexEntry[$i] == "{")
  {
    $p_count++;
    if ($p_count <= 2 && $p_count > 0)
    {
      $bibtexEntry = substr($bibtexEntry, 0, $i + 1).$p_count.".".substr($bibtexEntry, $i + 1, strlen($bibtexEntry) - $i);
    }
  }
  elseif ($bibtexEntry[$i] == "}")
  {
    if ($p_count <= 2 && $p_count > 0)
    {
      $bibtexEntry = substr($bibtexEntry, 0, $i).".".$p_count.substr($bibtexEntry, $i, strlen($bibtexEntry) - $i + 1);
      $i += 2;
    }
    $p_count--;
  }
}

// Strips newline characters (since unable to enter re.DOTALL regex mode in PHP
$bibtexEntry = preg_replace('/[ \\t\\n\\r\\f]+/', ' ', $bibtexEntry);

// Counts number of references, entry type and name
$errors = 0;
$errorstring = "";
$entries = array();
preg_match_all("/@(.*?){1.(.*?),/", $bibtexEntry, $entries, PREG_SET_ORDER | PREG_OFFSET_CAPTURE);

for ($i = 0; $i < count($entries); $i++)
{
  // For each entry, finds parameters
  $array_matches = array();
  if ($i == count($entries) - 1)
  {
    preg_match_all("/\s*?(\w*)\s*?=\s*?{2.(.*?).2}/", substr($bibtexEntry, $entries[$i][0][1], strlen($bibtexEntry) - $entries[$i][0][1]), $array_matches, PREG_SET_ORDER);
  }
  else
  {
    preg_match_all("/\s*?(\w*)\s*?=\s*?{2.(.*?).2}/", substr($bibtexEntry, $entries[$i][0][1], $entries[$i+1][0][1] - $entries[$i][0][1]), $array_matches, PREG_SET_ORDER);
  }
  
  // Checks if the bibtex key already exists
  $result = db_query($db, "SELECT * FROM publication WHERE identifierBibtex = '".$entries[$i][2][0]."'");
  if ($result && db_num_rows($result) > 0)
  {
    // Key already exists; paper already added
    $errors++;
    $errorstring = $errorstring."<li>BibTeX paper key <tt>".$entries[$i][2][0]."</tt> already exists.  Paper was not added.</li>\n";
    continue;
  }
  
  // Generates the insertion MySQL query string
  $query_string = "INSERT INTO publication SET identifierBibtex = '".db_encode($entries[$i][2][0])."', typeBibtex = '".db_encode(strtolower($entries[$i][1][0]))."', insertionDate = '".date("Y-m-d")."', insertionTime = '".date("H:i:s")."'";
  $authorindex = -1;
  for ($j = 0; $j < count($array_matches); $j++)
  {
    if (strtolower($array_matches[$j][1]) != "chapter" && strtolower($array_matches[$j][1]) != "year")
    {
      $query_string = $query_string.", bibtex".ucfirst(strtolower($array_matches[$j][1]))." = '".db_encode(latex2utf($array_matches[$j][2]))."'";
      if (strtolower($array_matches[$j][1]) == "author")
        $authorindex = $j;
    }
    else
      // Two entries are of integer type, and hence do not need the ''
      $query_string = $query_string.", bibtex".ucfirst(strtolower($array_matches[$j][1]))." = ".db_encode(latex2utf($array_matches[$j][2]));
  }
  
  // Adds the entry to the database (i.e. executes the generated query)
  $result = db_query($db, $query_string);
  if (!$result)
  {
    $errorstring = $errorstring."<li>No result on insertion of entry #".($i + 1)." (named <tt>".$entries[$i][2][0]."</tt>); maybe an error, see below if MySQL says something:<br/>".db_error($db)."</li>\n";
    $errors++;
  }
  
  // Checks whether the "auto-add authors" has been checked
  if ($_POST["autoadd"] == "1")
  {
    
    $authoradd = 0;
    $authormerge = 0;
    // Adds authors, if the author field is present
    if ($authorindex >= 0)
    {
      $authors = explode(" and ", $array_matches[$authorindex][2]);
      for ($i = 0; $i < count($authors); $i++)
      {
        $result = db_query($db, "SELECT * FROM author WHERE TRIM(CONCAT(IF(firstName <> '', CONCAT(firstName, ' '), ''), IF(vonPart <> '', CONCAT(vonPart, ' '), ''), IF(lastName <> '', CONCAT(lastName, ' '), ''), IF(jrPart <> '', CONCAT(jrPart, ' '), ''))) = '".db_encode(trim($authors[$i]))."';");
        if (!$result)
          echo db_error($db);
        $row2 = db_fetch_assoc_array($result);
        if ($row2)
        {
          // This author is in the database
          $authormerge++;
        }
        else
        {
          // This author is not in the database: add it
          $exploded_name = explode_author_name(latex2utf(trim($authors[$i])));
          $result = db_query($db, "INSERT INTO author SET firstName = '".db_encode($exploded_name[0])."', vonPart = '".db_encode($exploded_name[1])."', lastName = '".db_encode($exploded_name[2])."', jrPart = '".db_encode($exploded_name[3])."';");
          if (!$result)
            echo db_error($db);
          $authoradd++;
        }
      }
    }
  }
}
// Parses and displays the result in a user-friendly form
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<!--
  daDrill template page
  Author:         Sylvain Halle <sylvain@leduotang.com>
  Last modif.:    2005-08-23
-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
<link rel="stylesheet" type="text/css" href="page.css"/>
<link rel="shortcut icon" href="images/dadrill.ico"/>
<meta name="lang" content="en"/>
<meta name="robots" content="noindex,nofollow"/>
<meta name="author" content="Sylvain Hall&eacute;"/>
<meta name="description" content="Page from daDrill, the offline library browser."/>
<title>
daDrill - Summary of addition
</title>
</head>
<body>

<table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:100%">
<tr><td style="height:48px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:48px;">
  <tr>
  <td width="82">
  <img src="images/page-1-w.png" alt=""/>
  </td>
  <td style="background-image:url('images/page-1-c.png');">&nbsp;</td>
  <td width="128">
  <img src="images/page-1-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="101">
  <img src="images/page-2-w.png" alt=""/>
  </td>
  <td class="menubar" valign="middle" style="background-image:url('images/page-2-c.png');">
    <!-- Begin menu bar -->
    <table border="0" cellpadding="0" cellspacing="0">
    <tr>
    <td>
    <a href="./" class="menubar">Home</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="browse.php"><img border="0" src="images/button-browse.png" alt="Browse"/></a>
    </td>
    <td>
    <a href="browse.php" class="menubar">Browse</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="query.php"><img border="0" src="images/button-query.png" alt="Query"/></a>
    </td>
    <td>
    <a href="query.php" class="menubar">Query</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="add.php"><img border="0" src="images/button-add.png" alt="Add"/></a>
    </td>
    <td>
    <a href="add.php" class="menubar">Add</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="about.php"><img border="0" src="images/button-about.png" alt="About"/></a>
    </td>
    <td>
    <a href="about.php" class="menubar">About</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    </tr>
    </table>
    <!-- End menu bar -->
  </td>
  <td width="128">
  <img src="images/page-2-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td valign="top">
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
  <td width="100">&nbsp;</td>
  <td valign="top">

<!-- Begin page content -->
<h1>Summary of addition</h1>
<p><? echo count($entries) - $errors; ?> entrie(s) added out of 
<? echo count($entries); ?> submitted.</p>

<? if ($_POST["autoadd"] == "1" && (count($entries) - $errors > 0)) { ?>
<p>Auto-add authors selected:  
<?  if ($authorindex >= 0) { ?>
<? echo $authormerge; ?> author(s) merged and
<? echo $authoradd; ?> new author(s) added.
<? } else { ?>
no <i>Author</i> field found in the entry.
<? } ?>
</p>
<? } ?>
<?
if ($errors > 0)
{
  echo "<p>Error messages:</p>\n";
  echo "<ul>\n".$errorstring."</ul>";
}
?>
<!-- End page content -->

  </td>
  <td width="10">&nbsp;</td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="86">
  <img src="images/page-b-w.png" alt=""/>
  </td>
  <td valign="middle" class="footer" style="background-image:url('images/page-b-c.png');">
  <!-- Begin footer -->
  &copy; 2005 Sylvain Hall&eacute;.  This software is released under the GNU
  GPL; see <a style="color:#cc0" href="COPYING">COPYING</a> for license
  information.  This page (and script) was last modified on
  <!-- date-modif -->2005-09-13.
  <!-- End footer -->
  </td>
  <td width="25">
  <img src="images/page-b-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
</table>

</body>
</html>
<?
// Closes connection
db_close($db);
?>
