<?
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("db-connection.lib.php");  // Connection info to the database
require_once("encode-decode.lib.php");  // Encoding/decoding of strings

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Connects to the database 
$db = db_connect();
if (!$db)
{
  die("Error connecting to the MySQL database");
}

// Updates the database
$result = db_query($db, "UPDATE publication SET "
  ." identifierBibtex = ".((trim($_POST["identifierBibtex"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["identifierBibtex"]))."', ")
  ." bibtexAddress = ".((trim($_POST["bibtexAddress"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAddress"]))."', ")
  ." bibtexAffiliation = ".((trim($_POST["bibtexAffiliation"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAffiliation"]))."', ")
  ." bibtexAnnote = ".((trim($_POST["bibtexAnnote"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAnnote"]))."', ")
  ." bibtexAuthor = ".((trim($_POST["bibtexAuthor"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAuthor"]))."', ")
  ." bibtexBibsource = ".((trim($_POST["bibtexBibsource"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexBibsource"]))."', ")
  ." bibtexBooktitle = ".((trim($_POST["bibtexBooktitle"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexBooktitle"]))."', ")
  ." bibtexChapter = ".((trim($_POST["bibtexChapter"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexChapter"]))."', ")
  ." bibtexCrossref = ".((trim($_POST["bibtexCrossref"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexCrossref"]))."', ")
  ." bibtexCopyright = ".((trim($_POST["bibtexCopyright"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexCopyright"]))."', ")
  ." bibtexEdition = ".((trim($_POST["bibtexEdition"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEdition"]))."', ")
  ." bibtexEditor = ".((trim($_POST["bibtexEditor"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEditor"]))."', ")
  ." bibtexEe = ".((trim($_POST["bibtexEe"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEe"]))."', ")
  ." bibtexHowpublished = ".((trim($_POST["bibtexHowpublished"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexHowpublished"]))."', ")
  ." bibtexInstitution = ".((trim($_POST["bibtexInstitution"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexInstitution"]))."', ")
  ." bibtexIsbn = ".((trim($_POST["bibtexIsbn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexIsbn"]))."', ")
  ." bibtexIssn = ".((trim($_POST["bibtexIssn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexIssn"]))."', ")
  ." bibtexJournal = ".((trim($_POST["bibtexJournal"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexJournal"]))."', ")
  ." bibtexKey = ".((trim($_POST["bibtexKey"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexKey"]))."', ")
  ." bibtexKeywords = ".((trim($_POST["bibtexKeywords"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexKeywords"]))."', ")
  ." bibtexLanguage = ".((trim($_POST["bibtexLanguage"]) == "") ? "'english', " : "'".db_encode(latex2utf($_POST["bibtexLanguage"]))."', ")
  ." bibtexLccn = ".((trim($_POST["bibtexLccn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexLccn"]))."', ")
  ." bibtexLocation = ".((trim($_POST["bibtexLocation"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexLocation"]))."', ")
  ." bibtexMonth = ".((trim($_POST["bibtexMonth"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexMonth"]))."', ")
  ." bibtexNumber = ".((trim($_POST["bibtexNumber"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexNumber"]))."', ")
  ." bibtexOrganization = ".((trim($_POST["bibtexOrganization"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexOrganization"]))."', ")
  ." bibtexPages = ".((trim($_POST["bibtexPages"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPages"]))."', ")
  ." bibtexPrice = ".((trim($_POST["bibtexPrice"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPrice"]))."', ")
  ." bibtexPublisher = ".((trim($_POST["bibtexPublisher"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPublisher"]))."', ")
  ." bibtexSchool = ".((trim($_POST["bibtexSchool"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSchool"]))."', ")
  ." bibtexSeries = ".((trim($_POST["bibtexSeries"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSeries"]))."', ")
  ." bibtexSize = ".((trim($_POST["bibtexSize"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSize"]))."', ")
  ." bibtexTitle = ".((trim($_POST["bibtexTitle"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexTitle"]))."', ")
  ." bibtexType = ".((trim($_POST["bibtexType"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexType"]))."', ")
  ." bibtexYear = ".((trim($_POST["bibtexYear"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexYear"]))."', ")
  ." bibtexUrl = ".((trim($_POST["bibtexUrl"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexUrl"]))."', ")
  ." bibtexAbstract = ".((trim($_POST["bibtexAbstract"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAbstract"]))."', ")
  ." bibtexContents = ".((trim($_POST["bibtexContents"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexContents"]))."', ")
  ." bibtexNote = ".((trim($_POST["bibtexNote"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexNote"]))."', ")
  ." comments = ".((trim($_POST["comments"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["comments"]))."', ")
  // Encodes local URLs twice, since escaped characters must remain escaped in the decoded URL
  ." localUrlpdf = ".((trim($_POST["localUrlpdf"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["localUrlpdf"]))."', ")
  ." localUrlps = ".((trim($_POST["localUrlps"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["localUrlps"]))."', ")
  ." typeBibtex = '".$_POST["typeBibtex"]."' "
  ." WHERE `key` = ".$_GET["key"].";");
if (!$result)
{
  echo ("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}
// Closes connection
db_close($db);

// Returns to paper details
header("Location: paper-details.php?key=".$_GET["key"]);
?>
