<?
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("db-connection.lib.php");  // Connection info to the database
require_once("encode-decode.lib.php");  // Encoding/decoding of strings

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Connects to the database 
$db = db_connect();
if (!$db)
{
  die("Error connecting to the MySQL database");
}

// Fetches records from the database
$result = db_query($db, "SELECT * FROM publication WHERE `key` = ".$_GET["key"].";");
if (!$result)
{
  echo ("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}
$row = db_fetch_assoc_array($result);

// Parses and displays the result in a user-friendly form
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<!--
  daDrill template page
  Author:         Sylvain Halle <sylvain@leduotang.com>
  Last modif.:    2005-09-02
-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
<link rel="stylesheet" type="text/css" href="page.css"/>
<link rel="shortcut icon" href="images/dadrill.ico"/>
<meta name="lang" content="en"/>
<meta name="robots" content="noindex,nofollow"/>
<meta name="author" content="Sylvain Hall&eacute;"/>
<meta name="description" content="Page from daDrill, the offline library browser."/>
<title>
daDrill - Edit paper
</title>
</head>
<body>

<table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:100%">
<tr><td style="height:48px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:48px;">
  <tr>
  <td width="82">
  <img src="images/page-1-w.png" alt=""/>
  </td>
  <td style="background-image:url('images/page-1-c.png');">&nbsp;</td>
  <td width="128">
  <img src="images/page-1-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="101">
  <img src="images/page-2-w.png" alt=""/>
  </td>
  <td class="menubar" valign="middle" style="background-image:url('images/page-2-c.png');">
    <!-- Begin menu bar -->
    <table border="0" cellpadding="0" cellspacing="0">
    <tr>
    <td>
    <a href="./" class="menubar">Home</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="browse.php"><img border="0" src="images/button-browse.png" alt="Browse"/></a>
    </td>
    <td>
    <a href="browse.php" class="menubar">Browse</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="query.php"><img border="0" src="images/button-query.png" alt="Query"/></a>
    </td>
    <td>
    <a href="query.php" class="menubar">Query</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="add.php"><img border="0" src="images/button-add.png" alt="Add"/></a>
    </td>
    <td>
    <a href="add.php" class="menubar">Add</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="about.php"><img border="0" src="images/button-about.png" alt="About"/></a>
    </td>
    <td>
    <a href="about.php" class="menubar">About</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    </tr>
    </table>
    <!-- End menu bar -->
  </td>
  <td width="128">
  <img src="images/page-2-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td valign="top">
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
  <td width="100">&nbsp;</td>
  <td valign="top">
  <!-- Begin page content -->
  <h1>Edit paper</h1>
  <form name="getbibtex" method="post" action="paper-modify.php?key=<? echo $_GET["key"]; ?>">
  
  <table border="0" cellspacing="5">
  <tr>
    <td><b>Field name</b></td>
    <td><b>Value</b></td>
  </tr>
  <tr>
    <td valign="top" align="right">BibTeX type</td>
    <td><select name="typeBibtex">
<?
  if ($row["typeBibtex"] == "article")
    echo "<option name=\"article\" selected>article</option>\n";
  else
    echo "<option name=\"article\">article</option>\n";
  if ($row["typeBibtex"] == "book")
    echo "<option name=\"book\" selected>book</option>\n";
  else
    echo "<option name=\"book\">book</option>\n";
  if ($row["typeBibtex"] == "booklet")
    echo "<option name=\"booklet\" selected>booklet</option>\n";
  else
    echo "<option name=\"booklet\">booklet</option>\n";
  if ($row["typeBibtex"] == "conference")
    echo "<option name=\"conference\" selected>conference</option>\n";
  else
    echo "<option name=\"conference\">conference</option>\n";
  if ($row["typeBibtex"] == "inbook")
    echo "<option name=\"inbook\" selected>inbook</option>\n";
  else
    echo "<option name=\"inbook\">inbook</option>\n";
  if ($row["typeBibtex"] == "incollection")
    echo "<option name=\"incollection\" selected>incollection</option>\n";
  else
    echo "<option name=\"incollection\">incollection</option>\n";
  if ($row["typeBibtex"] == "inproceedings")
    echo "<option name=\"inproceedings\" selected>inproceedings</option>\n";
  else
    echo "<option name=\"inproceedings\">inproceedings</option>\n";
  if ($row["typeBibtex"] == "manual")
    echo "<option name=\"manual\" selected>manual</option>\n";
  else
    echo "<option name=\"manual\">manual</option>\n";
  if ($row["typeBibtex"] == "mastersthesis")
    echo "<option name=\"mastersthesis\" selected>mastersthesis</option>\n";
  else
    echo "<option name=\"mastersthesis\">mastersthesis</option>\n";
  if ($row["typeBibtex"] == "misc")
    echo "<option name=\"misc\" selected>misc</option>\n";
  else
    echo "<option name=\"misc\">misc</option>\n";
  if ($row["typeBibtex"] == "phdthesis")
    echo "<option name=\"phdthesis\" selected>phdthesis</option>\n";
  else
    echo "<option name=\"phdthesis\">phdthesis</option>\n";
  if ($row["typeBibtex"] == "proceedings")
    echo "<option name=\"proceedings\" selected>proceedings</option>\n";
  else
    echo "<option name=\"proceedings\">proceedings</option>\n";
  if ($row["typeBibtex"] == "phdthesis")
    echo "<option name=\"phdthesis\" selected>phdthesis</option>\n";
  else
    echo "<option name=\"phdthesis\">phdthesis</option>\n";
  if ($row["typeBibtex"] == "techreport")
    echo "<option name=\"techreport\" selected>techreport</option>\n";
  else
    echo "<option name=\"techreport\">techreport</option>\n";
  if ($row["typeBibtex"] == "unpublished")
    echo "<option name=\"unpublished\" selected>unpublished</option>\n";
  else
    echo "<option name=\"unpublished\">unpublished</option>\n";
  if ($row["typeBibtex"] == "collection")
    echo "<option name=\"collection\" selected>collection</option>\n";
  else
    echo "<option name=\"collection\">collection</option>\n";
  if ($row["typeBibtex"] == "patent")
    echo "<option name=\"patent\" selected>patent</option>\n";
  else
    echo "<option name=\"patent\">patent</option>\n";
?>
    </td>
  </tr>
  <? if (trim($row["identifierBibtex"]) != "") { ?>
  <tr>
    <td valign="top" align="right">BibTeX identifier</td>
    <td><input type="text" name="identifierBibtex" value="<? echo db_decode($row["identifierBibtex"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexAbstract"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Abstract</td>
    <td><textarea name="bibtexAbstract" rows="5" cols="80"><? echo db_decode($row["bibtexAbstract"]);?></textarea></td>
  </tr>
  <? } if (trim($row["bibtexAddress"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Address</td>
    <td><input type="text" name="bibtexAddress" value="<? echo db_decode($row["bibtexAddress"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexAffiliation"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Affiliation</td>
    <td><input type="text" name="bibtexAffiliation" value="<? echo db_decode($row["bibtexAffiliation"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexAnnote"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Annote</td>
    <td><input type="text" name="bibtexAnnote" value="<? echo db_decode($row["bibtexAnnote"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexAuthor"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Author(s)</td>
    <td><input type="text" name="bibtexAuthor" value="<? echo db_decode($row["bibtexAuthor"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexBibsource"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Bibsource</td>
    <td><input type="text" name="bibtexBibsource" value="<? echo db_decode($row["bibtexBibsource"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexBooktitle"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Book title</td>
    <td><input type="text" name="bibtexBooktitle" value="<? echo db_decode($row["bibtexBooktitle"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexChapter"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Chapter</td>
    <td><input type="text" name="bibtexChapter" value="<? echo db_decode($row["bibtexChapter"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["comments"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Comments*</td>
    <td><textarea name="comments" rows="10" cols="80"><? echo db_decode($row["comments"]);?></textarea></td>
  </tr>
  <? } if (trim($row["bibtexContents"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Contents</td>
    <td><input type="text" name="bibtexContents" value="<? echo db_decode($row["bibtexContents"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexCopyright"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Copyright</td>
    <td><input type="text" name="bibtexCopyright" value="<? echo db_decode($row["bibtexCopyright"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexCrossref"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Cross-reference</td>
    <td><input type="text" name="bibtexCrossref" value="<? echo db_decode($row["bibtexCrossref"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexEdition"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Edition</td>
    <td><input type="text" name="bibtexEdition" value="<? echo db_decode($row["bibtexEdition"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexEditor"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Editor(s)</td>
    <td><input type="text" name="bibtexEditor" value="<? echo db_decode($row["bibtexEditor"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexEe"]) != "") { ?>
  <tr>
    <td valign="top" align="right">EE</td>
    <td><input type="text" name="bibtexEe" value="<? echo db_decode($row["bibtexEe"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexHowpublished"]) != "") { ?>
  <tr>
    <td valign="top" align="right">How published</td>
    <td><input type="text" name="bibtexHowpublished" value="<? echo db_decode($row["bibtexHowpublished"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexInstitution"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Institution</td>
    <td><input type="text" name="bibtexInstitution" value="<? echo db_decode($row["bibtexInstitution"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexIsbn"]) != "") { ?>
  <tr>
    <td valign="top" align="right">ISBN</td>
    <td><input type="text" name="bibtexIsbn" value="<? echo db_decode($row["bibtexIsbn"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexIssn"]) != "") { ?>
  <tr>
    <td valign="top" align="right">ISSN</td>
    <td><input type="text" name="bibtexIssn" value="<? echo db_decode($row["bibtexIssn"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexJournal"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Journal</td>
    <td><input type="text" name="bibtexJournal" value="<? echo db_decode($row["bibtexJournal"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexKey"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Key</td>
    <td><input type="text" name="bibtexKey" value="<? echo db_decode($row["bibtexKey"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexKeywords"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Keywords</td>
    <td><input type="text" name="bibtexKeywords" value="<? echo db_decode($row["bibtexKeywords"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexLanguage"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Language</td>
    <td><input type="text" name="bibtexLanguage" value="<? echo db_decode($row["bibtexLanguage"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexLccn"]) != "") { ?>
  <tr>
    <td valign="top" align="right">LCCN</td>
    <td><input type="text" name="bibtexLccn" value="<? echo db_decode($row["bibtexLccn"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["localUrlpdf"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Local PDF file*</td>
    <td><input type="text" name="localUrlpdf" value="<? echo db_decode($row["localUrlpdf"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexLocation"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Location</td>
    <td><input type="text" name="bibtexLocation" value="<? echo db_decode($row["bibtexLocation"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexMonth"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Month</td>
    <td><input type="text" name="bibtexMonth" value="<? echo db_decode($row["bibtexMonth"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexNote"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Note</td>
    <td><input type="text" name="bibtexNote" value="<? echo db_decode($row["bibtexNote"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexNumber"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Number</td>
    <td><input type="text" name="bibtexNumber" value="<? echo db_decode($row["bibtexNumber"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexOrganization"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Organization</td>
    <td><input type="text" name="bibtexOrganization" value="<? echo db_decode($row["bibtexOrganization"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexPages"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Pages</td>
    <td><input type="text" name="bibtexPages" value="<? echo db_decode($row["bibtexPages"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexPrice"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Price</td>
    <td><input type="text" name="bibtexPrice" value="<? echo db_decode($row["bibtexPrice"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexPublisher"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Publisher</td>
    <td><input type="text" name="bibtexPublisher" value="<? echo db_decode($row["bibtexPublisher"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexSchool"]) != "") { ?>
  <tr>
    <td valign="top" align="right">School</td>
    <td><input type="text" name="bibtexSchool" value="<? echo db_decode($row["bibtexSchool"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexSeries"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Series</td>
    <td><input type="text" name="bibtexSeries" value="<? echo db_decode($row["bibtexSeries"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexSize"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Size</td>
    <td><input type="text" name="bibtexSize" value="<? echo db_decode($row["bibtexSize"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexTitle"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Title</td>
    <td><input type="text" name="bibtexTitle" value="<? echo db_decode($row["bibtexTitle"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexType"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Type</td>
    <td><input type="text" name="bibtexType" value="<? echo db_decode($row["bibtexType"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexUrl"]) != "") { ?>
  <tr>
    <td valign="top" align="right">URL</td>
    <td><input type="text" name="bibtexUrl" value="<? echo db_decode($row["bibtexUrl"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexYear"]) != "") { ?>
  <tr>
    <td valign="top" align="right">Year</td>
    <td><input type="text" name="bibtexYear" value="<? echo db_decode($row["bibtexYear"]);?>" size="80" /></td>
  </tr>
  <? } ?>

  <? if (trim($row["identifierBibtex"]) == "") { ?>
  <tr>
    <td valign="top" align="right">BibTeX identifier</td>
    <td><input type="text" name="identifierBibtex" value="<? echo db_decode($row["identifierBibtex"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexAbstract"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Abstract</td>
    <td><textarea name="bibtexAbstract" rows="5" cols="80"><? echo db_decode($row["bibtexAbstract"]);?></textarea></td>
  </tr>
  <? } if (trim($row["bibtexAddress"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Address</td>
    <td><input type="text" name="bibtexAddress" value="<? echo db_decode($row["bibtexAddress"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexAffiliation"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Affiliation</td>
    <td><input type="text" name="bibtexAffiliation" value="<? echo db_decode($row["bibtexAffiliation"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexAnnote"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Annote</td>
    <td><input type="text" name="bibtexAnnote" value="<? echo db_decode($row["bibtexAnnote"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexAuthor"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Author(s)</td>
    <td><input type="text" name="bibtexAuthor" value="<? echo db_decode($row["bibtexAuthor"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexBibsource"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Bibsource</td>
    <td><input type="text" name="bibtexBibsource" value="<? echo db_decode($row["bibtexBibsource"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexBooktitle"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Book title</td>
    <td><input type="text" name="bibtexBooktitle" value="<? echo db_decode($row["bibtexBooktitle"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexChapter"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Chapter</td>
    <td><input type="text" name="bibtexChapter" value="<? echo db_decode($row["bibtexChapter"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["comments"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Comments*</td>
    <td><textarea name="comments" rows="5" cols="80"><? echo db_decode($row["comments"]);?></textarea></td>
  </tr>
  <? } if (trim($row["bibtexContents"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Contents</td>
    <td><input type="text" name="bibtexContents" value="<? echo db_decode($row["bibtexContents"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexCopyright"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Copyright</td>
    <td><input type="text" name="bibtexCopyright" value="<? echo db_decode($row["bibtexCopyright"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexCrossref"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Cross-reference</td>
    <td><input type="text" name="bibtexCrossref" value="<? echo db_decode($row["bibtexCrossref"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexEdition"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Edition</td>
    <td><input type="text" name="bibtexEdition" value="<? echo db_decode($row["bibtexEdition"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexEditor"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Editor(s)</td>
    <td><input type="text" name="bibtexEditor" value="<? echo db_decode($row["bibtexEditor"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexEe"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">EE</td>
    <td><input type="text" name="bibtexEe" value="<? echo db_decode($row["bibtexEe"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexHowpublished"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">How published</td>
    <td><input type="text" name="bibtexHowpublished" value="<? echo db_decode($row["bibtexHowpublished"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexInstitution"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Institution</td>
    <td><input type="text" name="bibtexInstitution" value="<? echo db_decode($row["bibtexInstitution"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexIsbn"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">ISBN</td>
    <td><input type="text" name="bibtexIsbn" value="<? echo db_decode($row["bibtexIsbn"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexIssn"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">ISSN</td>
    <td><input type="text" name="bibtexIssn" value="<? echo db_decode($row["bibtexIssn"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexJournal"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Journal</td>
    <td><input type="text" name="bibtexJournal" value="<? echo db_decode($row["bibtexJournal"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexKey"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Key</td>
    <td><input type="text" name="bibtexKey" value="<? echo db_decode($row["bibtexKey"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexKeywords"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Keywords</td>
    <td><input type="text" name="bibtexKeywords" value="<? echo db_decode($row["bibtexKeywords"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexLanguage"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Language</td>
    <td><input type="text" name="bibtexLanguage" value="<? echo db_decode($row["bibtexLanguage"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexLccn"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">LCCN</td>
    <td><input type="text" name="bibtexLccn" value="<? echo db_decode($row["bibtexLccn"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["localUrlpdf"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Local PDF file*</td>
    <td><input type="text" name="localUrlpdf" value="<? echo db_decode($row["localUrlpdf"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexLocation"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Location</td>
    <td><input type="text" name="bibtexLocation" value="<? echo db_decode($row["bibtexLocation"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexMonth"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Month</td>
    <td><input type="text" name="bibtexMonth" value="<? echo db_decode($row["bibtexMonth"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexNote"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Note</td>
    <td><input type="text" name="bibtexNote" value="<? echo db_decode($row["bibtexNote"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexNumber"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Number</td>
    <td><input type="text" name="bibtexNumber" value="<? echo db_decode($row["bibtexNumber"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexOrganization"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Organization</td>
    <td><input type="text" name="bibtexOrganization" value="<? echo db_decode($row["bibtexOrganization"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexPages"]) == "") { ?>
  <tr>
    <td valign="top" align="right">Pages</td>
    <td><input type="text" name="bibtexPages" value="<? echo db_decode($row["bibtexPages"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexPrice"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Price</td>
    <td><input type="text" name="bibtexPrice" value="<? echo db_decode($row["bibtexPrice"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexPublisher"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Publisher</td>
    <td><input type="text" name="bibtexPublisher" value="<? echo db_decode($row["bibtexPublisher"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexSchool"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">School</td>
    <td><input type="text" name="bibtexSchool" value="<? echo db_decode($row["bibtexSchool"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexSeries"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Series</td>
    <td><input type="text" name="bibtexSeries" value="<? echo db_decode($row["bibtexSeries"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexSize"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Size</td>
    <td><input type="text" name="bibtexSize" value="<? echo db_decode($row["bibtexSize"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexTitle"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Title</td>
    <td><input type="text" name="bibtexTitle" value="<? echo db_decode($row["bibtexTitle"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexType"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Type</td>
    <td><input type="text" name="bibtexType" value="<? echo db_decode($row["bibtexType"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexUrl"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">URL</td>
    <td><input type="text" name="bibtexUrl" value="<? echo db_decode($row["bibtexUrl"]);?>" size="80" /></td>
  </tr>
  <? } if (trim($row["bibtexYear"]) == "") { ?>
  <tr>
    <td class="greyed-out" valign="top" align="right">Year</td>
    <td><input type="text" name="bibtexYear" value="<? echo db_decode($row["bibtexYear"]);?>" size="80" /></td>
  </tr>
  <? } ?>
  </table>
  
  <p><input type="submit" value="Submit"> <input type="reset" value="Reset"/></p>
  </form>
  <p>* Indicates unofficial BibTeX fields</p>
  <!-- End page content -->
  </td>
  <td width="10">&nbsp;</td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="86">
  <img src="images/page-b-w.png" alt=""/>
  </td>
  <td valign="middle" class="footer" style="background-image:url('images/page-b-c.png');">
  <!-- Begin footer -->
  &copy; 2005 Sylvain Hall&eacute;.  This software is released under the GNU
  GPL; see <a style="color:#cc0" href="COPYING">COPYING</a> for license
  information.  This page (and script) was last modified on
  <!-- date-modif -->2005-08-30.
  <!-- End footer -->
  </td>
  <td width="25">
  <img src="images/page-b-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
</table>

</body>
</html>
<?
// Closes connection
db_close($db);
?>
