<?
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("db-connection.lib.php");  // Connection info to the database
require_once("encode-decode.lib.php");  // Encoding/decoding of strings
require_once("entry-format.lib.php");   // Formatting of entries

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Connects to the database 
$db = db_connect();
if (!$db)
{
  die("Error connecting to the MySQL database");
}

// Fetches records from the database
$result = db_query($db, "SELECT * FROM publication WHERE `key` = ".$_GET["key"].";");
if (!$result)
{
  echo ("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}

// Parses and displays the result in a user-friendly form
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<!--
  daDrill template page
  Author:         Sylvain Halle <sylvain@leduotang.com>
  Last modif.:    2005-08-30
-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
<link rel="stylesheet" type="text/css" href="page.css"/>
<link rel="shortcut icon" href="images/dadrill.ico"/>
<meta name="lang" content="en"/>
<meta name="robots" content="noindex,nofollow"/>
<meta name="author" content="Sylvain Hall&eacute;"/>
<meta name="description" content="Page from daDrill, the offline library browser."/>
<title>
daDrill - Paper details
</title>
</head>
<body>

<table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:100%">
<tr><td style="height:48px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:48px;">
  <tr>
  <td width="82">
  <img src="images/page-1-w.png" alt=""/>
  </td>
  <td style="background-image:url('images/page-1-c.png');">&nbsp;</td>
  <td width="128">
  <img src="images/page-1-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="101">
  <img src="images/page-2-w.png" alt=""/>
  </td>
  <td class="menubar" valign="middle" style="background-image:url('images/page-2-c.png');">
    <!-- Begin menu bar -->
    <table border="0" cellpadding="0" cellspacing="0">
    <tr>
    <td>
    <a href="./" class="menubar">Home</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="browse.php"><img border="0" src="images/button-browse.png" alt="Browse"/></a>
    </td>
    <td>
    <a href="browse.php" class="menubar">Browse</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="query.php"><img border="0" src="images/button-query.png" alt="Query"/></a>
    </td>
    <td>
    <a href="query.php" class="menubar">Query</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="add.php"><img border="0" src="images/button-add.png" alt="Add"/></a>
    </td>
    <td>
    <a href="add.php" class="menubar">Add</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="about.php"><img border="0" src="images/button-about.png" alt="About"/></a>
    </td>
    <td>
    <a href="about.php" class="menubar">About</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    </tr>
    </table>
    <!-- End menu bar -->
  </td>
  <td width="128">
  <img src="images/page-2-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td valign="top">
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
  <td width="100">&nbsp;</td>
  <td valign="top">

<!-- Begin page content -->
<h1>Paper details</h1>

<p><a href="paper-edit.php?key=<? echo $_GET["key"]; ?>">Edit</a></p>

<table class="details" cellpadding="5" cellspacing="0">
<?
$count = 0;
$modulo = 2;
$out = "";
$row = db_fetch_assoc_array($result);
if ($row["bibtexTitle"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The work's title, typed as explained in the LaTeX book.\">Title</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexTitle"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexAuthor"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The name(s) of the author(s), in the format described in the LaTeX book.\">Author(s)</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  // Process author list and back-references authors listed in the database
  $out = $out.format_author_list($db, db_decode($row["bibtexAuthor"]));
  $out = $out."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexYear"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The year of publication or, for an unpublished work, the year it was written.\">Year of publication</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexYear"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}

if ($row["bibtexCrossref"] != "")
{
  // Finds cross-reference in database if it exists
  $result = db_query($db, "SELECT * FROM publication WHERE identifierBibtex = '".$row["bibtexCrossref"]."';");
  if (!$result)
    echo db_error($db);
  $row2 = db_fetch_assoc_array($result);
  if ($row2)
  {
    // The cross-reference is in the database
    $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The database key of the entry being cross referenced. Any fields that are missing from the current record are inherited from the field being cross referenced.\">Cross-reference</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"paper-details.php?key=".$row2["key"]."\">".db_decode($row["bibtexCrossref"])."</a></td></tr>\n";
  }
  else
  {
    // The cross-reference is not in the database
    $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The database key of the entry being cross referenced. Any fields that are missing from the current record are inherited from the field being cross referenced.\">Cross-reference</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexCrossref"])."</td></tr>\n";
  }
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexPages"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"One or more page numbers or range of numbers.\">Pages</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexPages"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexAddress"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"Usually the address of the publisher or other type of institution. For major publishing houses, van Leunen recommends omitting the information entirely. For small publishers, on the other hand, you can help the reader by giving the complete address.\">Address</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexAddress"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexAffiliation"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The authors affiliation.\">Affiliation</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexAffiliation"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexAnnote"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"An annotation. It is not used by the standard bibliography styles, but may be used by others that produce an annotated bibliography.\">Annote</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexAnnote"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexBooktitle"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"Title of a book, part of which is being cited. See the LaTeX book for how to type titles. For book entries, use the title field instead.\">Booktitle</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexBooktitle"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexChapter"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"A chapter (or section or whatever) number.\"><abbr=\"\">Chapter</abbr></abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexChapter"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexCopyright"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"Copyright information.\">Copyright</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexCopyright"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexEdition"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The edition of a book---for example, \'Second\'.\">Edition</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexEdition"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexEe"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"DOI reference\">EE</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"".db_decode($row["bibtexEe"])."\">".db_decode($row["bibtexEe"])."</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexHowpublished"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"How something strange has been published. The first word should be capitalized.\">How published</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexHowpublished"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexInstitution"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The sponsoring institution of a technical report.\">Institution</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexInstitution"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexIsbn"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The International Standard Book Number.\">ISBN</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexIsbn"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexIssn"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The International Standard Serial Number. Used to identify a journal.\">ISSN</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexIssn"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexJournal"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"A journal name. Abbreviations are provided for many journals.\">Journal</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexJournal"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexKey"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"BibTeX Key.\">BibTeX Key</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexKey"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexKeywords"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"Key words used for searching or possibly for annotation.\">Keywords</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexKeywords"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexLanguage"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The language the document is in.\">Language</abbr></td><td class=\"details-row-text-mod-".$count."\">";
  switch (strtolower(db_decode($row["bibtexLanguage"])))
  {
    case "english":
      $out = $out."<img src=\"images/flag-uk.png\" alt=\"English\"/>";
      break;
    case "french":
      $out = $out."<img src=\"images/flag-fr.png\" alt=\"French\"/>";
      break;
    case "italian":
      $out = $out."<img src=\"images/flag-it.png\" alt=\"Italian\"/>";
      break;
    case "russian":
      $out = $out."<img src=\"images/flag-ru.png\" alt=\"Russian\"/>";
      break;
    case "arabic":
      $out = $out."<img src=\"images/flag-sa.png\" alt=\"Arabic\"/>";
      break;
    case "spanish":
      $out = $out."<img src=\"images/flag-es.png\" alt=\"Spanish\"/>";
      break;
    case "german":
      $out = $out."<img src=\"images/flag-de.png\" alt=\"German\"/>";
      break;
    case "chinese":
      $out = $out."<img src=\"images/flag-kn.png\" alt=\"Chinese\"/>";
      break;
    default:
      $out = $out.db_decode($row["bibtexLanguage"]);
      break;
  }
  $out = $out."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexLccn"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The Library of Congress Call Number. I've also seen this as lib-congress.\">LCCN</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexLccn"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexLocation"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"A location associated with the entry, such as the city in which a conference took place.\">Location</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexLocation"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexMonth"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The month in which the work was published or, for an unpublished work, in which it was written.\">Month</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexMonth"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexNumber"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The number of a journal, magazine, technical report, or of a work in a series.\">Number</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexNumber"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexOrganization"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The organization that sponsors a conference or that publishes a manual.\">Organization</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexOrganization"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexPrice"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The price of the document.\">Price</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexPrice"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexPublisher"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The publisher's name.\">Publisher</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexPublisher"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexSchool"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The name of the school where a thesis was written.\">School</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexSchool"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexSeries"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The name of a series or set of books.\">Series</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexSeries"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexSize"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The physical dimensions of a work.\">Size</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexSize"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexType"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The type of a technical report---for example, \'Research Note\'.\">Type</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexType"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexVolume"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The volume of a journal or multi-volume book.\">Volume</abbr></td><td class=\"details-row-text-mod-".$count."\">".db_decode($row["bibtexVolume"])."</td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
if ($row["bibtexUrl"] != "")
{
  $out = $out."<tr><td class=\"details-row-key-mod-".$count."\"><abbr title=\"The WWW Universal Resource Locator that points to the item being referenced.\">URL</abbr></td><td class=\"details-row-text-mod-".$count."\"><a href=\"".db_decode($row["bibtexUrl"])."\">".db_decode($row["bibtexUrl"])."</a></td></tr>\n";
  $count++;
  $count = fmod($count, $modulo);
}
echo $out;
?>
</table>

<?
// Checks if paper is cross-referenced by other papers, and gives the list
$result = db_query($db, "SELECT * FROM publication WHERE bibtexCrossref = '".$row["identifierBibtex"]."';");
if (!$result)
{
  echo db_error($db);
}
if (db_num_rows($result) > 0)
{
  echo "<h2>Cross-references</h2>\n";
  echo "<p>This paper is the BibTeX cross-reference for the following ".db_num_rows($result)." entrie(s).  This probably means the paper is a conference proceedings, or a book containing chapters.</p>\n";
  echo "<ol>\n";
  while ($row2 = db_fetch_assoc_array($result))
  {
    echo "<li>\n".format_paper_entry($db, $row2, PRESENTATION_REGULAR)."</li>\n";
  }
  echo "</ol>\n";
}
?>

<?
// Url to local PS file if any
if ($row["localUrlps"] != "")
{
  echo "<table border=\"0\">\n";
  echo "<tr><td valign=\"middle\"><a href=\"".encode_filename(urldecode($row["localUrlps"]))."\"><img border=\"0\" src=\"images/icon-ps.png\" alt=\"PS\"/></a></td>\n";
  echo "<td><a href=\"".encode_filename(urldecode($row["localUrlps"]))."\">PS</a></td></tr>\n</table>\n";
}
?>
<?
// Url to local PDF file if any
if ($row["localUrlpdf"] != "")
{
  echo "<table border=\"0\">\n";
  echo "<tr><td valign=\"middle\"><a href=\"".encode_filename(urldecode($row["localUrlpdf"]))."\"><img border=\"0\" src=\"images/icon-pdf.png\" alt=\"PDF\"/></a></td>\n";
  echo "<td><a href=\"".encode_filename(urldecode($row["localUrlpdf"]))."\">PDF</a></td></tr>\n</table>\n";
}
?>
<? // Shows abstract if any
if ($row["bibtexAbstract"] != "")
{
  echo "<h2>Paper abstract</h2>\n";
  echo "<p>".urldecode($row["bibtexAbstract"])."</p>";
}
?>
<?
// Plain-text comments if any
if ($row["comments"] != "")
{
  echo "<h2>Comments</h2>\n";
  echo "<p><pre>".urldecode($row["comments"])."</pre></p>";
}
?>

<p><a href="export-bibtex.php?key=<? echo $_GET["key"]; ?>">Export BibTeX reference</a></p>
<!-- End page content -->

  </td>
  <td width="10">&nbsp;</td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="86">
  <img src="images/page-b-w.png" alt=""/>
  </td>
  <td valign="middle" class="footer" style="background-image:url('images/page-b-c.png');">
  <!-- Begin footer -->
  &copy; 2005 Sylvain Hall&eacute;.  This software is released under the GNU
  GPL; see <a style="color:#cc0" href="COPYING">COPYING</a> for license
  information.  This page (and script) was last modified on
  <!-- date-modif -->2005-09-13
  <!-- End footer -->
  </td>
  <td width="25">
  <img src="images/page-b-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
</table>

</body>
</html>
<?
// Closes connection
db_close($db);
?>
