<?
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("db-connection.lib.php");  // Connection info to the database
require_once("encode-decode.lib.php");  // Encoding/decoding of strings
require_once("entry-format.lib.php");   // Formatting of entries

// Connects to the database 
$db = db_connect();
if (!$db)
{
  die("Error connecting to the MySQL database");
}

$errors = 0;

// Updates the database
$result = db_query($db, "INSERT INTO publication SET "
  ." identifierBibtex = ".((trim($_POST["identifierBibtex"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["identifierBibtex"]))."', ")
  ." bibtexAddress = ".((trim($_POST["bibtexAddress"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAddress"]))."', ")
  ." bibtexAffiliation = ".((trim($_POST["bibtexAffiliation"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAffiliation"]))."', ")
  ." bibtexAnnote = ".((trim($_POST["bibtexAnnote"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAnnote"]))."', ")
  ." bibtexAuthor = ".((trim($_POST["bibtexAuthor"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAuthor"]))."', ")
  ." bibtexBibsource = ".((trim($_POST["bibtexBibsource"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexBibsource"]))."', ")
  ." bibtexBooktitle = ".((trim($_POST["bibtexBooktitle"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexBooktitle"]))."', ")
  ." bibtexChapter = ".((trim($_POST["bibtexChapter"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexChapter"]))."', ")
  ." bibtexCrossref = ".((trim($_POST["bibtexCrossref"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexCrossref"]))."', ")
  ." bibtexCopyright = ".((trim($_POST["bibtexCopyright"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexCopyright"]))."', ")
  ." bibtexEdition = ".((trim($_POST["bibtexEdition"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEdition"]))."', ")
  ." bibtexEditor = ".((trim($_POST["bibtexEditor"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEditor"]))."', ")
  ." bibtexEe = ".((trim($_POST["bibtexEe"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexEe"]))."', ")
  ." bibtexHowpublished = ".((trim($_POST["bibtexHowpublished"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexHowpublished"]))."', ")
  ." bibtexInstitution = ".((trim($_POST["bibtexInstitution"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexInstitution"]))."', ")
  ." bibtexIsbn = ".((trim($_POST["bibtexIsbn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexIsbn"]))."', ")
  ." bibtexIssn = ".((trim($_POST["bibtexIssn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexIssn"]))."', ")
  ." bibtexJournal = ".((trim($_POST["bibtexJournal"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexJournal"]))."', ")
  ." bibtexKey = ".((trim($_POST["bibtexKey"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexKey"]))."', ")
  ." bibtexKeywords = ".((trim($_POST["bibtexKeywords"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexKeywords"]))."', ")
  ." bibtexLanguage = ".((trim($_POST["bibtexLanguage"]) == "") ? "'english', " : "'".db_encode(latex2utf($_POST["bibtexLanguage"]))."', ")
  ." bibtexLccn = ".((trim($_POST["bibtexLccn"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexLccn"]))."', ")
  ." bibtexLocation = ".((trim($_POST["bibtexLocation"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexLocation"]))."', ")
  ." bibtexMonth = ".((trim($_POST["bibtexMonth"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexMonth"]))."', ")
  ." bibtexNumber = ".((trim($_POST["bibtexNumber"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexNumber"]))."', ")
  ." bibtexOrganization = ".((trim($_POST["bibtexOrganization"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexOrganization"]))."', ")
  ." bibtexPages = ".((trim($_POST["bibtexPages"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPages"]))."', ")
  ." bibtexPrice = ".((trim($_POST["bibtexPrice"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPrice"]))."', ")
  ." bibtexPublisher = ".((trim($_POST["bibtexPublisher"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexPublisher"]))."', ")
  ." bibtexSchool = ".((trim($_POST["bibtexSchool"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSchool"]))."', ")
  ." bibtexSeries = ".((trim($_POST["bibtexSeries"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSeries"]))."', ")
  ." bibtexSize = ".((trim($_POST["bibtexSize"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexSize"]))."', ")
  ." bibtexTitle = ".((trim($_POST["bibtexTitle"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexTitle"]))."', ")
  ." bibtexType = ".((trim($_POST["bibtexType"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexType"]))."', ")
  ." bibtexYear = ".((trim($_POST["bibtexYear"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexYear"]))."', ")
  ." bibtexUrl = ".((trim($_POST["bibtexUrl"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexUrl"]))."', ")
  ." bibtexAbstract = ".((trim($_POST["bibtexAbstract"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexAbstract"]))."', ")
  ." bibtexContents = ".((trim($_POST["bibtexContents"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexContents"]))."', ")
  ." bibtexNote = ".((trim($_POST["bibtexNote"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["bibtexNote"]))."', ")
  ." comments = ".((trim($_POST["comments"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["comments"]))."', ")
  // Encodes local URLs twice, since escaped characters must remain escaped in the decoded URL
  ." localUrlpdf = ".((trim($_POST["localUrlpdf"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["localUrlpdf"]))."', ")
  ." localUrlps = ".((trim($_POST["localUrlps"]) == "") ? "NULL, " : "'".db_encode(latex2utf($_POST["localUrlps"]))."', ")
  ." typeBibtex = '".$_POST["typeBibtex"]."';");
if (!$result)
{
  echo ("No result; maybe key does not exist?  See below if MySQL says something.");
  $errorstring = db_error($db);
  $errors = 1;
}

// Checks whether the "auto-add authors" has been checked
if ($_POST["autoadd"] == "1")
{
  $authoradd = 0;
  $authormerge = 0;
  // Adds authors, if the author field is present
  if ($_POST["bibtexAuthor"])
  {
    $authors = explode(" and ", $_POST["bibtexAuthor"]);
    for ($i = 0; $i < count($authors); $i++)
    {
      $result = db_query($db, "SELECT * FROM author WHERE TRIM(CONCAT(IF(firstName <> '', CONCAT(firstName, ' '), ''), IF(vonPart <> '', CONCAT(vonPart, ' '), ''), IF(lastName <> '', CONCAT(lastName, ' '), ''), IF(jrPart <> '', CONCAT(jrPart, ' '), ''))) = '".db_encode(latex2utf(trim($authors[$i])))."';");
      if (!$result)
        echo db_error($db);
      $row2 = db_fetch_assoc_array($result);
      if ($row2)
      {
        // This author is in the database
        $authormerge++;
      }
      else
      {
        // This author is not in the database: add it
        $exploded_name = explode_author_name(trim($authors[$i]));
        $result = db_query($db, "INSERT INTO author SET firstName = '".db_encode(latex2utf($exploded_name[0]))."', vonPart = '".db_encode(latex2utf($exploded_name[1]))."', lastName = '".db_encode(latex2utf($exploded_name[2]))."', jrPart = '".db_encode(latex2utf($exploded_name[3]))."';");
        if (!$result)
          echo db_error($db);
        $authoradd++;
      }
    }
  }
}
// Parses and displays the result in a user-friendly form
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<!--
  daDrill template page
  Author:         Sylvain Halle <sylvain@leduotang.com>
  Last modif.:    2005-08-23
-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
<link rel="stylesheet" type="text/css" href="page.css"/>
<link rel="shortcut icon" href="images/dadrill.ico"/>
<meta name="lang" content="en"/>
<meta name="robots" content="noindex,nofollow"/>
<meta name="author" content="Sylvain Hall&eacute;"/>
<meta name="description" content="Page from daDrill, the offline library browser."/>
<title>
daDrill - Summary of addition
</title>
</head>
<body>

<table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:100%">
<tr><td style="height:48px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:48px;">
  <tr>
  <td width="82">
  <img src="images/page-1-w.png" alt=""/>
  </td>
  <td style="background-image:url('images/page-1-c.png');">&nbsp;</td>
  <td width="128">
  <img src="images/page-1-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="101">
  <img src="images/page-2-w.png" alt=""/>
  </td>
  <td class="menubar" valign="middle" style="background-image:url('images/page-2-c.png');">
    <!-- Begin menu bar -->
    <table border="0" cellpadding="0" cellspacing="0">
    <tr>
    <td>
    <a href="./" class="menubar">Home</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="browse.php"><img border="0" src="images/button-browse.png" alt="Browse"/></a>
    </td>
    <td>
    <a href="browse.php" class="menubar">Browse</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="query.php"><img border="0" src="images/button-query.png" alt="Query"/></a>
    </td>
    <td>
    <a href="query.php" class="menubar">Query</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="add.php"><img border="0" src="images/button-add.png" alt="Add"/></a>
    </td>
    <td>
    <a href="add.php" class="menubar">Add</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="about.php"><img border="0" src="images/button-about.png" alt="About"/></a>
    </td>
    <td>
    <a href="about.php" class="menubar">About</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    </tr>
    </table>
    <!-- End menu bar -->
  </td>
  <td width="128">
  <img src="images/page-2-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td valign="top">
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
  <td width="100">&nbsp;</td>
  <td valign="top">

<!-- Begin page content -->
<h1>Summary of addition</h1>
<p><? echo 1 - $errors; ?> entry added out of 
1 submitted.</p>

<? if ($_POST["autoadd"] == "1" && (1 - $errors > 0)) { ?>
<p>Auto-add authors selected:  
<?  if ($_POST["bibtexAuthor"]) { ?>
<? echo $authormerge; ?> author(s) merged and
<? echo $authoradd; ?> new author(s) added.
<? } else { ?>
no <i>Author</i> field found in the entry.
<? } ?>
</p>
<? } ?>
<?
if ($errors > 0)
{
  echo "<p>Error messages:</p>\n";
  echo "<ul>\n".$errorstring."</ul>";
}
?>
<!-- End page content -->

  </td>
  <td width="10">&nbsp;</td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="86">
  <img src="images/page-b-w.png" alt=""/>
  </td>
  <td valign="middle" class="footer" style="background-image:url('images/page-b-c.png');">
  <!-- Begin footer -->
  &copy; 2005 Sylvain Hall&eacute;.  This software is released under the GNU
  GPL; see <a style="color:#cc0" href="COPYING">COPYING</a> for license
  information.  This page (and script) was last modified on
  <!-- date-modif -->2005-09-13.
  <!-- End footer -->
  </td>
  <td width="25">
  <img src="images/page-b-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
</table>

</body>
</html>
<?
// Closes connection
db_close($db);
?>
