<?
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("db-connection.lib.php");  // Connection info to the database
require_once("encode-decode.lib.php");  // Encoding/decoding of strings

// Verifies if a GET request has been sent
if (!$_GET["key"])
{
  die("No paper key passed to the page.");
}

// Connects to the database 
$db = db_connect();
if (!$db)
{
  die("Error connecting to the MySQL database");
}

// Fetches records from the database
$result = db_query($db, "SELECT * FROM publication WHERE `key` = ".$_GET["key"].";");
if (!$result)
{
  echo ("No result; maybe key does not exist?  See below if MySQL says something.");
  echo db_error($db);
  exit();
}

// Parses and displays the result in a user-friendly form
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<!--
  daDrill template page
  Author:         Sylvain Halle <sylvain@leduotang.com>
  Last modif.:    2005-08-30
-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
<link rel="stylesheet" type="text/css" href="page.css"/>
<link rel="shortcut icon" href="images/dadrill.ico"/>
<meta name="lang" content="en"/>
<meta name="robots" content="noindex,nofollow"/>
<meta name="author" content="Sylvain Hall&eacute;"/>
<meta name="description" content="Page from daDrill, the offline library browser."/>
<title>
daDrill - BibTeX entry for paper
</title>
</head>
<body>

<table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:100%">
<tr><td style="height:48px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:48px;">
  <tr>
  <td width="82">
  <img src="images/page-1-w.png" alt=""/>
  </td>
  <td style="background-image:url('images/page-1-c.png');">&nbsp;</td>
  <td width="128">
  <img src="images/page-1-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="101">
  <img src="images/page-2-w.png" alt=""/>
  </td>
  <td class="menubar" valign="middle" style="background-image:url('images/page-2-c.png');">
    <!-- Begin menu bar -->
    <table border="0" cellpadding="0" cellspacing="0">
    <tr>
    <td>
    <a href="./" class="menubar">Home</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="browse.php"><img border="0" src="images/button-browse.png" alt="Browse"/></a>
    </td>
    <td>
    <a href="browse.php" class="menubar">Browse</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="query.php"><img border="0" src="images/button-query.png" alt="Query"/></a>
    </td>
    <td>
    <a href="query.php" class="menubar">Query</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="add.php"><img border="0" src="images/button-add.png" alt="Add"/></a>
    </td>
    <td>
    <a href="add.php" class="menubar">Add</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="about.php"><img border="0" src="images/button-about.png" alt="About"/></a>
    </td>
    <td>
    <a href="about.php" class="menubar">About</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    </tr>
    </table>
    <!-- End menu bar -->
  </td>
  <td width="128">
  <img src="images/page-2-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td valign="top">
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
  <td width="100">&nbsp;</td>
  <td valign="top">

<!-- Begin page content -->
<h1>BibTeX entry for paper</h1>

<pre>
<?
$out = "";
$row = db_fetch_assoc_array($result);
$out = "@".$row["typeBibtex"]."{".$row["identifierBibtex"].",\n";
if ($row["bibtexTitle"] != "")
{
  $out = $out."  title       = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexTitle"])), 50, "\n"))."},\n";
}
if ($row["bibtexAuthor"] != "")
{
  $out = $out."  author      = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexAuthor"])), 50, "\n"))."},\n";
}
if ($row["bibtexYear"] != "")
{
  $out = $out."  year        = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexYear"])), 50, "\n"))."},\n";
}

if ($row["bibtexCrossref"] != "")
{
  $out = $out."  crossref    = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexCrossref"])), 50, "\n"))."},\n";
}
if ($row["bibtexPages"] != "")
{
  $out = $out."  pages       = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexPages"])), 50, "\n"))."},\n";
}
if ($row["bibtexAddress"] != "")
{
  $out = $out."  address     = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexAddress"])), 50, "\n"))."},\n";
}
if ($row["bibtexAffiliation"] != "")
{
  $out = $out."  affiliation = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexAffiliation"])), 50, "\n"))."},\n";
}
if ($row["bibtexAnnote"] != "")
{
  $out = $out."  annote      = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexAnnote"])), 50, "\n"))."},\n";
}
if ($row["bibtexBooktitle"] != "")
{
  $out = $out."  booktitle   = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexBooktitle"])), 50, "\n"))."},\n";
}
if ($row["bibtexChapter"] != "")
{
  $out = $out."  chapter     = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexChapter"])), 50, "\n"))."},\n";
}
if ($row["bibtexCopyright"] != "")
{
  $out = $out."  copyright   = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexCopyright"])), 50, "\n"))."},\n";
}
if ($row["bibtexEdition"] != "")
{
  $out = $out."  edition     = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexEdition"])), 50, "\n"))."},\n";
}
if ($row["bibtexEe"] != "")
{
  $out = $out."  ee          = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexEe"])), 50, "\n"))."},\n";
}
if ($row["bibtexHowpublished"] != "")
{
  $out = $out."  howpublished= {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexHowpublished"])), 50, "\n"))."},\n";
}
if ($row["bibtexInstitution"] != "")
{
  $out = $out."  institution = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexInstitution"])), 50, "\n"))."},\n";
}
if ($row["bibtexIsbn"] != "")
{
  $out = $out."  isbn        = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexIsbn"])), 50, "\n"))."},\n";
}
if ($row["bibtexIssn"] != "")
{
  $out = $out."  issn        = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexIssn"])), 50, "\n"))."},\n";
}
if ($row["bibtexJournal"] != "")
{
  $out = $out."  journal     = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexJournal"])), 50, "\n"))."},\n";
}
if ($row["bibtexKey"] != "")
{
  $out = $out."  key         = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexKey"])), 50, "\n"))."},\n";
}
if ($row["bibtexKeywords"] != "")
{
  $out = $out."  keywords    = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexKeywords"])), 50, "\n"))."},\n";
}
if ($row["bibtexLanguage"] != "")
{
  $out = $out."  language    = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexLanguage"])), 50, "\n"))."},\n";
}
if ($row["bibtexLccn"] != "")
{
  $out = $out."  lccn        = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexLccn"])), 50, "\n"))."},\n";
}
if ($row["bibtexLocation"] != "")
{
  $out = $out."  location    = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexLocation"])), 50, "\n"))."},\n";
}
if ($row["bibtexMonth"] != "")
{
  $out = $out."  month       = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexMonth"])), 50, "\n"))."},\n";
}
if ($row["bibtexNumber"] != "")
{
  $out = $out."  number      = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexNumber"])), 50, "\n"))."},\n";
}
if ($row["bibtexOrganization"] != "")
{
  $out = $out."  organization= {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexOrganization"])), 50, "\n"))."},\n";
}
if ($row["bibtexPrice"] != "")
{
  $out = $out."  price       = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexPrice"])), 50, "\n"))."},\n";
}
if ($row["bibtexPublisher"] != "")
{
  $out = $out."  publisher   = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexPublisher"])), 50, "\n"))."},\n";
}
if ($row["bibtexSchool"] != "")
{
  $out = $out."  school      = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexSchool"])), 50, "\n"))."},\n";
}
if ($row["bibtexSeries"] != "")
{
  $out = $out."  series      = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexSeries"])), 50, "\n"))."},\n";
}
if ($row["bibtexSize"] != "")
{
  $out = $out."  size        = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexSize"])), 50, "\n"))."},\n";
}
if ($row["bibtexType"] != "")
{
  $out = $out."  type        = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexType"])), 50, "\n"))."},\n";
}
if ($row["bibtexVolume"] != "")
{
  $out = $out."  volume      = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexVolume"])), 50, "\n"))."},\n";
}
if ($row["bibtexUrl"] != "")
{
  $out = $out."  url         = {".str_replace("\n", "\n                 ", wordwrap(utf2latex(db_decode($row["bibtexUrl"])), 50, "\n"))."},\n";
}

// Strips out last comma
$out = substr($out, 0, strlen($out) - 2);
$out = $out."\n}";
echo $out;
?>
</pre>

<p><a href="paper-details.php?key=<? echo $_GET["key"]; ?>">Back to paper details</a></p>
<!-- End page content -->

  </td>
  <td width="10">&nbsp;</td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="86">
  <img src="images/page-b-w.png" alt=""/>
  </td>
  <td valign="middle" class="footer" style="background-image:url('images/page-b-c.png');">
  <!-- Begin footer -->
  &copy; 2005 Sylvain Hall&eacute;.  This software is released under the GNU
  GPL; see <a style="color:#cc0" href="COPYING">COPYING</a> for license
  information.  This page (and script) was last modified on
  <!-- date-modif -->2005-09-13
  <!-- End footer -->
  </td>
  <td width="25">
  <img src="images/page-b-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
</table>

</body>
</html>
<?
// Closes connection
db_close($db);
?>
