<?
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("db-connection.lib.php");  // Connection info to the database
require_once("encode-decode.lib.php");  // Encoding/decoding of strings

/**
 * Constants for presentation styles in paper lists
 */
define ("PRESENTATION_REGULAR", 0);    // Regular: authors, year, title
define ("PRESENTATION_ABRIDGED", 1);   // Abridged: year, title

/**
 * Formats a paper entry according to a presentation style
 * @param $db A valid link to a connected database
 * @param $a An associative array containing the database parameters of the 
 *   paper
 * @param $style 0 for the moment
 * @return An HTML string of the formatted paper entry
 */
function format_paper_entry($db, $a, $style)
{
  $out = "";
  switch ($style)
  {
    default:
    {
      $out = "<div class=\"reference\">\n";
      $out = $out."<span class=\"author\">".format_author_list($db, db_decode($a["bibtexAuthor"]))."</span>.\n";
      $out = $out."(<a href=\"specific-query.php?year=".db_decode($a["bibtexYear"])."\" class=\"year\">".db_decode($a["bibtexYear"])."</a>).\n";
      $out = $out."<a href=\"paper-details.php?key=".$a["key"]."\" class=\"title\">".db_decode($a["bibtexTitle"])."</a>.\n";
      $out = $out."</div>\n\n";      
      break;
    }
  }
  return $out;
}

/**
 * Process author list and back-references authors listed in the database
 * @param $db A valid link to a connected database
 * @param $l The string of the author list.  It is supposed to be decoded (i.e.
 *  the MySQL escape sequences are removed.
 * @return The HTML string with links for authors in the database
 */
function format_author_list($db, $l)
{
  if (!$db)
  {
    die("Invalid database link");
  }
  $out = "";
  $authors = explode(" and ", $l);
  for ($i = 0; $i < count($authors); $i++)
  {
    $result = db_query($db, "SELECT * FROM author WHERE TRIM(CONCAT(IF(firstName <> '', CONCAT(firstName, ' '), ''), IF(vonPart <> '', CONCAT(vonPart, ' '), ''), IF(lastName <> '', CONCAT(lastName, ' '), ''), IF(jrPart <> '', CONCAT(jrPart, ' '), ''))) = '".db_encode(trim($authors[$i]))."';");
    if (!$result)
      echo db_error($db);
    $row2 = db_fetch_assoc_array($result);
    if ($row2)
    {
      // This author is in the database
      $out = $out."<a href=\"author-details.php?key=".$row2["authorKey"]."\">".trim($authors[$i])."</a>, ";
    }
    else
    {
      // This author is not in the database
      $out = $out.trim($authors[$i]).", ";
    }
  }
  // Trims last comma and space from author list
  $out = substr($out, 0, strlen($out) - 2);
  return $out;
}

/**
 * Explodes an author name into its first name, von part, last name and jr. part
 * according to BibTeX's rules
 * @param $s The string of the author's name. It is supposed to be decoded (i.e.
 *  the MySQL escape sequences are removed.
 * @return An array with 4 indexes, numbered 0-3, corresponding to the 4 parts
 *   of the name
 */
function explode_author_name($name)
{
  $n = trim($name);
  $matches = array();
  $exploded = array();
  $exploded[0] = $exploded[1] = $exploded[2] = $exploded[3] = "";
  $vons = "/ von der | van der | von | van | du | de | de la /";
  $jrs = "/ Jr\\.| Sr\\.| II| III/";
  if (preg_match($vons, $n, $matches))
  {
    // There is a von part; add it and remove it from the name
    $n = str_replace($matches[0], " ", $n);
    $exploded[1] = trim($matches[0]);
    print_r($matches);
    echo $n;
  }
  $n = trim($n);
  if (preg_match($jrs, $n, $matches))
  {
    // There is a Jr. part; add it and remove it from the name
    $n = str_replace($matches[0], " ", $n);
    $exploded[3] = trim($matches[0]);
  }
  // The last remaining token is the last name, the rest is the first name
  $n = trim($n);
  $exp = array();
  $exp = explode(" ", $n);
  if (count($exp) > 1)
  {
    $exploded[2] = trim($exp[count($exp) - 1]);
    $n = str_replace($exp[count($exp) - 1], "", $n);
    $exploded[0] = trim($n);
  }
  else
  {
    // If only one token remains, we assume it is the last name
    $exploded[2] = trim($n);
  }
  return $exploded;
}

/**
 * Rebuilds the author name from the exploded list of all 4 parts
 * @param $first First name
 * @param $von Von part
 * @param $last Last name
 * @param $jr Jr. part
 * @return A string with the full name, without extra spaces
 */
function format_author_name($first, $von, $last, $jr)
{
  $name = "";
  if (trim($first) != "")
    $name = $name.$first." ";
  if (trim($von) != "")
    $name = $name.$von." ";
  if (trim($last) != "")
    $name = $name.$last." ";
  if (trim($jr) != "")
    $name = $name.$jr." ";
  return trim($name);
}
?>
