<?
/******************************************************************************
  daDrill, an offline BibTeX library browser
  Copyright (C) 2005  Sylvain Hall
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301, USA.
******************************************************************************/

// Imports
require_once("db-connection.lib.php");  // Connection info to the database
require_once("encode-decode.lib.php");  // Encoding/decoding of strings
require_once("entry-format.lib.php");   // Formatting of entries

// Connects to the database 
$db = db_connect();
if (!$db)
{
  die("Error connecting to the MySQL database");
}

// Fetches records from the database
if (!isset($_GET["view"]))
{
  $result = db_query($db, "SELECT * FROM publication,author WHERE CONCAT(publication.bibtexAuthor, '%') LIKE CONCAT(TRIM(CONCAT(IF(firstName <> '', CONCAT(firstName, ' '), ''), IF(vonPart <> '', CONCAT(vonPart, ' '), ''), IF(lastName <> '', CONCAT(lastName, ' '), ''), IF(jrPart <> '', CONCAT(jrPart, ' '), ''))), '%') ORDER BY author.lastName, publication.bibtexYear DESC;");
}
else
{
  $result = db_query($db, "SELECT * FROM publication ORDER BY publication.bibtexYear DESC;");
}
if (!$result)
{
  echo ("No result; maybe an error, see below if MySQL says something.");
  echo db_error($db);
  
}

// Parses and displays the result in a user-friendly form
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<!--
  daDrill template page
  Author:         Sylvain Halle <sylvain@leduotang.com>
  Last modif.:    2005-08-30
-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
<link rel="stylesheet" type="text/css" href="page.css"/>
<link rel="shortcut icon" href="images/dadrill.ico"/>
<meta name="lang" content="en"/>
<meta name="robots" content="noindex,nofollow"/>
<meta name="author" content="Sylvain Hall&eacute;"/>
<meta name="description" content="Page from daDrill, the offline library browser."/>
<title>
daDrill - Browse papers
</title>
</head>
<body>

<table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:100%">
<tr><td style="height:48px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:48px;">
  <tr>
  <td width="82">
  <img src="images/page-1-w.png" alt=""/>
  </td>
  <td style="background-image:url('images/page-1-c.png');">&nbsp;</td>
  <td width="128">
  <img src="images/page-1-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="101">
  <img src="images/page-2-w.png" alt=""/>
  </td>
  <td class="menubar" valign="middle" style="background-image:url('images/page-2-c.png');">
    <!-- Begin menu bar -->
    <table border="0" cellpadding="0" cellspacing="0">
    <tr>
    <td>
    <a href="./" class="menubar">Home</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="browse.php"><img border="0" src="images/button-browse.png" alt="Browse"/></a>
    </td>
    <td>
    <a href="browse.php" class="menubar">Browse</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="query.php"><img border="0" src="images/button-query.png" alt="Query"/></a>
    </td>
    <td>
    <a href="query.php" class="menubar">Query</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="add.php"><img border="0" src="images/button-add.png" alt="Add"/></a>
    </td>
    <td>
    <a href="add.php" class="menubar">Add</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    <td>
    <a href="about.php"><img border="0" src="images/button-about.png" alt="About"/></a>
    </td>
    <td>
    <a href="about.php" class="menubar">About</a>
    <img src="images/nothing.png" width="15" alt=""/>
    </td>
    </tr>
    </table>
    <!-- End menu bar -->
  </td>
  <td width="128">
  <img src="images/page-2-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
<tr><td valign="top">
  <table border="0" cellpadding="0" cellspacing="0" width="100%">
  <tr>
  <td width="100">&nbsp;</td>
  <td valign="top">

<!-- Begin page content -->
<h1>Browse papers</h1>
<p><? echo db_num_rows($result); ?> matching paper(s).
<? if (!isset($_GET["view"])) { ?>
NOTE:  This sorted view
only displays papers whose <i>Author</i> field in nonempty and where the first
author appears in the bank of authors.  To view all papers undiscriminately,
use the <a href="browse-papers.php?view=unsorted">unsorted view</a>.
<? } else { ?>
Go to <a href="browse-papers.php">sorted view</a>.
<? } ?>
</p>
<ul class="paperbullet">
<?
while ($row = db_fetch_assoc_array($result))
{
  echo "<li>\n".format_paper_entry($db, $row, PRESENTATION_REGULAR)."\n</li>\n";
}
?>
</ul>
<!-- End page content -->

  </td>
  <td width="10">&nbsp;</td>
  </tr>
  </table>
</td></tr>
<tr><td style="height:40px;">
  <table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:40px;">
  <tr>
  <td width="86">
  <img src="images/page-b-w.png" alt=""/>
  </td>
  <td valign="middle" class="footer" style="background-image:url('images/page-b-c.png');">
  <!-- Begin footer -->
  &copy; 2005 Sylvain Hall&eacute;.  This software is released under the GNU
  GPL; see <a style="color:#cc0" href="COPYING">COPYING</a> for license
  information.  This page (and script) was last modified on
  <!-- date-modif -->2005-09-13.
  <!-- End footer -->
  </td>
  <td width="25">
  <img src="images/page-b-e.png" alt=""/>
  </td>
  </tr>
  </table>
</td></tr>
</table>

</body>
</html>
<?
// Closes connection
db_close($db);
?>
