/*
 * Created on 25.03.2003
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package resmedicinae.review.soap.service;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;

import org.apache.axis.AxisEngine;
import org.apache.axis.Message;
import org.apache.axis.attachments.Attachments;

/**
 * An example of 
 * This class has a main method that beside the standard arguments
 * allows you to specify an attachment that will be sent to a 
 * service which will then send it back.
 *
 * @author Jens Kleinschmidt
 */
public class ImageService {

	/**
	 * This method implements a web service that sends back
	 * any file as an attachment.
	 */
	public DataHandler getImage(String fileName) {
		// Attachments are sent back by default as a MIME stream if no attachments
    // were received. If attachments are received the same format that was
    // received will be the default stream type for any attachments sent back.

		// The following two commented lines would force any attachments sent back.
		// to be in DIME format.
		Message rspmsg = AxisEngine.getCurrentMessageContext().getResponseMessage();
		rspmsg.getAttachmentsImpl().setSendType(Attachments.SEND_TYPE_DIME);

		// Create the data handler for the attached file.
		DataHandler dataHandler = new DataHandler(new FileDataSource(fileName));

		return dataHandler;
	}

}
