/*
 * Created on 07.04.2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package resmedicinae.review.soap.client;

import java.io.File;
import java.util.Iterator;

import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

import org.apache.axis.AxisFault;

/**
 * @author Jens Kleinschmidt
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SAAJRPCClient {

	public static void main(String[] args) {
		try {
			// Calculate start time.
			long startTime = System.currentTimeMillis();
      System.out.print(args[0].substring(3, args[0].length()) + ";");
			System.out.print("0.0;");

			SOAPConnectionFactory soapConnectionFactory =
				SOAPConnectionFactory.newInstance();
			SOAPConnection soapConnection = soapConnectionFactory.createConnection();

			MessageFactory messageFactory = MessageFactory.newInstance();
			SOAPMessage soapMessage = messageFactory.createMessage();
			SOAPPart soapPart = soapMessage.getSOAPPart();

			String fileName = args[0];

			SOAPEnvelope requestEnvelope = soapPart.getEnvelope();
			SOAPBody body = requestEnvelope.getBody();
			SOAPBodyElement bodyElement =
				body.addBodyElement(
					requestEnvelope.createName("getImage", "ns1", "urn:ImageServiceRPC"));
			SOAPElement element =
				bodyElement.addChildElement(requestEnvelope.createName("filename"));
			element.addTextNode(fileName);

			String targetEndpointAddress =
				"http://" + args[1] + ":8080/axis/services/urn:ImageServiceRPC";

			SOAPMessage returnedSOAPMessage =
				soapConnection.call(soapMessage, targetEndpointAddress);

			long beforeRCTime = System.currentTimeMillis();
			System.out.print((beforeRCTime - startTime) / 1000f + ";");
			Iterator iterator = returnedSOAPMessage.getAttachments();
			long afterRCTime = System.currentTimeMillis();
			System.out.print((afterRCTime - startTime) / 1000f + ";");
			if (!iterator.hasNext()) {
				// The wrong type of object that what was expected.
				System.out.println("Received problem response from server");
				throw new AxisFault(
					"",
					"Received problem response from server",
					null,
					null);
			}
			DataHandler rdh =
				(DataHandler) ((AttachmentPart)iterator.next()).getDataHandler();

			// Get the filename.
			String receivedFileName = rdh.getName();

			if (receivedFileName == null) {
				System.err.println("Could not get the file name.");
				throw new AxisFault("", "Could not get the file name.", null, null);
			}

			File receivedFile = new File(receivedFileName);
			receivedFile.delete();

			// Calculate stop time.
			long stopTime = System.currentTimeMillis();
			System.out.println((stopTime - startTime) / 1000f);
		}
		catch (Exception exception) {
			System.err.println("ERROR : " + exception);
			exception.printStackTrace();
		}
	}

}
