/*
 * Created on 26.03.2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package resmedicinae.review.soap.client;

import java.io.File;
import java.net.URL;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory;
import org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory;

/**
 * An example of sending an attachment via RPC.
 * This class has a main method that beside the standard arguments
 * allows you to specify an attachment that will be sent to a 
 * service which will then send it back.
 *
 * @author Jens Kleinschmidt
 */
public class RPCClient {

	/**
	 * Give a single file to send or name a directory
	 * to send an array of attachments of the files in
	 * that directory.
	 *
	 * This method sends a file as an attachment then 
	 * receives it as a return. The returned file is
	 * compared to the source.
	 * @param The filename that is the source to send.
	 * @return True if sent and compared.
	 */
	public static void main(String[] args) {
		try {
			// Calculate start time.
			long startTime = System.currentTimeMillis();
			System.out.print(args[0].substring(3, args[0].length()) + ";");
			System.out.print("0.0;");

			// Create the data handler for the attached file.
			Service service = new Service();
			Call call = (Call) service.createCall();

			// Set the target service host and service location.
      String host = args[1];
			call.setTargetEndpointAddress(
				new URL("http://" + host + ":8080/axis/services/urn:ImageServiceRPC"));

			// This is the target services method to invoke.
			call.setOperationName(new QName("urn:ImageServiceRPC", "getImage"));
			QName qNameFile = new QName("urn:ImageServiceRPC", "DataHandler");

			// Add serializer/deserializer for attachment.
			call.registerTypeMapping(
				DataHandler.class,
				qNameFile,
				JAFDataHandlerSerializerFactory.class,
				JAFDataHandlerDeserializerFactory.class);

			// Add the file name.
			call.addParameter("filename", XMLType.XSD_STRING, ParameterMode.IN);
			call.setReturnType(qNameFile);
			call.setUsername("");
			call.setPassword("");

			String fileName = args[0];

			long beforeRCTime = System.currentTimeMillis();
			System.out.print((beforeRCTime - startTime) / 1000f + ";");
			// Add the parameter value.
			Object ret = call.invoke(new Object[] { fileName });
			long afterRCTime = System.currentTimeMillis();
			System.out.print((afterRCTime - startTime) / 1000f + ";");

			if (ret == null) {
				System.out.println("Received null ");
				throw new AxisFault("", "Received null", null, null);
			}

			if (ret instanceof String) {
				System.out.println(
					"Received problem response from server: " + ret);
				throw new AxisFault("", (String) ret, null, null);
			}

			if (!(ret instanceof DataHandler)) {
				// The wrong type of object that what was expected.
				System.out.println(
					"Received problem response from server:"
						+ ret.getClass().getName());
				throw new AxisFault(
					"",
					"Received problem response from server:"
						+ ret.getClass().getName(),
					null,
					null);
			}
			DataHandler rdh = (DataHandler) ret;

			// Get the filename.
			String receivedFileName = rdh.getName(); 

			if (receivedFileName == null) {
				System.err.println("Could not get the file name.");
				throw new AxisFault(
					"",
					"Could not get the file name.",
					null,
					null);
			}

			File receivedFile = new File(receivedFileName);
			receivedFile.delete();

			// Calculate stop time.
			long stopTime = System.currentTimeMillis();
			System.out.println((stopTime - startTime) / 1000f);
		}
		catch (Exception exception) {
			System.err.println("ERROR : " + exception);
			exception.printStackTrace();
		}
	}

}
