/*
 * $RCSfile: ImageServer.java,v $
 *
 * Copyright (c) 1999-2003. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.review.corba.server;

import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import resmedicinae.review.corba.idl.image.IImage;
import resmedicinae.review.corba.idl.image.IImageHelper;

/**
 * Test Server.
 *
 * @version $Revision: 1.1 $ $Date: 2003/04/16 10:16:02 $ $Author: chrissy $
 * @author Jens Kleinschmidt <jens.kleinschmidt@gmx.de>
 */
public class ImageServer {

    public static void main(String[] args) {

    try {

        // Create and initialize the ORB.
        ORB orb = ORB.init(args, null);
        
        // Get reference to rootpoa & activate the POAManager.
        POA rootpoa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
        rootpoa.the_POAManager().activate();
        
        // Create servant and register it with the ORB.
        ImageServerImpl imageServerImpl = new ImageServerImpl("Image");
        imageServerImpl.setORB(orb);
        
        // Get object reference from the servant.
        org.omg.CORBA.Object ref = rootpoa.servant_to_reference(imageServerImpl);
        IImage href = IImageHelper.narrow(ref);
        
        // Get the root naming context.
        // NameService invokes the name service.
        org.omg.CORBA.Object objRef =
        orb.resolve_initial_references("NameService");
        // Use NamingContextExt which is part of the Interoperable
        // Naming Service (INS) specification.
        NamingContextExt ncRef = NamingContextExtHelper.narrow(objRef);
        
        // bind the Object Reference in Naming
        String name = "Image";
        NameComponent path[] = ncRef.to_name(name);
        ncRef.rebind(path, href);
        
        System.out.println("Image server ready and waiting ...");
        
        // Wait for invocations from clients.
        orb.run();
        
        } catch (Exception exception) {

            System.err.println("ERROR: " + exception);
            exception.printStackTrace(System.out);
        }

        System.out.println("Image server exiting ...");
    }
}

