/*
 * $RCSfile: Client.java,v $
 *
 * Copyright (c) 1999-2003. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package resmedicinae.review.corba.client;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import org.omg.CORBA.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import resmedicinae.review.corba.idl.image.IImage;
import resmedicinae.review.corba.idl.image.IImageHelper;

/**
 * Test Client.
 *
 * @version $Revision: 1.1 $ $Date: 2003/04/16 10:15:59 $ $Author: chrissy $
 * @author Jens Kleinschmidt <jens.kleinschmidt@gmx.de>
 */
public class Client {

	static IImage serverImpl;

	public static void main(String[] args) {

		try {

			// Calculate start time.
			long startTime = System.currentTimeMillis();
            System.out.print(args[1].substring(3, args[1].length()) + ";");
			System.out.print("0.0;");

			// Create and initialize the ORB.
			ORB orb = ORB.init(args, null);

			// Get the root naming context.
			org.omg.CORBA.Object objRef =
				orb.resolve_initial_references("NameService");

			// Use NamingContextExt instead of NamingContext. This is
			// part of the Interoperable naming Service.
			NamingContextExt ncRef = NamingContextExtHelper.narrow(objRef);

			// Resolve the Object Reference in Naming.
			String name = "Image";
			serverImpl = IImageHelper.narrow(ncRef.resolve_str(name));

			String fileName = args[1];
			String receivedFileName = args[1] + ".bak";

			long beforeRCTime = System.currentTimeMillis();
			System.out.print((beforeRCTime - startTime) / 1000f + ";");
			byte[] imageByteArray = serverImpl.getImage(fileName).imageData;
			long afterRCTime = System.currentTimeMillis();
			System.out.print((afterRCTime - startTime) / 1000f + ";");
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			DataOutputStream fileOut =
				new DataOutputStream(
					new BufferedOutputStream(
						new FileOutputStream(receivedFileName)));
			out.write(imageByteArray);
			out.writeTo(fileOut);

			File receivedFile = new File(receivedFileName);
			receivedFile.delete();

			// Calculate stop time.
			long stopTime = System.currentTimeMillis();
			System.out.println((stopTime - startTime) / 1000f + ";");
		
        } catch (Exception exception) {
            
			System.err.println("ERROR : " + exception);
			exception.printStackTrace();
		}
	}
}

