/*
 * $RCSfile: String.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.term;

import org.resmedicinae.resmedlib.*;

/**
 * This class represents a string.
 *
 * A string is an addition of characters.
 *
 * For now, this class just encapsulates a string of the java language.
 *
 * @version $Revision: 1.14 $ $Date: 2002/12/10 17:27:54 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class String extends Term {

    //
    // Constructable.
    //

    /**
     * Constructs this string.
     */
    public String() {

        super();
    }

    /**
     * Constructs this string.<br><br>
     *
     * Normally, constructors are NOT used in the ResMedLib framework,
     * because no counterparts (destructors) exist in the java language.
     * The aim of this prohibition is to ensure a proper startup and shutdown
     * (lifecycle) of every item in the system.<br><br>
     *
     * However, when it comes to lower abstraction (language) levels of our
     * ontology, we need to make some exceptions:<br>
     * Whenever a string such as "string" is given in quotation marks,
     * the java language constructs a new string object anyway.
     * So, it doesn't matter if also we are creating strings which do not
     * get properly destroyed by the lifecycle, but only by the garbage collector
     * after an indefinable time.
     *
     * Most often, such strings are needed/created as static variables to define
     * constants, e.g. attribute ids. That's why we need this string constructor.
     *
     * @param s the java string
     */
    public String(java.lang.String s) {

        super();
        setJavaObject(s);
    }

    //
    // Encapsulated java string.
    //
    
    /**
     * Creates an encapsulated java string.
     *
     * @return the encapsulated java string
     */
    public java.lang.Object createJavaObject() {

        return new java.lang.String();
    }

    //
    // Algebraic methods.
    //

    /**
     * Tests if this string is equal to the given string.
     *
     * @param s the string
     * @return true - if this string is equal to the given string;
     * false - otherwise
     * @exception NullPointerException if the string is null
     */
    public boolean isEqualTo(org.resmedicinae.resmedlib.term.String s) throws NullPointerException {

        boolean result = org.resmedicinae.resmedlib.digit.Boolean.FALSE;

        if (s != null) {

            java.lang.String o = (java.lang.String) getJavaObject();

            if (o != null) {

                if (o.equals(s.getJavaObject())) {

                    result = org.resmedicinae.resmedlib.digit.Boolean.TRUE;
                }

            } else {

                throw new NullPointerException("Could not test string. The value of this string is null.");
            }

        } else {

            throw new NullPointerException("Could not test string. The string is null.");
        }

        return result;
    }

    //
    // Deprecated.
    //

    /**
     * @deprecated
     */
    public void setValue(java.lang.String value){

        setJavaObject(value);
    }

    /**
     * @deprecated
     */
    public java.lang.String getValue(){

        return (java.lang.String)getJavaObject();
    }
}

