/*
 * $RCSfile: Window.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical.frame;

import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.region.view.graphical.*;

/**
 * This class represents a window.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Window extends Frame {

    //
    // Static attribute ids.
    //

    /** The x coordinate of the window id. */
    public static final org.resmedicinae.resmedlib.term.String WINDOW_X = new org.resmedicinae.resmedlib.term.String("window_x");
    /** The y coordinate of the window id. */
    public static final org.resmedicinae.resmedlib.term.String WINDOW_Y = new org.resmedicinae.resmedlib.term.String("window_y");
    /** The window width id. */
    public static final org.resmedicinae.resmedlib.term.String WINDOW_WIDTH = new org.resmedicinae.resmedlib.term.String("window_width");
    /** The window height id. */
    public static final org.resmedicinae.resmedlib.term.String WINDOW_HEIGHT = new org.resmedicinae.resmedlib.term.String("window_height");

    //
    // Attributes.
    //
    
    /** The encapsulated java swing window. */
    private javax.swing.JWindow window;

    //
    // Bounds.
    //

    /**
     * Creates a rectangle storing the bounds.
     *
     * @return the rectangle storing the bounds
     */
    public java.awt.Rectangle createBounds() {

        // Determine width.
        int w = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getWidth());

        // Use centered x position by default.
        int x = 0;

        // Determine height.
        int h = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getHeight());

        // Use centered y position by default.
        int y = 0;

        return new java.awt.Rectangle(x, y, w, h);
    }

    //
    // Encapsulated swing window.
    //
    
    /**
     * Creates an encapsulated swing window.
     *
     * @return the encapsulated swing window
     */
    public javax.swing.JWindow createWindow() {
        
        return new javax.swing.JWindow();
    }
    
    /**
     * Destroys the encapsulated swing window.
     *
     * @param window the encapsulated swing window
     */
    public void destroyWindow(javax.swing.JWindow window) {
    }
    
    /**
     * Sets the encapsulated swing window.
     *
     * @param window the encapsulated swing window
     */
    public void setWindow(javax.swing.JWindow window) {
     
        this.window = window;
    }
    
    /**
     * Returns the encapsulated swing window.
     *
     * @return the encapsulated swing window
     */
    public javax.swing.JWindow getWindow() {
     
        return this.window;
    }

    //
    // Root pane.
    //

    /**
     * Creates a root pane.
     *
     * @return the root pane
     */
    public RootPane createRootPane() {

        return new RootPane();
    }

    /**
     * Destroys the root pane.
     *
     * @param rootPane the root pane
     */
    public void destroyRootPane(RootPane rootPane) {
    }
    
    //
    // Initialization.
    //
    
    /**
     * Initializes this window.
     */
    public void initialize() throws Exception {
        
        setWindow(createWindow());
    }
    
    /**
     * Finalizes this window.
     */
    public void finalizz() throws Exception {
        
        destroyWindow(getWindow());
        setWindow(null);
    }
}

