/*
 * $RCSfile: TabPage.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical.frame;

import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.region.view.graphical.*;

/**
 * This class represents a tab page.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class TabPage extends Frame { //?? implements javax.accessibility.Accessible, javax.swing.RootPaneContainer {

    //
    // Static attribute ids.
    //

    /** The root pane bound property name. */
/*??
    public final static org.resmedicinae.resmedlib.term.String ROOT_PANE_PROPERTY = new org.resmedicinae.resmedlib.term.String("rootPane");

    /** The content pane bound property name. */
/*??
    public final static org.resmedicinae.resmedlib.term.String CONTENT_PANE_PROPERTY = new org.resmedicinae.resmedlib.term.String("contentPane");

    /** The layered pane bound property name. */
/*??
    public final static org.resmedicinae.resmedlib.term.String LAYERED_PANE_PROPERTY = new org.resmedicinae.resmedlib.term.String("layeredPane");

    /** The glass pane bound property name. */
/*??
    public final static org.resmedicinae.resmedlib.term.String GLASS_PANE_PROPERTY = new org.resmedicinae.resmedlib.term.String("glassPane");

    /** Bound property name. */
/*??
    public final static String MENU_BAR_PROPERTY = "JMenuBar";

    /** Bound property name. */
/*??
    public final static String TITLE_PROPERTY = "title";

    //
    // Attributes.
    //

    /**
     * The JRootPane instance that manages the content pane and
     * optional menu bar for this tab page, as well as the glass pane.
     */
    private RootPane rootPane;

    //
    // Root pane.
    //

    /**
     * Creates a root pane.
     *
     * @return the root pane
     */
    public RootPane createRootPane() {

        return new RootPane();
    }

    /**
     * Destroys the root pane.
     *
     * @param rootPane the root pane
     */
    public void destroyRootPane(RootPane rootPane) {
    }
    
    /**
     * Sets the root pane.
     *
     * @param rootPane the root pane
     */
    public void setRootPane(RootPane rootPane) {

        if (this.rootPane != null) {

//??            remove(this.rootPane);
        }

        if (rootPane != null) {

//??            add(rootPane, java.awt.BorderLayout.CENTER);
        }

        RootPane old = getRootPane();
        this.rootPane = rootPane;

//??        firePropertyChange(ROOT_PANE_PROPERTY, old, rootPane);
    }

    /**
     * Return the root pane.
     *
     * The rootPane has two children: the glassPane and the layeredPane.
     *
     * @return the root pane
     */
    public RootPane getRootPane() {

        return this.rootPane;
    }

    //
    // Content pane.
    //
    
    /**
     * Sets the content pane.
     *
     * The content pane is the primary container for application specific
     * components, i.e. for the contents of the root pane. Applications should
     * add children to the contentPane, set its layout manager and so on.
     *
     * The contentPane my not be null.
     *
     * Generally implemented with
     * <code>getRootPane().setContentPane(contentPane);</code>
     *
     * @param contentPane the content pane
     * @exception java.awt.IllegalComponentStateException (a runtime
     * exception) if the content pane parameter is null
     * @see JRootPane#getContentPane
     * @see #getContentPane
     */
/*??
    public void setContentPane(java.awt.Container contentPane) {

        java.awt.Container old = getContentPane();
        RootPane r = getRootPane();

        if (r != null) {

            r.setContentPane(contentPane);
            firePropertyChange(CONTENT_PANE_PROPERTY, old, contentPane);
        }
    }

    /**
     * Returns the content pane.
     *
     * @return the content pane
     * @see #setContentPane
     */
/*??
    public java.awt.Container getContentPane() {

        java.awt.Container c = null;
        RootPane r = getRootPane();

        if (r != null) {

            c = r.getContentPane();
        }

        return c;
    }

    //
    // Layered pane.
    //
    
    /**
     * Sets the layered pane.
     *
     * A container that manages the content pane and in some cases a menu bar.
     * The layered pane can be used by descendants that want to add a child
     * to the RootPaneContainer that isn't layout managed.  For example
     * an internal dialog or a drag and drop effect component.
     *
     * The layeredPane may not be null.
     *
     * Generally implemented with
     * <code>getRootPane().setLayeredPane(layeredPane);</code>
     *
     * @param layeredPane the layered pane
     * @exception java.awt.IllegalComponentStateException (a runtime
     * exception) if the layered pane parameter is null
     * @see #getLayeredPane
     * @see JRootPane#getLayeredPane
     */
/*??
    public void setLayeredPane(LayeredPane layeredPane) {

        LayeredPane old = getLayeredPane();
        RootPane r = getRootPane();

        if (r != null) {

            r.setLayeredPane(layeredPane);
//??            firePropertyChange(LAYERED_PANE_PROPERTY, old, layeredPane);
        }
    }

    /**
     * Returns the layered pane.
     *
     * @return the layered pane
     * @see #setLayeredPane
     */
/*??
    public LayeredPane getLayeredPane() {

        LayeredPane l = null;
        RootPane r = getRootPane();

        if (r != null) {

            l = r.getLayeredPane();
        }

        return l;
    }

    //
    // Glass pane.
    //
    
    /**
     * Sets the glass pane.
     *
     * The glass pane is always the first child of the root pane and
     * the root panes layout manager ensures that it's always as big as
     * the rootPane. By default, it is transparent and not visible.
     * It can be used to temporarily grab all keyboard and mouse input
     * by adding listeners and then making it visible.
     * By default, it is not visible.
     *
     * The glass pane may not be null.
     *
     * Generally implemented with
     * <code>getRootPane().setGlassPane(glassPane);</code>
     *
     * @param glassPane the glass pane
     * @see #getGlassPane
     * @see JRootPane#setGlassPane
     */
/*??
    public void setGlassPane(java.awt.Component glassPane) {

        java.awt.Component old = getGlassPane();
        RootPane r = getRootPane();

        if (r != null) {

            r.setGlassPane(glassPane);
            firePropertyChange(GLASS_PANE_PROPERTY, old, glassPane);
        }
    }

    /**
     * Returns the glass pane.
     *
     * @return the glass pane
     * @see #setGlassPane
     */
/*??
    public java.awt.Component getGlassPane() {

        java.awt.Component g = null;
        RootPane r = getRootPane();

        if (r != null) {

            g = r.getGlassPane();
        }

        return g;
    }

    //
    // Initialization.
    //
    
    /**
     * Initializes this panel.
     */
    public void initialize() throws Exception {
        
        setRootPane(createRootPane());
    }
    
    /**
     * Finalizes this panel.
     */
    public void finalizz() throws Exception {
        
        destroyRootPane(getRootPane());
        setRootPane(null);
    }
}

