/*
 * $RCSfile: StandardFrame.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical.frame;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.region.view.graphical.*;

/**
 * This class represents a standard frame.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class StandardFrame extends Frame {

    //
    // Static attribute ids.
    //

    /** The x coordinate of the frame id. */
    public static final org.resmedicinae.resmedlib.term.String FRAME_X = new org.resmedicinae.resmedlib.term.String("frame_x");
    /** The y coordinate of the frame id. */
    public static final org.resmedicinae.resmedlib.term.String FRAME_Y = new org.resmedicinae.resmedlib.term.String("frame_y");
    /** The frame width id. */
    public static final org.resmedicinae.resmedlib.term.String FRAME_WIDTH = new org.resmedicinae.resmedlib.term.String("frame_width");
    /** The frame height id. */
    public static final org.resmedicinae.resmedlib.term.String FRAME_HEIGHT = new org.resmedicinae.resmedlib.term.String("frame_height");

    //
    // Title.
    //
    
    /**
     * Sets the title.
     *
     * @param t the title
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the title is null
     */
    public void setTitle(org.resmedicinae.resmedlib.term.String t) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();

        if (f != null) {

            if (t != null) {
                
                f.setTitle((java.lang.String) t.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set title. The title is null.");
            }

        } else {

            throw new NullPointerException("Could not set title. The java frame is null.");
        }
    }

    /**
     * Removes the title.
     *
     * @param t the title
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the title is null
     */
    public void removeTitle(org.resmedicinae.resmedlib.term.String t) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();

        if (f != null) {

            if (t != null) {
                
                f.setTitle(null);

            } else {
    
                throw new NullPointerException("Could not set title. The title is null.");
            }

        } else {

            throw new NullPointerException("Could not set title. The java frame is null.");
        }
    }

    //
    // Icon.
    //
    
    /**
     * Sets the icon.
     *
     * @param i the icon
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the icon is null
     */
    public void setIcon(org.resmedicinae.resmedlib.term.String i) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (i != null) {
                
//??                f.setIconImage(i.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set icon. The icon is null.");
            }

        } else {

            throw new NullPointerException("Could not set icon. The java frame is null.");
        }
    }

    /**
     * Removes the icon.
     *
     * @param i the icon
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the icon is null
     */
    public void removeIcon(org.resmedicinae.resmedlib.term.String i) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (i != null) {
                
                f.setIconImage(null);

            } else {
    
                throw new NullPointerException("Could not set icon. The icon is null.");
            }

        } else {

            throw new NullPointerException("Could not set icon. The java frame is null.");
        }
    }

    //
    // Menu bar.
    //
    
    /**
     * Sets the menu bar.
     *
     * @param m the menu bar
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the menu bar is null
     */
    public void setMenuBar(org.resmedicinae.resmedlib.region.view.graphical.MenuBar m) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (m != null) {
                
                f.setJMenuBar((javax.swing.JMenuBar) m.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set menu bar. The menu bar is null.");
            }

        } else {

            throw new NullPointerException("Could not set menu bar. The java frame is null.");
        }
    }

    /**
     * Removes the menu bar.
     *
     * @param m the menu bar
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the menu bar is null
     */
    public void removeMenuBar(org.resmedicinae.resmedlib.region.view.graphical.MenuBar m) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (m != null) {
                
                f.setJMenuBar(null);

            } else {
    
                throw new NullPointerException("Could not set menu bar. The menu bar is null.");
            }

        } else {

            throw new NullPointerException("Could not set menu bar. The java frame is null.");
        }
    }

    //
    // Tool bar.
    //
    
    /**
     * Sets the tool bar.
     *
     * @param t the tool bar
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the tool bar is null
     * @exception NullPointerException if the content pane is null
     */
    public void setToolBar(org.resmedicinae.resmedlib.region.view.graphical.ToolBar t) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (t != null) {

                java.awt.Container cp = f.getContentPane();
                
                if (cp != null) {
                    
                    cp.add((javax.swing.JToolBar) t.getJavaObject(), java.awt.BorderLayout.NORTH);

                } else {
        
                    throw new NullPointerException("Could not set tool bar. The content pane is null.");
                }

            } else {
    
                throw new NullPointerException("Could not set tool bar. The tool bar is null.");
            }

        } else {

            throw new NullPointerException("Could not set tool bar. The java frame is null.");
        }
    }

    /**
     * Removes the tool bar.
     *
     * @param t the tool bar
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the tool bar is null
     * @exception NullPointerException if the content pane is null
     */
    public void removeToolBar(org.resmedicinae.resmedlib.region.view.graphical.ToolBar t) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (t != null) {

                java.awt.Container cp = f.getContentPane();
                
                if (cp != null) {
                    
                    cp.remove((javax.swing.JToolBar) t.getJavaObject());

                } else {
        
                    throw new NullPointerException("Could not set tool bar. The content pane is null.");
                }

            } else {
    
                throw new NullPointerException("Could not set tool bar. The tool bar is null.");
            }

        } else {

            throw new NullPointerException("Could not set tool bar. The java frame is null.");
        }
    }

    //
    // Contents panel.
    //
    
    /**
     * Sets the contents panel.
     *
     * @param c the contents panel
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the contents panel is null
     * @exception NullPointerException if the content pane is null
     */
    public void setContentsPanel(org.resmedicinae.resmedlib.region.view.graphical.ContentsPanel c) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();

        if (f != null) {

            if (c != null) {
                
                java.awt.Container cp = f.getContentPane();
                
                if (cp != null) {
                    
                    cp.add((javax.swing.JPanel) c.getJavaObject(), java.awt.BorderLayout.CENTER);

                } else {
        
                    throw new NullPointerException("Could not set contents panel. The content pane is null.");
                }

            } else {
    
                throw new NullPointerException("Could not set contents panel. The contents panel is null.");
            }

        } else {

            throw new NullPointerException("Could not set contents panel. The java frame is null.");
        }
    }

    /**
     * Removes the contents panel.
     *
     * @param c the contents panel
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the contents panel is null
     * @exception NullPointerException if the content pane is null
     */
    public void removeContentsPanel(org.resmedicinae.resmedlib.region.view.graphical.ContentsPanel c) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();

        if (f != null) {

            if (c != null) {
                
                java.awt.Container cp = f.getContentPane();
                
                if (cp != null) {
                    
                    cp.remove((javax.swing.JPanel) c.getJavaObject());

                } else {
        
                    throw new NullPointerException("Could not set contents panel. The content pane is null.");
                }

            } else {
    
                throw new NullPointerException("Could not set contents panel. The contents panel is null.");
            }

        } else {

            throw new NullPointerException("Could not set contents panel. The java frame is null.");
        }
    }

    //
    // Status bar.
    //
    
    /**
     * Sets the status bar.
     *
     * @param s the status bar
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the status bar is null
     * @exception NullPointerException if the content pane is null
     */
    public void setStatusBar(org.resmedicinae.resmedlib.region.view.graphical.StatusBar s) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (s != null) {
                
                java.awt.Container cp = f.getContentPane();
                
                if (cp != null) {
                    
                    cp.add((javax.swing.JLabel) s.getJavaObject(), java.awt.BorderLayout.SOUTH);

                } else {
        
                    throw new NullPointerException("Could not set status bar. The content pane is null.");
                }

            } else {
    
                throw new NullPointerException("Could not set status bar. The status bar is null.");
            }

        } else {

            throw new NullPointerException("Could not set status bar. The java frame is null.");
        }
    }

    /**
     * Removes the status bar.
     *
     * @param s the status bar
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the status bar is null
     * @exception NullPointerException if the content pane is null
     */
    public void removeStatusBar(org.resmedicinae.resmedlib.region.view.graphical.StatusBar s) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (s != null) {
                
                java.awt.Container cp = f.getContentPane();
                
                if (cp != null) {
                    
                    cp.remove((javax.swing.JLabel) s.getJavaObject());

                } else {
        
                    throw new NullPointerException("Could not set status bar. The content pane is null.");
                }

            } else {
    
                throw new NullPointerException("Could not set status bar. The status bar is null.");
            }

        } else {

            throw new NullPointerException("Could not set status bar. The java frame is null.");
        }
    }

    //
    // Bounds.
    //

    /**
     * Creates a rectangle storing the bounds.
     *
     * @return the rectangle storing the bounds
     */
    public java.awt.Rectangle createBounds() throws NullPointerException {

        // Determine width.
        int w = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getWidth());

        // Use centered x position by default.
        int x = 0;

        // Determine height.
        int h = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getHeight());

        // Use centered y position by default.
        int y = 0;

        return new java.awt.Rectangle(x, y, w, h);
    }

    /**
     * Sets the bounds.
     *
     * @param b the bounds
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the bounds is null
     */
    public void setBounds(java.awt.Rectangle b) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (b != null) {
                
//??                f.setBounds(b.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set bounds. The bounds is null.");
            }

        } else {

            throw new NullPointerException("Could not set bounds. The java frame is null.");
        }
    }

    /**
     * Removes the bounds.
     *
     * @param b the bounds
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the bounds is null
     */
    public void removeBounds(java.awt.Rectangle b) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (b != null) {

//??                f.removeBounds(b.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set bounds. The bounds is null.");
            }

        } else {

            throw new NullPointerException("Could not set bounds. The java frame is null.");
        }
    }

    //
    // Resizable flag.
    //
    
    /**
     * Sets the resizable flag.
     *
     * @param r the resizable flag
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the resizable flag is null
     */
    public void setResizable(org.resmedicinae.resmedlib.digit.Boolean r) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (r != null) {
                
                f.setResizable(r.getJavaPrimitive());

            } else {
    
                throw new NullPointerException("Could not set resizable flag. The resizable flag is null.");
            }

        } else {

            throw new NullPointerException("Could not set resizable flag. The java frame is null.");
        }
    }

    /**
     * Removes the resizable flag.
     *
     * @param r the resizable flag
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the resizable flag is null
     */
    public void removeResizable(org.resmedicinae.resmedlib.digit.Boolean r) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (r != null) {
                
                f.setResizable(org.resmedicinae.resmedlib.digit.Boolean.FALSE);

            } else {
    
                throw new NullPointerException("Could not set resizable flag. The resizable flag is null.");
            }

        } else {

            throw new NullPointerException("Could not set resizable flag. The java frame is null.");
        }
    }

    //
    // Close signal.
    //
    
    /**
     * Sets the close signal.
     *
     * @param s the close signal
     * @exception NullPointerException if the java frame is null
     * @exception NullPointerException if the close signal is null
     */
/*??
    public void setCloseSignal(org.resmedicinae.resmedlib.Signal s) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) getJavaObject();
    
        if (f != null) {

            if (s != null) {

//??                f.setCloseSignal(c);

//??                f.addWindowListener(new WindowDisplayAdapter(v));

            } else {
    
                throw new NullPointerException("Could not set close signal. The close signal is null.");
            }

        } else {

            throw new NullPointerException("Could not set close signal. The java frame is null.");
        }
    }

    //
    // Encapsulated java swing frame.
    //
    
    /**
     * Creates an encapsulated java swing frame.
     *
     * @return the encapsulated java swing frame
     * @exception NullPointerException if the java swing frame is null
     */
    public java.lang.Object createJavaObject() throws NullPointerException {

        javax.swing.JFrame f = new javax.swing.JFrame();
        
        if (f != null) {

            f.setVisible(org.resmedicinae.resmedlib.digit.Boolean.TRUE);
        
        } else {

            throw new NullPointerException("Could not create encapsulated java swing frame. The encapsulated java swing frame is null.");
        }

        return f;
    }

    /**
     * Destroys the encapsulated java swing frame.
     *
     * @return the encapsulated java swing frame
     * @exception NullPointerException if the java swing frame is null
     */
    public void destroyJavaObject(java.lang.Object o) throws NullPointerException {

        javax.swing.JFrame f = (javax.swing.JFrame) o;
        
        if (f != null) {

            f.setVisible(org.resmedicinae.resmedlib.digit.Boolean.FALSE);
        
        } else {

            throw new NullPointerException("Could not destroy encapsulated java swing frame. The encapsulated java swing frame is null.");
        }
    }

    //
    // Initializable.
    //
    
    /**
     * Initializes this frame.
     */
    public void initialize() throws Exception {
        
        super.initialize();
    }

    /**
     * Finalizes this frame.
     */
    public void finalizz() throws Exception {
        
        try {
            
        } finally {
            
            super.finalizz();
        }
    }
}

