/*
 * $RCSfile: InternalFrame.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical.frame;

import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.region.view.graphical.*;

/**
 * This class represents an internal frame.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class InternalFrame extends Frame {

    //
    // Static attribute ids.
    //

    /** The x coordinate of the internal frame id. */
    public static final org.resmedicinae.resmedlib.term.String INTERNAL_FRAME_X = new org.resmedicinae.resmedlib.term.String("internal_frame_x");
    /** The y coordinate of the internal frame id. */
    public static final org.resmedicinae.resmedlib.term.String INTERNAL_FRAME_Y = new org.resmedicinae.resmedlib.term.String("internal_frame_y");
    /** The internal frame width id. */
    public static final org.resmedicinae.resmedlib.term.String INTERNAL_FRAME_WIDTH = new org.resmedicinae.resmedlib.term.String("internal_frame_width");
    /** The internal frame height id. */
    public static final org.resmedicinae.resmedlib.term.String INTERNAL_FRAME_HEIGHT = new org.resmedicinae.resmedlib.term.String("internal_frame_height");

    //
    // Attributes.
    //

    /** The encapsulated java swing internalFrame. */
    private javax.swing.JInternalFrame internalFrame;

    //
    // Bounds.
    //

    /**
     * Creates a rectangle storing the bounds.
     *
     * @return the rectangle storing the bounds
     */
    public java.awt.Rectangle createBounds() {

        // Determine width.
        int screenWidth = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 640;

        if (w > screenWidth) {

            w = screenWidth;
        }

        // Use centered x position by default.
        int x = 10;

        // Determine height.
        int screenHeight = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 480;

        if (h > screenHeight) {

            h = screenHeight;
        }

        // Use centered y position by default.
        int y = 10;

        return new java.awt.Rectangle(x, y, w, h);
    }

    //
    // Encapsulated swing internalFrame.
    //
    
    /**
     * Creates an encapsulated swing internalFrame.
     *
     * @return the encapsulated swing internalFrame
     */
    public javax.swing.JInternalFrame createInternalFrame() {
        
        return new javax.swing.JInternalFrame();
    }
    
    /**
     * Destroys the encapsulated swing internalFrame.
     *
     * @param internalFrame the encapsulated swing internalFrame
     */
    public void destroyInternalFrame(javax.swing.JInternalFrame internalFrame) {
    }
    
    /**
     * Sets the encapsulated swing internalFrame.
     *
     * @param internalFrame the encapsulated swing internalFrame
     */
    public void setInternalFrame(javax.swing.JInternalFrame internalFrame) {
     
        this.internalFrame = internalFrame;
    }
    
    /**
     * Returns the encapsulated swing internalFrame.
     *
     * @return the encapsulated swing internalFrame
     */
    public javax.swing.JInternalFrame getInternalFrame() {
     
        return this.internalFrame;
    }

    //
    // Root pane.
    //

    /**
     * Creates a root pane.
     *
     * @return the root pane
     */
    public RootPane createRootPane() {

        return new RootPane();
    }

    /**
     * Destroys the root pane.
     *
     * @param rootPane the root pane
     */
    public void destroyRootPane(RootPane rootPane) {
    }
    
    //
    // Initialization.
    //
    
    /**
     * Initializes this internalFrame.
     */
    public void initialize() throws Exception {
        
        setInternalFrame(createInternalFrame());
    }
    
    /**
     * Finalizes this internalFrame.
     */
    public void finalizz() throws Exception {
        
        destroyInternalFrame(getInternalFrame());
        setInternalFrame(null);
    }
}

