/*
 * $RCSfile: Dialog.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical.frame;

import org.resmedicinae.resmedlib.block.view.*;
import org.resmedicinae.resmedlib.region.view.graphical.*;

/**
 * This class represents a dialog.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Dialog extends Frame {

    //
    // Static attribute ids.
    //

    /** The x coordinate of the dialog id. */
    public static final org.resmedicinae.resmedlib.term.String DIALOG_X = new org.resmedicinae.resmedlib.term.String("dialog_x");
    /** The y coordinate of the dialog id. */
    public static final org.resmedicinae.resmedlib.term.String DIALOG_Y = new org.resmedicinae.resmedlib.term.String("dialog_y");
    /** The dialog width id. */
    public static final org.resmedicinae.resmedlib.term.String DIALOG_WIDTH = new org.resmedicinae.resmedlib.term.String("dialog_width");
    /** The dialog height id. */
    public static final org.resmedicinae.resmedlib.term.String DIALOG_HEIGHT = new org.resmedicinae.resmedlib.term.String("dialog_height");

    //
    // Attributes.
    //
    
    /** The owner. */
    private java.awt.Window owner;

    /** The title. */
    private org.resmedicinae.resmedlib.term.String title;

    /** The modal flag. */
    private org.resmedicinae.resmedlib.digit.Boolean modal;

    /** The encapsulated java swing dialog. */
    private javax.swing.JDialog dialog;

    //
    // Bounds.
    //

    /**
     * Creates a rectangle storing the bounds.
     *
     * @return the rectangle storing the bounds
     */
    public java.awt.Rectangle createBounds() {

        // Determine width.
        int screenWidth = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 640;

        if (w > screenWidth) {

            w = screenWidth;
        }

        // Use centered x position by default.
        int x = (screenWidth - w) / 2;

        // Determine height.
        int screenHeight = (int) Math.floor(java.awt.Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 480;

        if (h > screenHeight) {

            h = screenHeight;
        }

        // Use centered y position by default.
        int y = (screenHeight - h) / 2;

        return new java.awt.Rectangle(x, y, w, h);
    }

    //
    // Owner.
    //
    
    /**
     * Creates a owner.
     *
     * @return the owner
     */
    public java.awt.Window createOwner() {
        
        return null;
    }
    
    /**
     * Destroys the owner.
     *
     * @param owner the owner
     */
    public void destroyOwner(java.awt.Window owner) {
    }
    
    /**
     * Sets the owner.
     *
     * @param owner the owner
     */
    public void setOwner(java.awt.Window owner) {
     
        this.owner = owner;
    }
    
    /**
     * Returns the owner.
     *
     * @return the owner
     */
    public java.awt.Window getOwner() {

        return this.owner;
    }

    //
    // Title.
    //
    
    /**
     * Creates a title.
     *
     * @return the title
     */
    public org.resmedicinae.resmedlib.term.String createTitle() {
        
        return null;
    }
    
    /**
     * Destroys the title.
     *
     * @param title the title
     */
    public void destroyTitle(org.resmedicinae.resmedlib.term.String title) {
    }
    
    /**
     * Sets the title.
     *
     * @param title the title
     */
    public void setTitle(org.resmedicinae.resmedlib.term.String title) {
     
        this.title = title;
    }
    
    /**
     * Returns the title.
     *
     * @return the title
     */
    public org.resmedicinae.resmedlib.term.String getTitle() {

        return this.title;
    }

    //
    // Modal flag.
    //
    
    /**
     * Creates a modal flag.
     *
     * @return the modal flag
     */
    public org.resmedicinae.resmedlib.digit.Boolean createModal() {
        
        return null;
    }
    
    /**
     * Destroys the modal flag.
     *
     * @param modal the modal flag
     */
    public void destroyModal(org.resmedicinae.resmedlib.digit.Boolean modal) {
    }
    
    /**
     * Sets the modal flag.
     *
     * @param modal the modal flag
     */
    public void setModal(org.resmedicinae.resmedlib.digit.Boolean modal) {
     
        this.modal = modal;
    }
    
    /**
     * Returns the modal flag.
     *
     * @return the modal flag
     */
    public org.resmedicinae.resmedlib.digit.Boolean getModal() {

        return this.modal;
    }

    //
    // Root pane.
    //

    /**
     * Creates a root pane.
     *
     * @return the root pane
     */
    public RootPane createRootPane() {

        return new RootPane();
    }

    /**
     * Destroys the root pane.
     *
     * @param rootPane the root pane
     */
    public void destroyRootPane(RootPane rootPane) {
    }
    
    //
    // Encapsulated swing dialog.
    //
    
    /**
     * Creates an encapsulated swing dialog.
     *
     * @return the encapsulated swing dialog
     * @exception Exception if the owner is neither a frame nor a dialog
     */
    public javax.swing.JDialog createDialog() throws Exception {

        javax.swing.JDialog d = null;
/*??
        java.awt.Window owner = getOwner();
        
        if (owner instanceof java.awt.Frame) {
            
            d = new javax.swing.JDialog((java.awt.Frame) getOwner(), getTitle(), getModal());

        } else if (owner instanceof java.awt.Dialog) {

            d = new javax.swing.JDialog((java.awt.Dialog) getOwner(), getTitle(), getModal());
        
        } else {
         
            throw new Exception("Could not create dialog. The owner is neither a frame nor a dialog.");
        }
*/

        return d;
    }
    
    /**
     * Destroys the encapsulated swing dialog.
     *
     * @param dialog the encapsulated swing dialog
     */
    public void destroyDialog(javax.swing.JDialog dialog) {
    }
    
    /**
     * Sets the encapsulated swing dialog.
     *
     * @param dialog the encapsulated swing dialog
     */
    public void setDialog(javax.swing.JDialog dialog) {
     
        this.dialog = dialog;
    }
    
    /**
     * Returns the encapsulated swing dialog.
     *
     * @return the encapsulated swing dialog
     */
    public javax.swing.JDialog getDialog() {
     
        return this.dialog;
    }

    //
    // Initialization.
    //
    
    /**
     * Initializes this dialog.
     */
    public void initialize() throws Exception {
        
        setDialog(createDialog());
    }

    /**
     * Finalizes this dialog.
     */
    public void finalizz() throws Exception {
        
        destroyDialog(getDialog());
        setDialog(null);
    }
}

