/*
 * $RCSfile: Tree.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.region.view.*;

/**
 * This class represents a tree.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Tree extends GraphicalViewRegion {

    //
    // Static attribute ids.
    //

    /** The model id. */
    public static final org.resmedicinae.resmedlib.term.String MODEL = new org.resmedicinae.resmedlib.term.String("model");

    /** The selection model id. */
    public static final org.resmedicinae.resmedlib.term.String SELECTION_MODEL = new org.resmedicinae.resmedlib.term.String("selection_model");

    /** The cell renderer id. */
    public static final org.resmedicinae.resmedlib.term.String CELL_RENDERER = new org.resmedicinae.resmedlib.term.String("cell_renderer");

    /** The row height id. */
    public static final org.resmedicinae.resmedlib.term.String ROW_HEIGHT = new org.resmedicinae.resmedlib.term.String("row_height");

    /** The root visible id. */
    public static final org.resmedicinae.resmedlib.term.String ROOT_VISIBLE = new org.resmedicinae.resmedlib.term.String("root_visible");

    /** The editable id. */
    public static final org.resmedicinae.resmedlib.term.String EDITABLE = new org.resmedicinae.resmedlib.term.String("editable");

    /** The toggle click count id. */
    public static final org.resmedicinae.resmedlib.term.String TOGGLE_CLICK_COUNT = new org.resmedicinae.resmedlib.term.String("toggle_click_count");

    //
    // Child management.
    //

    /**
     * Adds the item to become a child of this item.
     *
     * @param n the name
     * @param i the item
     * @exception NullPointerException if the name is null
     */
    public void set(org.resmedicinae.resmedlib.term.String n, Item i) throws NullPointerException {

        super.set(n, i);

        if (n != null) {

            if (n.isEqualTo(Tree.MODEL)) {

                setModel(i);

/*??
            } else if (n.isEqualTo(Tree.MODEL)) {

                setModel((Component) i);
*/
            }

        } else {

            throw new NullPointerException("Could not set item. The name is null.");
        }
    }

    /**
     * Removes the child item from this item.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void remove(org.resmedicinae.resmedlib.term.String n) throws NullPointerException {

        try {
                
            if (n != null) {
    
                if (n.isEqualTo(Tree.MODEL)) {
    
                    setModel(null);
                
/*??
                } else if (n.isEqualTo(Tree.MODEL)) {
    
                    setModel(null);
*/
                }

            } else {
    
                throw new NullPointerException("Could not remove item. The name is null.");
            }

        } finally {
            
            super.remove(n);
        }
    }

    //
    // Encapsulated java swing tree.
    //

    /**
     * Creates an encapsulated java swing tree.
     *
     * @return the encapsulated java swing tree
     * @exception NullPointerException if the encapsulated java swing tree is null
     */
    public java.lang.Object createJavaObject() throws NullPointerException {

        javax.swing.JTree t = new javax.swing.JTree();
//??        javax.swing.JTree t = new javax.swing.JTree(new javax.swing.tree.DefaultTreeModel(new javax.swing.tree.DefaultMutableTreeNode("test")));

        if (t != null) {

            t.setToggleClickCount(1);
//??            t.setRootVisible(false);
            t.getSelectionModel().setSelectionMode(javax.swing.tree.TreeSelectionModel.SINGLE_TREE_SELECTION);
            t.setMinimumSize(new java.awt.Dimension(300, 400));

        } else {

            throw new NullPointerException("Could not create encapsulated java swing tree. The encapsulated java swing tree is null.");
        }

        return t;
    }

    //
    // Model.
    //

    /**
     * Sets the model.
     *
     * @param m the model
     * @exception NullPointerException if the java tree node is null
     * @exception NullPointerException if the model is null
     */
    public void setModel(Item m) throws NullPointerException {

        javax.swing.JTree t = (javax.swing.JTree) getJavaObject();

        if (t != null) {

            if (m != null) {

                t.setModel(new javax.swing.tree.DefaultTreeModel((javax.swing.tree.DefaultMutableTreeNode) m.getJavaTreeNode()));

            } else {

                throw new NullPointerException("Could not set model. The model is null.");
            }

        } else {

            throw new NullPointerException("Could not set model. The java tree node is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this tree.
     */
    public void initialize() throws Exception {

        super.initialize();
    }

    /**
     * Finalizes this tree.
     */
    public void finalizz() throws Exception {

        try {

        } finally {

            super.finalizz();
        }
    }
}

