/*
 * $RCSfile: SplitPane.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.region.view.*;

/**
 * This class represents a split pane.
 *
 * @version $Revision: 1.2 $ $Date: 2002/12/11 23:14:29 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class SplitPane extends GraphicalViewRegion {

    //
    // Static attribute ids.
    //

    /** The left component id. */
    public static final org.resmedicinae.resmedlib.term.String LEFT_COMPONENT = new org.resmedicinae.resmedlib.term.String("left_component");

    /** The right component id. */
    public static final org.resmedicinae.resmedlib.term.String RIGHT_COMPONENT = new org.resmedicinae.resmedlib.term.String("right_component");

    //
    // Child management.
    //

    /**
     * Adds the item to become a child of this item.
     *
     * @param n the name
     * @param i the item
     * @exception NullPointerException if the name is null
     */
    public void set(org.resmedicinae.resmedlib.term.String n, Item i) throws NullPointerException {

        super.set(n, i);

        if (n != null) {

            if (n.isEqualTo(SplitPane.LEFT_COMPONENT)) {

                setLeftComponent((Component) i);

            } else if (n.isEqualTo(SplitPane.RIGHT_COMPONENT)) {

                setRightComponent((Component) i);
            }

        } else {

            throw new NullPointerException("Could not set item. The name is null.");
        }
    }

    /**
     * Removes the child item from this item.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void remove(org.resmedicinae.resmedlib.term.String n) throws NullPointerException {

        try {
                
            if (n != null) {
    
                if (n.isEqualTo(SplitPane.LEFT_COMPONENT)) {
    
                    removeLeftComponent((Component) get(n));
                
                } else if (n.isEqualTo(SplitPane.RIGHT_COMPONENT)) {
    
                    removeRightComponent((Component) get(n));
                }

            } else {
    
                throw new NullPointerException("Could not remove item. The name is null.");
            }

        } finally {
            
            super.remove(n);
        }
    }

    //
    // Encapsulated java swing split pane.
    //
    
    /**
     * Creates an encapsulated java swing split pane.
     *
     * @return the encapsulated java swing split pane
     * @exception NullPointerException if the encapsulated java swing split pane is null
     */
    public java.lang.Object createJavaObject() throws NullPointerException {

        javax.swing.JSplitPane sp = new javax.swing.JSplitPane();

        if (sp != null) {

            sp.setOrientation(javax.swing.JSplitPane.HORIZONTAL_SPLIT);
            sp.setOneTouchExpandable(true);
            sp.setContinuousLayout(true);
            sp.setDividerLocation(200);
            sp.setPreferredSize(new java.awt.Dimension(800, 600));

        } else {

            throw new NullPointerException("Could not create encapsulated java swing split pane. The encapsulated java swing split pane is null.");
        }

        return sp;
    }

    //
    // Left component.
    //

    /**
     * Creates the left component.
     *
     * @return the left component
     * @exception NullPointerException if the left component is null
     */
    public Component createLeftComponent() throws Exception, NullPointerException {

        Panel p = new Panel();

        if (p != null) {

            p.globalize(get(SplitPane.GLOBALS));
            p.initialize();
            p.link();

        } else {

            throw new NullPointerException("Could not create left component. The left component is null.");
        }

        return p;
    }

    /**
     * Destroys the left component.
     *
     * @param c the left component
     * @exception NullPointerException if the left component is null
     */
    public void destroyLeftComponent(Component c) throws Exception, NullPointerException {

        if (c != null) {

            c.unlink();
            c.finalizz();
            c.deglobalize(get(SplitPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy left component. The left component is null.");
        }
    }

    /**
     * Sets the left component.
     *
     * @param c the left component
     * @exception NullPointerException if the java split pane is null
     * @exception NullPointerException if the left component is null
     */
    public void setLeftComponent(Component c) throws NullPointerException {

        javax.swing.JSplitPane sp = (javax.swing.JSplitPane) getJavaObject();

        if (sp != null) {

            if (c != null) {

                sp.setLeftComponent((java.awt.Component) c.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set left component. The left component is null.");
            }

        } else {

            throw new NullPointerException("Could not set left component. The java split pane is null.");
        }
    }

    /**
     * Removes the left component.
     *
     * @param c the left component
     * @exception NullPointerException if the java split pane is null
     * @exception NullPointerException if the left component is null
     */
    public void removeLeftComponent(Component c) throws NullPointerException {

        javax.swing.JSplitPane sp = (javax.swing.JSplitPane) getJavaObject();

        if (sp != null) {

            if (c != null) {

                sp.remove((java.awt.Component) c.getJavaObject());

            } else {

                throw new NullPointerException("Could not remove left component. The left component is null.");
            }

        } else {

            throw new NullPointerException("Could not remove left component. The java split pane is null.");
        }
    }

    //
    // Right component.
    //

    /**
     * Creates the right component.
     *
     * @return the right component
     * @exception NullPointerException if the right component is null
     */
    public Component createRightComponent() throws Exception, NullPointerException {

        Panel p = new Panel();

        if (p != null) {

            p.globalize(get(SplitPane.GLOBALS));
            p.initialize();
            p.link();

        } else {

            throw new NullPointerException("Could not create right component. The right component is null.");
        }

        return p;
    }

    /**
     * Destroys the right component.
     *
     * @param c the right component
     * @exception NullPointerException if the right component is null
     */
    public void destroyRightComponent(Component c) throws Exception, NullPointerException {

        if (c != null) {

            c.unlink();
            c.finalizz();
            c.deglobalize(get(SplitPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy right component. The right component is null.");
        }
    }

    /**
     * Sets the right component.
     *
     * @param c the right component
     * @exception NullPointerException if the java split pane is null
     * @exception NullPointerException if the right component is null
     */
    public void setRightComponent(Component c) throws NullPointerException {

        javax.swing.JSplitPane sp = (javax.swing.JSplitPane) getJavaObject();

        if (sp != null) {

            if (c != null) {

                sp.setRightComponent((java.awt.Component) c.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set right component. The right component is null.");
            }

        } else {

            throw new NullPointerException("Could not set right component. The java split pane is null.");
        }
    }

    /**
     * Removes the right component.
     *
     * @param c the right component
     * @exception NullPointerException if the java split pane is null
     * @exception NullPointerException if the right component is null
     */
    public void removeRightComponent(Component c) throws NullPointerException {

        javax.swing.JSplitPane sp = (javax.swing.JSplitPane) getJavaObject();

        if (sp != null) {

            if (c != null) {

                sp.remove((java.awt.Component) c.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not remove right component. The right component is null.");
            }

        } else {

            throw new NullPointerException("Could not remove right component. The java split pane is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this split pane.
     */
    public void initialize() throws Exception {

        super.initialize();

        set(SplitPane.LEFT_COMPONENT, createLeftComponent());
        set(SplitPane.RIGHT_COMPONENT, createRightComponent());
    }

    /**
     * Finalizes this split pane.
     */
    public void finalizz() throws Exception {

        try {

            destroyRightComponent((Component) get(SplitPane.RIGHT_COMPONENT));
            remove(SplitPane.RIGHT_COMPONENT);

            destroyLeftComponent((Component) get(SplitPane.LEFT_COMPONENT));
            remove(SplitPane.LEFT_COMPONENT);

        } finally {

            super.finalizz();
        }
    }
}

