/*
 * $RCSfile: ScrollPane.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.component.view.graphical.*;
import org.resmedicinae.resmedlib.region.view.*;

/**
 * This class represents a scroll pane.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ScrollPane extends GraphicalViewRegion {

    //
    // Static attribute ids.
    //

    /** The viewport id. */
    public static final org.resmedicinae.resmedlib.term.String VIEWPORT = new org.resmedicinae.resmedlib.term.String("viewport");

    /** The horizontal scroll bar id. */
    public static final org.resmedicinae.resmedlib.term.String HORIZONTAL_SCROLL_BAR = new org.resmedicinae.resmedlib.term.String("horizontal_scroll_bar");

    /** The vertical scroll bar id. */
    public static final org.resmedicinae.resmedlib.term.String VERTICAL_SCROLL_BAR = new org.resmedicinae.resmedlib.term.String("vertical_scroll_bar");

    /** The row header id. */
    public static final org.resmedicinae.resmedlib.term.String ROW_HEADER = new org.resmedicinae.resmedlib.term.String("row_header");

    /** The column header id. */
    public static final org.resmedicinae.resmedlib.term.String COLUMN_HEADER = new org.resmedicinae.resmedlib.term.String("column_header");

    /** The left top corner id. */
    public static final org.resmedicinae.resmedlib.term.String LEFT_TOP_CORNER = new org.resmedicinae.resmedlib.term.String("left_top_corner");

    /** The left bottom corner id. */
    public static final org.resmedicinae.resmedlib.term.String LEFT_BOTTOM_CORNER = new org.resmedicinae.resmedlib.term.String("left_bottom_corner");

    /** The right top corner id. */
    public static final org.resmedicinae.resmedlib.term.String RIGHT_TOP_CORNER = new org.resmedicinae.resmedlib.term.String("right_top_corner");

    /** The right bottom corner id. */
    public static final org.resmedicinae.resmedlib.term.String RIGHT_BOTTOM_CORNER = new org.resmedicinae.resmedlib.term.String("right_bottom_corner");

    //
    // Child management.
    //

    /**
     * Adds the item to become a child of this item.
     *
     * @param n the name
     * @param i the item
     * @exception NullPointerException if the name is null
     */
    public void set(org.resmedicinae.resmedlib.term.String n, Item i) throws NullPointerException {

        super.set(n, i);

        if (n != null) {

            if (n.isEqualTo(ScrollPane.VIEWPORT)) {

                setViewport((Viewport) i);

            } else if (n.isEqualTo(ScrollPane.HORIZONTAL_SCROLL_BAR)) {

                setHorizontalScrollBar((ScrollBar) i);

            } else if (n.isEqualTo(ScrollPane.VERTICAL_SCROLL_BAR)) {

                setVerticalScrollBar((ScrollBar) i);

            } else if (n.isEqualTo(ScrollPane.ROW_HEADER)) {

                setRowHeader((Viewport) i);

            } else if (n.isEqualTo(ScrollPane.COLUMN_HEADER)) {

                setColumnHeader((Viewport) i);

            } else if (n.isEqualTo(ScrollPane.LEFT_TOP_CORNER)) {

                setLeftTopCorner((Component) i);

            } else if (n.isEqualTo(ScrollPane.LEFT_BOTTOM_CORNER)) {

                setLeftBottomCorner((Component) i);

            } else if (n.isEqualTo(ScrollPane.RIGHT_TOP_CORNER)) {

                setRightTopCorner((Component) i);

            } else if (n.isEqualTo(ScrollPane.RIGHT_BOTTOM_CORNER)) {

                setRightBottomCorner((Component) i);
            }

        } else {

            throw new NullPointerException("Could not set item. The name is null.");
        }
    }

    /**
     * Removes the child item from this item.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void remove(org.resmedicinae.resmedlib.term.String n) throws NullPointerException {

        try {
                
            if (n != null) {
    
                if (n.isEqualTo(ScrollPane.VIEWPORT)) {
    
                    setViewport(null);
    
                } else if (n.isEqualTo(ScrollPane.HORIZONTAL_SCROLL_BAR)) {
    
                    setHorizontalScrollBar(null);
    
                } else if (n.isEqualTo(ScrollPane.VERTICAL_SCROLL_BAR)) {
    
                    setVerticalScrollBar(null);
    
                } else if (n.isEqualTo(ScrollPane.ROW_HEADER)) {
    
                    setRowHeader(null);
    
                } else if (n.isEqualTo(ScrollPane.COLUMN_HEADER)) {
    
                    setColumnHeader(null);
    
                } else if (n.isEqualTo(ScrollPane.LEFT_TOP_CORNER)) {
    
                    setLeftTopCorner(null);
    
                } else if (n.isEqualTo(ScrollPane.LEFT_BOTTOM_CORNER)) {
    
                    setLeftBottomCorner(null);
    
                } else if (n.isEqualTo(ScrollPane.RIGHT_TOP_CORNER)) {
    
                    setRightTopCorner(null);
    
                } else if (n.isEqualTo(ScrollPane.RIGHT_BOTTOM_CORNER)) {
    
                    setRightBottomCorner(null);
                }

            } else {
    
                throw new NullPointerException("Could not remove item. The name is null.");
            }

        } finally {
            
            super.remove(n);
        }
    }

    //
    // Encapsulated java swing scroll pane.
    //

    /**
     * Creates an encapsulated java swing scroll pane.
     *
     * @return the encapsulated java swing scroll pane
     * @exception NullPointerException if the encapsulated java swing scroll pane is null
     */
    public java.lang.Object createJavaObject() throws NullPointerException {

        javax.swing.JScrollPane sp = new javax.swing.JScrollPane();

        if (sp != null) {

        } else {

            throw new NullPointerException("Could not create encapsulated java swing scroll pane. The encapsulated java swing scroll pane is null.");
        }

        return sp;
    }

    //
    // Viewport.
    //

    /**
     * Creates the viewport.
     *
     * @return the viewport
     * @exception NullPointerException if the viewport is null
     */
    public Viewport createViewport() throws Exception, NullPointerException {

        Viewport vp = new Viewport();

        if (vp != null) {

            vp.globalize(get(ScrollPane.GLOBALS));
            vp.initialize();
            vp.link();

        } else {

            throw new NullPointerException("Could not create viewport. The viewport is null.");
        }

        return vp;
    }

    /**
     * Destroys the viewport.
     *
     * @param vp the viewport
     * @exception NullPointerException if the viewport is null
     */
    public void destroyViewport(Viewport vp) throws Exception, NullPointerException {

        if (vp != null) {

            vp.unlink();
            vp.finalizz();
            vp.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy viewport. The viewport is null.");
        }
    }

    /**
     * Sets the viewport.
     *
     * @param vp the viewport
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the viewport is null
     */
    public void setViewport(Viewport vp) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (vp != null) {

                sp.setViewport((javax.swing.JViewport) vp.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set viewport. The viewport is null.");
            }

        } else {

            throw new NullPointerException("Could not set viewport. The java scroll pane is null.");
        }
    }

    //
    // Horizontal scroll bar.
    //

    /**
     * Creates the horizontal scroll bar.
     *
     * @return the horizontal scroll bar
     * @exception NullPointerException if the horizontal scroll bar is null
     */
    public ScrollBar createHorizontalScrollBar() throws Exception, NullPointerException {

        ScrollBar sb = new ScrollBar();

        if (sb != null) {

            sb.globalize(get(ScrollPane.GLOBALS));
            sb.initialize();
            sb.link();

        } else {

            throw new NullPointerException("Could not create horizontal scroll bar. The horizontal scroll bar is null.");
        }

        return sb;
    }

    /**
     * Destroys the horizontal scroll bar.
     *
     * @param sb the horizontal scroll bar
     * @exception NullPointerException if the horizontal scroll bar is null
     */
    public void destroyHorizontalScrollBar(ScrollBar sb) throws Exception, NullPointerException {

        if (sb != null) {

            sb.unlink();
            sb.finalizz();
            sb.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy horizontal scroll bar. The horizontal scroll bar is null.");
        }
    }

    /**
     * Sets the horizontal scroll bar.
     *
     * @param sb the horizontal scroll bar
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the horizontal scroll bar is null
     */
    public void setHorizontalScrollBar(ScrollBar sb) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (sb != null) {

                sp.setHorizontalScrollBar((javax.swing.JScrollBar) sb.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set horizontal scroll bar. The horizontal scroll bar is null.");
            }

        } else {

            throw new NullPointerException("Could not set horizontal scroll bar. The java scroll pane is null.");
        }
    }

    //
    // Vertical scroll bar.
    //

    /**
     * Creates the vertical scroll bar.
     *
     * @return the vertical scroll bar
     * @exception NullPointerException if the vertical scroll bar is null
     */
    public ScrollBar createVerticalScrollBar() throws Exception, NullPointerException {

        ScrollBar sb = new ScrollBar();

        if (sb != null) {

            sb.globalize(get(ScrollPane.GLOBALS));
            sb.initialize();
            sb.link();

        } else {

            throw new NullPointerException("Could not create vertical scroll bar. The vertical scroll bar is null.");
        }

        return sb;
    }

    /**
     * Destroys the vertical scroll bar.
     *
     * @param sb the vertical scroll bar
     * @exception NullPointerException if the vertical scroll bar is null
     */
    public void destroyVerticalScrollBar(ScrollBar sb) throws Exception, NullPointerException {

        if (sb != null) {

            sb.unlink();
            sb.finalizz();
            sb.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy vertical scroll bar. The vertical scroll bar is null.");
        }
    }

    /**
     * Sets the vertical scroll bar.
     *
     * @param sb the vertical scroll bar
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the vertical scroll bar is null
     */
    public void setVerticalScrollBar(ScrollBar sb) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (sb != null) {

                sp.setVerticalScrollBar((javax.swing.JScrollBar) sb.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set vertical scroll bar. The vertical scroll bar is null.");
            }

        } else {

            throw new NullPointerException("Could not set vertical scroll bar. The java scroll pane is null.");
        }
    }

    //
    // Row header.
    //

    /**
     * Creates the row header.
     *
     * @return the row header
     * @exception NullPointerException if the row header is null
     */
    public Viewport createRowHeader() throws Exception, NullPointerException {

        Viewport rh = new Viewport();

        if (rh != null) {

            rh.globalize(get(ScrollPane.GLOBALS));
            rh.initialize();
            rh.link();

        } else {

            throw new NullPointerException("Could not create row header. The row header is null.");
        }

        return rh;
    }

    /**
     * Destroys the row header.
     *
     * @param rh the row header
     * @exception NullPointerException if the row header is null
     */
    public void destroyRowHeader(Viewport rh) throws Exception, NullPointerException {

        if (rh != null) {

            rh.unlink();
            rh.finalizz();
            rh.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy row header. The row header is null.");
        }
    }

    /**
     * Sets the row header.
     *
     * @param rh the row header
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the row header is null
     */
    public void setRowHeader(Viewport rh) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (rh != null) {

                sp.setRowHeader((javax.swing.JViewport) rh.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set row header. The row header is null.");
            }

        } else {

            throw new NullPointerException("Could not set row header. The java scroll pane is null.");
        }
    }

    //
    // Column header.
    //

    /**
     * Creates the column header.
     *
     * @return the column header
     * @exception NullPointerException if the column header is null
     */
    public Viewport createColumnHeader() throws Exception, NullPointerException {

        Viewport ch = new Viewport();

        if (ch != null) {

            ch.globalize(get(ScrollPane.GLOBALS));
            ch.initialize();
            ch.link();

        } else {

            throw new NullPointerException("Could not create column header. The column header is null.");
        }

        return ch;
    }

    /**
     * Destroys the column header.
     *
     * @param ch the column header
     * @exception NullPointerException if the column header is null
     */
    public void destroyColumnHeader(Viewport ch) throws Exception, NullPointerException {

        if (ch != null) {

            ch.unlink();
            ch.finalizz();
            ch.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy column header. The column header is null.");
        }
    }

    /**
     * Sets the column header.
     *
     * @param ch the column header
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the column header is null
     */
    public void setColumnHeader(Viewport ch) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (ch != null) {

                sp.setColumnHeader((javax.swing.JViewport) ch.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set column header. The column header is null.");
            }

        } else {

            throw new NullPointerException("Could not set column header. The java scroll pane is null.");
        }
    }

    //
    // Left top corner.
    //

    /**
     * Creates the left top corner.
     *
     * @return the left top corner
     * @exception NullPointerException if the left top corner is null
     */
    public Component createLeftTopCorner() throws Exception, NullPointerException {

        return null;
    }

    /**
     * Destroys the left top corner.
     *
     * @param c the left top corner
     * @exception NullPointerException if the left top corner is null
     */
    public void destroyLeftTopCorner(Component c) throws Exception, NullPointerException {

        if (c != null) {

            c.unlink();
            c.finalizz();
            c.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy left top corner. The left top corner is null.");
        }
    }

    /**
     * Sets the left top corner.
     *
     * @param c the left top corner
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the left top corner is null
     */
    public void setLeftTopCorner(Component c) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (c != null) {

                sp.setCorner(javax.swing.JScrollPane.UPPER_LEFT_CORNER, (java.awt.Component) c.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set left top corner. The left top corner is null.");
            }

        } else {

            throw new NullPointerException("Could not set left top corner. The java scroll pane is null.");
        }
    }

    //
    // Left bottom corner.
    //

    /**
     * Creates the left bottom corner.
     *
     * @return the left bottom corner
     * @exception NullPointerException if the left bottom corner is null
     */
    public Component createLeftBottomCorner() throws Exception, NullPointerException {

        return null;
    }

    /**
     * Destroys the left bottom corner.
     *
     * @param c the left bottom corner
     * @exception NullPointerException if the left bottom corner is null
     */
    public void destroyLeftBottomCorner(Component c) throws Exception, NullPointerException {

        if (c != null) {

            c.unlink();
            c.finalizz();
            c.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy left bottom corner. The left bottom corner is null.");
        }
    }

    /**
     * Sets the left bottom corner.
     *
     * @param c the left bottom corner
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the left bottom corner is null
     */
    public void setLeftBottomCorner(Component c) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (c != null) {

                sp.setCorner(javax.swing.JScrollPane.LOWER_LEFT_CORNER, (java.awt.Component) c.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set left bottom corner. The left bottom corner is null.");
            }

        } else {

            throw new NullPointerException("Could not set left bottom corner. The java scroll pane is null.");
        }
    }

    //
    // Right top corner.
    //

    /**
     * Creates the right top corner.
     *
     * @return the right top corner
     * @exception NullPointerException if the right top corner is null
     */
    public Component createRightTopCorner() throws Exception, NullPointerException {

        return null;
    }

    /**
     * Destroys the right top corner.
     *
     * @param c the right top corner
     * @exception NullPointerException if the right top corner is null
     */
    public void destroyRightTopCorner(Component c) throws Exception, NullPointerException {

        if (c != null) {

            c.unlink();
            c.finalizz();
            c.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy right top corner. The right top corner is null.");
        }
    }

    /**
     * Sets the right top corner.
     *
     * @param c the right top corner
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the right top corner is null
     */
    public void setRightTopCorner(Component c) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (c != null) {

                sp.setCorner(javax.swing.JScrollPane.UPPER_RIGHT_CORNER, (java.awt.Component) c.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set right top corner. The right top corner is null.");
            }

        } else {

            throw new NullPointerException("Could not set right top corner. The java scroll pane is null.");
        }
    }

    //
    // Right bottom corner.
    //

    /**
     * Creates the right bottom corner.
     *
     * @return the right bottom corner
     * @exception NullPointerException if the right bottom corner is null
     */
    public Component createRightBottomCorner() throws Exception, NullPointerException {

        return null;
    }

    /**
     * Destroys the right bottom corner.
     *
     * @param c the right bottom corner
     * @exception NullPointerException if the right bottom corner is null
     */
    public void destroyRightBottomCorner(Component c) throws Exception, NullPointerException {

        if (c != null) {

            c.unlink();
            c.finalizz();
            c.deglobalize(get(ScrollPane.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy right bottom corner. The right bottom corner is null.");
        }
    }

    /**
     * Sets the right bottom corner.
     *
     * @param c the right bottom corner
     * @exception NullPointerException if the java scroll pane is null
     * @exception NullPointerException if the right bottom corner is null
     */
    public void setRightBottomCorner(Component c) throws NullPointerException {

        javax.swing.JScrollPane sp = (javax.swing.JScrollPane) getJavaObject();

        if (sp != null) {

            if (c != null) {

                sp.setCorner(javax.swing.JScrollPane.LOWER_RIGHT_CORNER, (java.awt.Component) c.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set right bottom corner. The right bottom corner is null.");
            }

        } else {

            throw new NullPointerException("Could not set right bottom corner. The java scroll pane is null.");
        }
    }
}

