/*
 * $RCSfile: PortalContentsPanel.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical;

import org.resmedicinae.resmedlib.*;

/**
 * This class represents a portal contents panel.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class PortalContentsPanel extends ContentsPanel {

    //
    // Static attribute ids.
    //

    /** The portal split pane id. */
    public static final org.resmedicinae.resmedlib.term.String PORTAL_SPLIT_PANE = new org.resmedicinae.resmedlib.term.String("portal_split_pane");

    //
    // Child management.
    //

    /**
     * Adds the item to become a child of this item.
     *
     * @param n the name
     * @param i the item
     * @exception NullPointerException if the name is null
     */
    public void set(org.resmedicinae.resmedlib.term.String n, Item i) throws NullPointerException {

        super.set(n, i);

        if (n != null) {

            if (n.isEqualTo(PortalContentsPanel.PORTAL_SPLIT_PANE)) {

                setPortalSplitPane((PortalSplitPane) i);
            }

        } else {

            throw new NullPointerException("Could not set item. The name is null.");
        }
    }

    /**
     * Removes the child item from this item.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void remove(org.resmedicinae.resmedlib.term.String n) throws NullPointerException {

        try {
                
            if (n != null) {
    
                if (n.isEqualTo(PortalContentsPanel.PORTAL_SPLIT_PANE)) {
                    
                    setPortalSplitPane(null);
                }

            } else {
    
                throw new NullPointerException("Could not set item. The name is null.");
            }

        } finally {
            
            super.remove(n);
        }
    }

    //
    // Portal split pane.
    //

    /**
     * Creates the portal split pane.
     *
     * @return the portal split pane
     * @exception NullPointerException if the portal split pane is null
     */
    public PortalSplitPane createPortalSplitPane() throws Exception, NullPointerException {

        PortalSplitPane sp = new PortalSplitPane();

        if (sp != null) {

            sp.globalize(get(PortalContentsPanel.GLOBALS));
            sp.initialize();
            sp.link();

        } else {

            throw new NullPointerException("Could not create portal split pane. The portal split pane is null.");
        }

        return sp;
    }

    /**
     * Destroys the portal split pane.
     *
     * @param sp the portal split pane
     */
    public void destroyPortalSplitPane(PortalSplitPane sp) throws Exception, NullPointerException {

        if (sp != null) {

            sp.unlink();
            sp.finalizz();
            sp.deglobalize(get(PortalContentsPanel.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy portal split pane. The portal split pane is null.");
        }
    }

    /**
     * Sets the portal split pane.
     *
     * @param sp the portal split pane
     * @exception NullPointerException if the java panel is null
     * @exception NullPointerException if the portal split pane is null
     */
    public void setPortalSplitPane(PortalSplitPane sp) throws NullPointerException {

        javax.swing.JPanel p = (javax.swing.JPanel) getJavaObject();

        if (p != null) {

            if (sp != null) {

                p.add((javax.swing.JSplitPane) sp.getJavaObject(), java.awt.BorderLayout.CENTER);

            } else {
    
                throw new NullPointerException("Could not set portal split pane. The portal split pane is null.");
            }

        } else {

            throw new NullPointerException("Could not set portal split pane. The java panel is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this portal contents panel.
     */
    public void initialize() throws Exception {

        super.initialize();

        set(PortalContentsPanel.PORTAL_SPLIT_PANE, createPortalSplitPane());
    }

    /**
     * Finalizes this portal contents panel.
     */
    public void finalizz() throws Exception {

        try {

            destroyPortalSplitPane((PortalSplitPane) get(PortalContentsPanel.PORTAL_SPLIT_PANE));
            remove(PortalContentsPanel.PORTAL_SPLIT_PANE);

        } finally {

            super.finalizz();
        }
    }
}

