/*
 * $RCSfile: Panel.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.part.*;
import org.resmedicinae.resmedlib.region.view.*;

/**
 * This class represents a panel.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/11 17:48:19 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Panel extends GraphicalViewRegion {

    /** The layout id. */
    public static final org.resmedicinae.resmedlib.term.String LAYOUT = new org.resmedicinae.resmedlib.term.String("layout");

    //
    // Child management.
    //

    /**
     * Adds the item to become a child of this item.
     *
     * @param n the name
     * @param i the item
     * @exception NullPointerException if the name is null
     */
    public void set(org.resmedicinae.resmedlib.term.String n, Item i) throws NullPointerException {

        super.set(n, i);

        if (n != null) {

            if (n.isEqualTo(Panel.LAYOUT)) {

                setLayout((Layout) i);
            }

        } else {

            throw new NullPointerException("Could not set item. The name is null.");
        }
    }

    /**
     * Removes the child item from this item.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void remove(org.resmedicinae.resmedlib.term.String n) throws NullPointerException {

        try {
                
            if (n != null) {
    
                if (n.isEqualTo(Panel.LAYOUT)) {
                    
                    setLayout(null);
                }

            } else {
    
                throw new NullPointerException("Could not set item. The name is null.");
            }

        } finally {
            
            super.remove(n);
        }
    }

    //
    // Layout.
    //

    /**
     * Creates a layout.
     *
     * @return the layout
     * @exception NullPointerException if the layout is null
     */
    public Layout createLayout() throws Exception, NullPointerException {

        Layout l = new Layout();

        if (l != null) {

            l.initialize();

        } else {

            throw new NullPointerException("Could not create layout. The layout is null.");
        }
        
        return l;
    }

    /**
     * Destroys the layout.
     *
     * @param l the layout
     * @exception NullPointerException if the layout is null
     */
    public void destroyLayout(Layout l) throws Exception, NullPointerException {

        if (l != null) {

            l.finalizz();

        } else {

            throw new NullPointerException("Could not destroy layout. The layout is null.");
        }
    }

    /**
     * Sets the layout.
     *
     * @param l the layout
     * @exception NullPointerException if the java panel is null
     * @exception NullPointerException if the split pane is null
     */
    public void setLayout(Layout l) throws NullPointerException {

        javax.swing.JPanel p = (javax.swing.JPanel) getJavaObject();

        if (p != null) {

            if (l != null) {

                p.setLayout((java.awt.LayoutManager) l.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set split pane. The split pane is null.");
            }

        } else {

            throw new NullPointerException("Could not set split pane. The java panel is null.");
        }
    }

    //
    // Encapsulated java swing panel.
    //
    
    /**
     * Creates an encapsulated java swing panel.
     *
     * @return the encapsulated java swing panel
     */
    public java.lang.Object createJavaObject() {
        
        return new javax.swing.JPanel();
    }

    //
    // Initializable.
    //

    /**
     * Initializes this panel.
     */
    public void initialize() throws Exception {

        super.initialize();

        set(Panel.LAYOUT, createLayout());
    }

    /**
     * Finalizes this panel.
     */
    public void finalizz() throws Exception {

        try {

            destroyLayout((Layout) get(Panel.LAYOUT));
            remove(Panel.LAYOUT);

        } finally {

            super.finalizz();
        }
    }
}

