/*
 * $RCSfile: Menu.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.view.graphical;

import org.resmedicinae.resmedlib.*;
import org.resmedicinae.resmedlib.region.view.*;

/**
 * This class represents a menu.
 *
 * @version $Revision: 1.3 $ $Date: 2002/12/12 11:42:14 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Menu extends GraphicalViewRegion {

    //
    // Static attribute ids.
    //

    /** The label id. */
    public static final org.resmedicinae.resmedlib.term.String LABEL = new org.resmedicinae.resmedlib.term.String("label");

    //
    // Child management.
    //

    /**
     * Adds the item to become a child of this item.
     *
     * @param n the name
     * @param i the item
     * @exception NullPointerException if the name is null
     */
    public void set(org.resmedicinae.resmedlib.term.String n, Item i) throws NullPointerException {

        super.set(n, i);

        if (n != null) {

            if (n.isEqualTo(Menu.LABEL)) {

                setLabel((org.resmedicinae.resmedlib.term.String) i);
            }

        } else {

            throw new NullPointerException("Could not set item. The name is null.");
        }
    }

    /**
     * Removes the child item from this item.
     *
     * @param n the name
     * @exception NullPointerException if the name is null
     */
    public void remove(org.resmedicinae.resmedlib.term.String n) throws NullPointerException {

        try {
                
            if (n != null) {
    
                if (n.isEqualTo(Menu.LABEL)) {

                    removeLabel((org.resmedicinae.resmedlib.term.String) get(n));
                }

            } else {
    
                throw new NullPointerException("Could not remove item. The name is null.");
            }

        } finally {
            
            super.remove(n);
        }
    }

    //
    // Encapsulated java swing menu.
    //

    /**
     * Creates an encapsulated java swing menu.
     *
     * @return the encapsulated java swing menu
     * @exception NullPointerException if the encapsulated java swing menu is null
     */
    public java.lang.Object createJavaObject() throws NullPointerException {

        javax.swing.JMenu m = new javax.swing.JMenu();

        if (m != null) {

            m.setText("Menu");
            m.setEnabled(org.resmedicinae.resmedlib.digit.Boolean.TRUE);

        } else {

            throw new NullPointerException("Could not create encapsulated java swing menu. The encapsulated java swing menu is null.");
        }

        return m;
    }

    //
    // Label.
    //

    /**
     * Creates the label.
     *
     * @return the label
     * @exception NullPointerException if the label is null
     */
    public org.resmedicinae.resmedlib.term.String createLabel() throws Exception, NullPointerException {

        return new org.resmedicinae.resmedlib.term.String("Menu");

/**?? Introduce new Type for each String --> Terms --> Terminology!
        org.resmedicinae.resmedlib.term.String l = new org.resmedicinae.resmedlib.term.String();

        if (l != null) {

            l.globalize(get(Menu.GLOBALS));
            l.initialize();
            l.link();
            
        } else {

            throw new NullPointerException("Could not create label. The label is null.");
        }

        return l;
*/
    }

    /**
     * Destroys the label.
     *
     * @param l the label
     * @exception NullPointerException if the label is null
     */
    public void destroyLabel(org.resmedicinae.resmedlib.term.String l) throws Exception, NullPointerException {

/**?? Introduce new Type for each String --> Terms --> Terminology!
        if (l != null) {

            l.unlink();
            l.finalizz();
            l.deglobalize(get(Menu.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy label. The label is null.");
        }
*/
    }

    /**
     * Sets the label.
     *
     * @param l the label
     * @exception NullPointerException if the java abstract button is null
     * @exception NullPointerException if the label is null
     */
    public void setLabel(org.resmedicinae.resmedlib.term.String l) throws NullPointerException {

        javax.swing.AbstractButton b = (javax.swing.AbstractButton) getJavaObject();

        if (b != null) {

            if (l != null) {

                b.setText((java.lang.String) l.getJavaObject());

            } else {
    
                throw new NullPointerException("Could not set label. The label is null.");
            }

        } else {

            throw new NullPointerException("Could not set label. The java abstract button is null.");
        }
    }

    /**
     * Removes the label.
     *
     * @param l the label
     * @exception NullPointerException if the java abstract button is null
     * @exception NullPointerException if the label is null
     */
    public void removeLabel(org.resmedicinae.resmedlib.term.String l) throws NullPointerException {

        javax.swing.AbstractButton b = (javax.swing.AbstractButton) getJavaObject();

        if (b != null) {

            if (l != null) {

                b.setText(null);

            } else {
    
                throw new NullPointerException("Could not remove label. The label is null.");
            }

        } else {

            throw new NullPointerException("Could not remove label. The java abstract button is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this split pane.
     */
    public void initialize() throws Exception {

        super.initialize();

        set(Menu.LABEL, createLabel());
    }

    /**
     * Finalizes this split pane.
     */
    public void finalizz() throws Exception {

        try {

            destroyLabel((org.resmedicinae.resmedlib.term.String) get(Menu.LABEL));
            remove(Menu.LABEL);

        } finally {

            super.finalizz();
        }
    }
}

