/*
 * $RCSfile: PersistenceModel.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.resmedlib.region.model;

import org.resmedicinae.resmedlib.region.*;

/**
 * This class represents a data transfer model.
 *
 * A data transfer model is a special, simplified model to be used for
 * data transfer between remote machines. It has a reduced number of
 * attributes/methods to ease and speed up communication.
 *
 * @version $Revision: 1.2 $ $Date: 2002/12/03 13:24:30 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class PersistenceModel extends Model {

    public static final String MODEL_KEY = "PERSISTENCE_MODEL_KEY";

    public void initialize() throws Exception {
        try {
            super.initialize();
        } catch (Exception e) {
            throw new Exception(e);
        }
    }

}
