/*
 * $RCSfile: ViewDecoder.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.controller.decoder;

import org.resmedicinae.resmedlib.component.controller.*;
import org.resmedicinae.resmedlib.region.controller.*;

/**
 * This class represents a view decoder.
 *
 * @version $Revision: 1.1 $ $Date: 2002/12/19 12:35:32 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ViewDecoder extends Decoder {

    //
    // Static attribute ids.
    //

    /** The menu item sensor id. */
    public static final org.resmedicinae.resmedlib.term.String MENU_ITEM_SENSOR = new org.resmedicinae.resmedlib.term.String("menu_item_sensor");

    //
    // Menu item sensor.
    //

    /**
     * Creates the menu item sensor.
     *
     * @return the menu item sensor
     * @exception NullPointerException if the menu item sensor is null
     */
    public MenuItemSensor createMenuItemSensor() throws Exception, NullPointerException {

        MenuItemSensor s = new MenuItemSensor();

        if (s != null) {

            s.globalize(get(ViewDecoder.GLOBALS));
            s.initialize();
            s.link();
            
        } else {

            throw new NullPointerException("Could not create menu item sensor. The menu item sensor is null.");
        }

        return s;
    }

    /**
     * Destroys the menu item sensor.
     *
     * @param s the menu item sensor
     * @exception NullPointerException if the menu item sensor is null
     */
    public void destroyMenuItemSensor(MenuItemSensor s) throws Exception, NullPointerException {

        if (s != null) {

            s.unlink();
            s.finalizz();
            s.deglobalize(get(ViewDecoder.GLOBALS));

        } else {

            throw new NullPointerException("Could not destroy menu item sensor. The menu item sensor is null.");
        }
    }

    //
    // Initializable.
    //

    /**
     * Initializes this view sensor.
     */
    public void initialize() throws Exception {

        super.initialize();

        set(ViewDecoder.MENU_ITEM_SENSOR, createMenuItemSensor());
    }

    /**
     * Finalizes this view sensor.
     */
    public void finalizz() throws Exception {

        try {

            destroyMenuItemSensor((MenuItemSensor) get(ViewDecoder.MENU_ITEM_SENSOR));
            remove(ViewDecoder.MENU_ITEM_SENSOR);

        } finally {

            super.finalizz();
        }
    }
}

