/*
 * $RCSfile: Processor.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.controller;

import org.resmedicinae.resmedlib.region.*;
import org.resmedicinae.resmedlib.region.model.*;
import org.resmedicinae.resmedlib.term.String;

/**
 * This class represents a processor.
 *
 * A processor corresponds to the region in a human brain which is
 * responsible for actually processing signals.<br><br>
 * [German: "Groszhirnrinde"]
 *
 * A processor can be called by sensors if special processings have to be done.
 * Such processings can be algorithms, fuzzy logic or even neural network
 * calculations.
 * The processor is then responsible for forwarding the signal and results
 * to a motor.
 *
 * @version $Revision: 1.9 $ $Date: 2002/12/18 17:11:28 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Processor extends ControllerRegion {

    //
    // Processing.
    //

    /**
     * Processes the operation on domain data.
     *
     * @param o the operation
     * @param m the domain model
     * @return the domain model
     * @exception NullPointerException if the ?? is null
     */
    public DomainModel process(String o, DomainModel m) throws Exception, NullPointerException {
        
        return null;
    }
}

