/*
 * $RCSfile: Encoder.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.resmedlib.region.controller;

import org.resmedicinae.resmedlib.chain.*;
import org.resmedicinae.resmedlib.region.*;
import org.resmedicinae.resmedlib.region.model.*;

/**
 * This class represents an encoder.
 *
 * It can be used to encode a domain model into any kind of data model.
 *
 * An encoder corresponds to the motoric nerve system of a human being.
 * For example, the brain center for muscle control encodes abstract domain model data
 * of our brain into a specific data model controlling a muscle reaction.
 *
 * Synonyms: Assembler, Mapper, Motor 
 *
 * @version $Revision: 1.3 $ $Date: 2002/12/18 17:11:27 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class Encoder extends ControllerRegion {

    //
    // Attributes.
    //

    /** The formatter. */
    private java.util.logging.Formatter formatter;

    /** The output stream. */
    private java.io.OutputStream outputStream;

    /** The writer. */
    private java.io.Writer writer;

    //
    // Formatter.
    //

    /**
     * Creates a formatter.
     *
     * @return the formatter
     * @exception NullPointerException if the formatter is null
     */
    public java.util.logging.Formatter createFormatter() throws NullPointerException {

        java.util.logging.Formatter f = new java.util.logging.SimpleFormatter();

        if (f != null)
        {

//??            f.initialize();

        }
        else
        {

            throw new NullPointerException("Could not create formatter. The formatter is null.");
        }

        return f;
    }

    /**
     * Destroys the formatter.
     *
     * @param f the formatter
     * @exception NullPointerException if the formatter is null
     */
    public void destroyFormatter(java.util.logging.Formatter f) throws NullPointerException
    {

        if (f != null)
        {

//??            f.finalizz();

        }
        else
        {

            throw new NullPointerException("Could not destroy formatter. The formatter is null.");
        }
    }

    /**
     * Sets the formatter.
     *
     * @param f the formatter
     */
    public void setFormatter(java.util.logging.Formatter f)
    {

        this.formatter = f;
    }

    /**
     * Returns the formatter.
     *
     * @return the formatter
     */
    public java.util.logging.Formatter getFormatter()
    {

        return this.formatter;
    }

    //
    // Output stream.
    //

    /**
     * Creates an output stream.
     *
     * @return the output stream
     * @exception NullPointerException if the output stream is null
     */
    public java.io.OutputStream createOutputStream() throws NullPointerException
    {

        java.io.OutputStream s = java.lang.System.err; //?? new java.io.OutputStream();

        if (s != null)
        {

//??            s.initialize();

        }
        else
        {

            throw new NullPointerException("Could not create output stream. The output stream is null.");
        }

        return s;
    }

    /**
     * Destroys the output stream.
     *
     * @param s the output stream
     * @exception NullPointerException if the output stream is null
     */
    public void destroyOutputStream(java.io.OutputStream s) throws NullPointerException
    {

        if (s != null)
        {

//??            s.finalizz();

        }
        else
        {

            throw new NullPointerException("Could not destroy output stream. The output stream is null.");
        }
    }

    /**
     * Sets the output stream.
     *
     * @param s the output stream
     */
    public void setOutputStream(java.io.OutputStream s)
    {

        this.outputStream = s;
    }

    /**
     * Returns the output stream.
     *
     * @return the output stream
     */
    public java.io.OutputStream getOutputStream()
    {

        return this.outputStream;
    }

    //
    // Writer.
    //

    /**
     * Creates a writer.
     *
     * @return the writer
     * @exception NullPointerException if the writer is null
     */
    public java.io.Writer createWriter() throws NullPointerException
    {

        java.io.Writer w = new java.io.OutputStreamWriter(getOutputStream());

        if (w != null)
        {

//??            w.initialize();

        }
        else
        {

            throw new NullPointerException("Could not create writer. The writer is null.");
        }

        return w;
    }

    /**
     * Destroys the writer.
     *
     * @param w the writer
     * @exception NullPointerException if the writer is null
     */
    public void destroyWriter(java.io.Writer w) throws NullPointerException
    {

        if (w != null)
        {

//??            w.finalizz();

        }
        else
        {

            throw new NullPointerException("Could not destroy writer. The writer is null.");
        }
    }

    /**
     * Sets the writer.
     *
     * @param w the writer
     */
    public void setWriter(java.io.Writer w)
    {

        this.writer = w;
    }

    /**
     * Returns the writer.
     *
     * @return the writer
     */
    public java.io.Writer getWriter()
    {

        return this.writer;
    }

    //
    // Initializable.
    //

    /**
     * Initializes this motor.
     */
    public void initialize() throws Exception {

        super.initialize();

        setFormatter(createFormatter());
        setOutputStream(createOutputStream());
        setWriter(createWriter());
    }

    /**
     * Finalizes this motor.
     */
    public void finalizz() throws Exception {

        try {

            destroyWriter(getWriter());
            setWriter(null);
            destroyOutputStream(getOutputStream());
            setOutputStream(null);
            destroyFormatter(getFormatter());
            setFormatter(null);

        } finally {

            super.finalizz();
        }
    }

    //
    // Linkable.
    //

    /**
     * Links this motor.
     */
    public void link() throws Exception {
    }

    /**
     * Unlinks this motor.
     */
    public void unlink() throws Exception {
    }

    //
    // Encoding.
    //

    /**
     * Encodes the domain model.
     *
     * @param m the uncoded domain model
     * @return the encoded data model
     */
    public Model encode(DomainModel m) {

        return null;
    }

    //
    // Driving the motoric process.
    //

    /**
     * Drives the log record output.
     *
     * @param r the log record
     * @exception NullPointerException if the formatter is null
     * @exception NullPointerException if the writer is null
     */
    public void drive(LogRecord r) throws Exception, NullPointerException {

        java.util.logging.Formatter f = getFormatter();

        if (f != null) {

            String msg = "Empty test log message."; //?? f.format(r);
            java.io.Writer w = getWriter();

            if (w != null) {

//??                w.write(f.getHead(this));
                w.write(msg);
                w.flush();
                w.close();

            } else {

                throw new NullPointerException("Could not drive log record output. The writer is null.");
            }
        
        } else {

            throw new NullPointerException("Could not drive log record output. The formatter is null.");
        }
    }
}

